# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictBytes, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from cyperf.models.api_link import APILink
from cyperf.models.conflict import Conflict
from cyperf.models.params import Params
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class CertConfig(BaseModel):
    """
    CertConfig
    """ # noqa: E501
    certificate_file: Optional[Params] = Field(default=None, description="The certificate file of the TLS profile.", alias="certificateFile")
    dh_file: Optional[Params] = Field(default=None, alias="dhFile")
    get_sni_conflicts: Optional[List[Union[StrictBytes, StrictStr]]] = Field(default=None, alias="get-sni-conflicts")
    _get_sni_conflicts_json_schema_extra: dict = PrivateAttr(default={"x-operation": "-,GetSNICertConflicts" })
    id: StrictStr
    is_playlist: Optional[StrictBool] = Field(default=None, alias="isPlaylist")
    key_file: Optional[Params] = Field(default=None, description="The key file of the TLS profile.", alias="keyFile")
    key_file_password: Optional[StrictStr] = Field(default=None, description="The key file password of the TLS profile.", alias="keyFilePassword")
    links: Optional[List[APILink]] = None
    playlist_column_name: Optional[StrictStr] = Field(default=None, alias="playlistColumnName")
    playlist_filename: Optional[StrictStr] = Field(default=None, alias="playlistFilename")
    resolve_sni_conflicts: Optional[List[Conflict]] = Field(default=None, alias="resolve-sni-conflicts")
    _resolve_sni_conflicts_json_schema_extra: dict = PrivateAttr(default={"x-operation": "-,ResolveSNIConflicts" })
    sni_hostname: StrictStr = Field(description="The SNI hostname associated with the certificate. (default: generic.keysight.io).", alias="sniHostname")
    __properties: ClassVar[List[str]] = ["certificateFile", "dhFile", "get-sni-conflicts", "id", "isPlaylist", "keyFile", "keyFilePassword", "links", "playlistColumnName", "playlistFilename", "resolve-sni-conflicts", "sniHostname"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CertConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of certificate_file
        if self.certificate_file:
            _dict['certificateFile'] = self.certificate_file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dh_file
        if self.dh_file:
            _dict['dhFile'] = self.dh_file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of key_file
        if self.key_file:
            _dict['keyFile'] = self.key_file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in resolve_sni_conflicts (list)
        _items = []
        if self.resolve_sni_conflicts:
            for _item in self.resolve_sni_conflicts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['resolve-sni-conflicts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CertConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "certificateFile": Params.from_dict(obj["certificateFile"]) if obj.get("certificateFile") is not None else None,
                        "dhFile": Params.from_dict(obj["dhFile"]) if obj.get("dhFile") is not None else None,
                        "get-sni-conflicts": obj.get("get-sni-conflicts"),
                        "id": obj.get("id"),
                        "isPlaylist": obj.get("isPlaylist"),
                        "keyFile": Params.from_dict(obj["keyFile"]) if obj.get("keyFile") is not None else None,
                        "keyFilePassword": obj.get("keyFilePassword"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
                        "playlistColumnName": obj.get("playlistColumnName"),
                        "playlistFilename": obj.get("playlistFilename"),
                        "resolve-sni-conflicts": [Conflict.from_dict(_item) for _item in obj["resolve-sni-conflicts"]] if obj.get("resolve-sni-conflicts") is not None else None,
                        "sniHostname": obj.get("sniHostname")
            ,
            "links": obj.get("links")
        })
        return _obj


