# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class Certificate(BaseModel):
    """
    Certificate
    """ # noqa: E501
    auto: Optional[StrictBool] = None
    dns_names: Optional[List[StrictStr]] = Field(default=None, alias="dnsNames")
    ip_addresses: Optional[List[StrictStr]] = Field(default=None, alias="ipAddresses")
    issuer: Optional[StrictStr] = None
    not_after: Optional[StrictStr] = Field(default=None, alias="notAfter")
    not_before: Optional[StrictStr] = Field(default=None, alias="notBefore")
    valid_for: Optional[StrictInt] = Field(default=None, alias="validFor")
    __properties: ClassVar[List[str]] = ["auto", "dnsNames", "ipAddresses", "issuer", "notAfter", "notBefore", "validFor"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Certificate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "issuer",
            "not_after",
            "not_before",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Certificate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "auto": obj.get("auto"),
                        "dnsNames": obj.get("dnsNames"),
                        "ipAddresses": obj.get("ipAddresses"),
                        "issuer": obj.get("issuer"),
                        "notAfter": obj.get("notAfter"),
                        "notBefore": obj.get("notBefore"),
                        "validFor": obj.get("validFor")
            ,
            "links": obj.get("links")
        })
        return _obj


