# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBytes, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from cyperf.models.api_link import APILink
from cyperf.models.application_profile import ApplicationProfile
from cyperf.models.attack_profile import AttackProfile
from cyperf.models.config_validation import ConfigValidation
from cyperf.models.custom_dashboards import CustomDashboards
from cyperf.models.expected_disk_space import ExpectedDiskSpace
from cyperf.models.network_profile import NetworkProfile
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class Config(BaseModel):
    """
    The test configuration
    """ # noqa: E501
    attack_profiles: Optional[List[AttackProfile]] = Field(default=None, alias="AttackProfiles")
    config_validation: Optional[ConfigValidation] = Field(default=None, alias="ConfigValidation")
    custom_dashboards: Optional[CustomDashboards] = Field(default=None, alias="CustomDashboards")
    expected_disk_space: Optional[List[ExpectedDiskSpace]] = Field(default=None, alias="ExpectedDiskSpace")
    network_profiles: Optional[List[NetworkProfile]] = Field(default=None, alias="NetworkProfiles")
    traffic_profiles: Optional[List[ApplicationProfile]] = Field(default=None, alias="TrafficProfiles")
    links: Optional[List[APILink]] = None
    validate: Optional[List[Union[StrictBytes, StrictStr]]] = None
    _validate_json_schema_extra: dict = PrivateAttr(default={"x-operation": "-,ValidateConfig" })
    __properties: ClassVar[List[str]] = ["AttackProfiles", "ConfigValidation", "CustomDashboards", "ExpectedDiskSpace", "NetworkProfiles", "TrafficProfiles", "links", "validate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Config from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attack_profiles (list)
        _items = []
        if self.attack_profiles:
            for _item in self.attack_profiles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['AttackProfiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of config_validation
        if self.config_validation:
            _dict['ConfigValidation'] = self.config_validation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of custom_dashboards
        if self.custom_dashboards:
            _dict['CustomDashboards'] = self.custom_dashboards.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in expected_disk_space (list)
        _items = []
        if self.expected_disk_space:
            for _item in self.expected_disk_space:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ExpectedDiskSpace'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in network_profiles (list)
        _items = []
        if self.network_profiles:
            for _item in self.network_profiles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['NetworkProfiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in traffic_profiles (list)
        _items = []
        if self.traffic_profiles:
            for _item in self.traffic_profiles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['TrafficProfiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Config from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "AttackProfiles": [AttackProfile.from_dict(_item) for _item in obj["AttackProfiles"]] if obj.get("AttackProfiles") is not None else None,
                        "ConfigValidation": ConfigValidation.from_dict(obj["ConfigValidation"]) if obj.get("ConfigValidation") is not None else None,
                        "CustomDashboards": CustomDashboards.from_dict(obj["CustomDashboards"]) if obj.get("CustomDashboards") is not None else None,
                        "ExpectedDiskSpace": [ExpectedDiskSpace.from_dict(_item) for _item in obj["ExpectedDiskSpace"]] if obj.get("ExpectedDiskSpace") is not None else None,
                        "NetworkProfiles": [NetworkProfile.from_dict(_item) for _item in obj["NetworkProfiles"]] if obj.get("NetworkProfiles") is not None else None,
                        "TrafficProfiles": [ApplicationProfile.from_dict(_item) for _item in obj["TrafficProfiles"]] if obj.get("TrafficProfiles") is not None else None,
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
                        "validate": obj.get("validate")
            ,
            "links": obj.get("links")
        })
        return _obj


