# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.api_link import APILink
from cyperf.models.params import Params
from cyperf.models.port_settings import PortSettings
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class Connection(BaseModel):
    """
    Connection
    """ # noqa: E501
    client_endpoint: StrictStr = Field(description="The client endpoint of the connection.", alias="ClientEndpoint")
    client_port: StrictInt = Field(description="The client port of the connection (default: 80).", alias="ClientPort")
    closing_end: Optional[StrictStr] = Field(default=None, alias="ClosingEnd")
    disable_encryption: Optional[StrictBool] = Field(default=None, description="If true, the connection will be unencrypted regardless of other TLS settings.", alias="DisableEncryption")
    hostname: Optional[StrictStr] = Field(default=None, description="The hostname associated with the connection. (default: generic.keysight.io).", alias="Hostname")
    hostname_param: Optional[Params] = Field(default=None, description="The hostname associated with the connection. (default: generic.keysight.io).", alias="HostnameParam")
    http_forward_proxy_mode: Optional[StrictStr] = Field(default=None, description="Deprecated. This is ignored and the proxy mode will be deduced from the connection type.", alias="HttpForwardProxyMode")
    is_deprecated: Optional[StrictBool] = Field(default=None, alias="IsDeprecated")
    max_transactions: StrictInt = Field(description="The maximum number of transactions for this connection.", alias="MaxTransactions")
    name: Optional[StrictStr] = Field(default=None, description="The name of the Connection.", alias="Name")
    port_settings: Optional[PortSettings] = Field(default=None, alias="PortSettings")
    readonly: Optional[StrictBool] = Field(default=None, description="If true, the connection can't be modified by the user.", alias="Readonly")
    readonly_hostname: Optional[StrictBool] = Field(default=None, description="If true, the connection hostname will be readonly.", alias="ReadonlyHostname")
    readonly_max_trans: Optional[StrictBool] = Field(default=None, description="If true, MaxTransactions will be readonly", alias="ReadonlyMaxTrans")
    readonly_type: Optional[StrictBool] = Field(default=None, description="If true or missing, the type of the connection cannot be changed", alias="ReadonlyType")
    server_endpoint: Optional[StrictStr] = Field(default=None, description="The server endpoint of the connection.", alias="ServerEndpoint")
    server_port: StrictInt = Field(description="The server port of the connection (default: 80).", alias="ServerPort")
    type: Optional[StrictStr] = Field(default=None, alias="Type")
    id: StrictStr
    links: Optional[List[APILink]] = None
    __properties: ClassVar[List[str]] = ["ClientEndpoint", "ClientPort", "ClosingEnd", "DisableEncryption", "Hostname", "HostnameParam", "HttpForwardProxyMode", "IsDeprecated", "MaxTransactions", "Name", "PortSettings", "Readonly", "ReadonlyHostname", "ReadonlyMaxTrans", "ReadonlyType", "ServerEndpoint", "ServerPort", "Type", "id", "links"]

    @field_validator('http_forward_proxy_mode')
    def http_forward_proxy_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['INHERIT_DUT', 'PROXY_MODE', 'TUNNEL_MODE']):
            raise ValueError("must be one of enum values ('INHERIT_DUT', 'PROXY_MODE', 'TUNNEL_MODE')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['http', 'https', 'tcp', 'tls', 'udp', 'ssl']):
            raise ValueError("must be one of enum values ('http', 'https', 'tcp', 'tls', 'udp', 'ssl')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Connection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of hostname_param
        if self.hostname_param:
            _dict['HostnameParam'] = self.hostname_param.to_dict()
        # override the default output from pydantic by calling `to_dict()` of port_settings
        if self.port_settings:
            _dict['PortSettings'] = self.port_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Connection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "ClientEndpoint": obj.get("ClientEndpoint"),
                        "ClientPort": obj.get("ClientPort"),
                        "ClosingEnd": obj.get("ClosingEnd"),
                        "DisableEncryption": obj.get("DisableEncryption"),
                        "Hostname": obj.get("Hostname"),
                        "HostnameParam": Params.from_dict(obj["HostnameParam"]) if obj.get("HostnameParam") is not None else None,
                        "HttpForwardProxyMode": obj.get("HttpForwardProxyMode"),
                        "IsDeprecated": obj.get("IsDeprecated"),
                        "MaxTransactions": obj.get("MaxTransactions"),
                        "Name": obj.get("Name"),
                        "PortSettings": PortSettings.from_dict(obj["PortSettings"]) if obj.get("PortSettings") is not None else None,
                        "Readonly": obj.get("Readonly"),
                        "ReadonlyHostname": obj.get("ReadonlyHostname"),
                        "ReadonlyMaxTrans": obj.get("ReadonlyMaxTrans"),
                        "ReadonlyType": obj.get("ReadonlyType"),
                        "ServerEndpoint": obj.get("ServerEndpoint"),
                        "ServerPort": obj.get("ServerPort"),
                        "Type": obj.get("Type"),
                        "id": obj.get("id"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


