# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.api_link import APILink
from cyperf.models.consumer import Consumer
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class DiskUsage(BaseModel):
    """
    DiskUsage
    """ # noqa: E501
    available: Optional[StrictInt] = Field(default=None, description="The currently available disk space (in bytes)")
    consumers: Optional[List[Consumer]] = Field(default=None, description="A list of consumers for handling logs and diagnostics storage")
    critical_disk_space: Optional[StrictBool] = Field(default=None, description="A flag indicating whether disk space is critical i.e the application may become unstable", alias="criticalDiskSpace")
    critical_threshold: Optional[StrictInt] = Field(default=None, description="The critical disk threshold (in bytes)", alias="criticalThreshold")
    links: Optional[List[APILink]] = None
    low_disk_space: Optional[StrictBool] = Field(default=None, description="A flag indicating whether disk space is low", alias="lowDiskSpace")
    low_threshold: Optional[StrictInt] = Field(default=None, description="The low disk threshold (in bytes)", alias="lowThreshold")
    message: Optional[StrictStr] = Field(default=None, description="A user-friendly message about disk usage")
    pretty_available: Optional[StrictStr] = Field(default=None, description="The currently available disk space in human-readable format", alias="prettyAvailable")
    pretty_size: Optional[StrictStr] = Field(default=None, description="The total disk size in human-readable format", alias="prettySize")
    size: Optional[StrictInt] = Field(default=None, description="The total disk size (in bytes)")
    __properties: ClassVar[List[str]] = ["available", "consumers", "criticalDiskSpace", "criticalThreshold", "links", "lowDiskSpace", "lowThreshold", "message", "prettyAvailable", "prettySize", "size"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DiskUsage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "available",
            "critical_disk_space",
            "critical_threshold",
            "low_disk_space",
            "low_threshold",
            "message",
            "pretty_available",
            "pretty_size",
            "size",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in consumers (list)
        _items = []
        if self.consumers:
            for _item in self.consumers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['consumers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DiskUsage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "available": obj.get("available"),
                        "consumers": [Consumer.from_dict(_item) for _item in obj["consumers"]] if obj.get("consumers") is not None else None,
                        "criticalDiskSpace": obj.get("criticalDiskSpace"),
                        "criticalThreshold": obj.get("criticalThreshold"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
                        "lowDiskSpace": obj.get("lowDiskSpace"),
                        "lowThreshold": obj.get("lowThreshold"),
                        "message": obj.get("message"),
                        "prettyAvailable": obj.get("prettyAvailable"),
                        "prettySize": obj.get("prettySize"),
                        "size": obj.get("size")
            ,
            "links": obj.get("links")
        })
        return _obj


