# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.add_input import AddInput
from cyperf.models.delete_input import DeleteInput
from cyperf.models.edit_action_input import EditActionInput
from cyperf.models.parameter import Parameter
from cyperf.models.rename_input import RenameInput
from cyperf.models.reorder_action_input import ReorderActionInput
from cyperf.models.reorder_exchanges_input import ReorderExchangesInput
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class EditAppOperation(BaseModel):
    """
    EditAppOperation
    """ # noqa: E501
    add_inputs: Optional[List[AddInput]] = Field(default=None, alias="AddInputs")
    app_id: Optional[StrictStr] = Field(default=None, alias="AppId")
    app_name: Optional[StrictStr] = Field(default=None, alias="AppName")
    app_parameters: Optional[List[Parameter]] = Field(default=None, alias="AppParameters")
    delete_inputs: Optional[List[DeleteInput]] = Field(default=None, alias="DeleteInputs")
    edit_action_inputs: Optional[List[EditActionInput]] = Field(default=None, alias="EditActionInputs")
    rename_inputs: Optional[List[RenameInput]] = Field(default=None, alias="RenameInputs")
    reorder_actions_inputs: Optional[List[ReorderActionInput]] = Field(default=None, alias="ReorderActionsInputs")
    reorder_exchanges_inputs: Optional[List[ReorderExchangesInput]] = Field(default=None, alias="ReorderExchangesInputs")
    __properties: ClassVar[List[str]] = ["AddInputs", "AppId", "AppName", "AppParameters", "DeleteInputs", "EditActionInputs", "RenameInputs", "ReorderActionsInputs", "ReorderExchangesInputs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EditAppOperation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in add_inputs (list)
        _items = []
        if self.add_inputs:
            for _item in self.add_inputs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['AddInputs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in app_parameters (list)
        _items = []
        if self.app_parameters:
            for _item in self.app_parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['AppParameters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in delete_inputs (list)
        _items = []
        if self.delete_inputs:
            for _item in self.delete_inputs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['DeleteInputs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in edit_action_inputs (list)
        _items = []
        if self.edit_action_inputs:
            for _item in self.edit_action_inputs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['EditActionInputs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in rename_inputs (list)
        _items = []
        if self.rename_inputs:
            for _item in self.rename_inputs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['RenameInputs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in reorder_actions_inputs (list)
        _items = []
        if self.reorder_actions_inputs:
            for _item in self.reorder_actions_inputs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ReorderActionsInputs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in reorder_exchanges_inputs (list)
        _items = []
        if self.reorder_exchanges_inputs:
            for _item in self.reorder_exchanges_inputs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ReorderExchangesInputs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EditAppOperation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "AddInputs": [AddInput.from_dict(_item) for _item in obj["AddInputs"]] if obj.get("AddInputs") is not None else None,
                        "AppId": obj.get("AppId"),
                        "AppName": obj.get("AppName"),
                        "AppParameters": [Parameter.from_dict(_item) for _item in obj["AppParameters"]] if obj.get("AppParameters") is not None else None,
                        "DeleteInputs": [DeleteInput.from_dict(_item) for _item in obj["DeleteInputs"]] if obj.get("DeleteInputs") is not None else None,
                        "EditActionInputs": [EditActionInput.from_dict(_item) for _item in obj["EditActionInputs"]] if obj.get("EditActionInputs") is not None else None,
                        "RenameInputs": [RenameInput.from_dict(_item) for _item in obj["RenameInputs"]] if obj.get("RenameInputs") is not None else None,
                        "ReorderActionsInputs": [ReorderActionInput.from_dict(_item) for _item in obj["ReorderActionsInputs"]] if obj.get("ReorderActionsInputs") is not None else None,
                        "ReorderExchangesInputs": [ReorderExchangesInput.from_dict(_item) for _item in obj["ReorderExchangesInputs"]] if obj.get("ReorderExchangesInputs") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


