# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cyperf.models.api_link import APILink
from cyperf.models.static_arp_entry import StaticARPEntry
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class EthRange(BaseModel):
    """
    The Ethernet Ranges assigned to the current test configuration
    """ # noqa: E501
    count: Optional[StrictInt] = Field(default=None, alias="Count")
    mac_auto: StrictBool = Field(description="A flag indicating if the MAC address for the EthRange should be determined automatically (default: true).", alias="MacAuto")
    mac_incr: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The MAC address increment rule for the EthRange (default: 00:00:00:00:00:01).", alias="MacIncr")
    mac_start: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The MAC start address for the EthRange (default: 00:11:01:00:00:01).", alias="MacStart")
    one_mac_per_ip: Optional[StrictBool] = Field(default=None, description="A flag indicating if there is only one MAC address for the EthRange per IPRange (default: true).", alias="OneMacPerIP")
    static_arp_table: Optional[List[StaticARPEntry]] = Field(default=None, alias="StaticARPTable")
    links: Optional[List[APILink]] = None
    max_count_per_agent: Optional[StrictInt] = Field(default=None, description="The maximum number of MACs that should be assigned to each traffic agent for this Ethernet range segment in a valid test (default: 0, split equally between agents).", alias="maxCountPerAgent")
    __properties: ClassVar[List[str]] = ["Count", "MacAuto", "MacIncr", "MacStart", "OneMacPerIP", "StaticARPTable", "links", "maxCountPerAgent"]

    @field_validator('mac_incr')
    def mac_incr_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^$|(^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$)", value):
            raise ValueError(r"must validate the regular expression /^$|(^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$)/")
        return value

    @field_validator('mac_start')
    def mac_start_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^$|(^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$)", value):
            raise ValueError(r"must validate the regular expression /^$|(^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$)/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EthRange from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in static_arp_table (list)
        _items = []
        if self.static_arp_table:
            for _item in self.static_arp_table:
                if _item:
                    _items.append(_item.to_dict())
            _dict['StaticARPTable'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EthRange from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "Count": obj.get("Count"),
                        "MacAuto": obj.get("MacAuto"),
                        "MacIncr": obj.get("MacIncr"),
                        "MacStart": obj.get("MacStart"),
                        "OneMacPerIP": obj.get("OneMacPerIP"),
                        "StaticARPTable": [StaticARPEntry.from_dict(_item) for _item in obj["StaticARPTable"]] if obj.get("StaticARPTable") is not None else None,
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
                        "maxCountPerAgent": obj.get("maxCountPerAgent")
            ,
            "links": obj.get("links")
        })
        return _obj


