# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.export_files_request import ExportFilesRequest
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class ExportFilesOperationInput(BaseModel):
    """
    ExportFilesOperationInput
    """ # noqa: E501
    export_files_requests_by_agent: Optional[Dict[str, List[ExportFilesRequest]]] = Field(default=None, alias="exportFilesRequestsByAgent")
    timeout: Optional[StrictInt] = Field(default=None, description="Maximum waiting time in seconds to complete the agent file export operation")
    __properties: ClassVar[List[str]] = ["exportFilesRequestsByAgent", "timeout"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExportFilesOperationInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in export_files_requests_by_agent (dict of array)
        _field_dict_of_array = {}
        if self.export_files_requests_by_agent:
            for _key in self.export_files_requests_by_agent:
                if self.export_files_requests_by_agent[_key] is not None:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.export_files_requests_by_agent[_key]
                    ]
            _dict['exportFilesRequestsByAgent'] = _field_dict_of_array
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExportFilesOperationInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "exportFilesRequestsByAgent": dict(
                (_k,
                        [ExportFilesRequest.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("exportFilesRequestsByAgent", {}).items()
            ),
                        "timeout": obj.get("timeout")
            ,
            "links": obj.get("links")
        })
        return _obj


