# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from cyperf.models.feature_reservation import FeatureReservation
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class Feature(BaseModel):
    """
    Feature information
    """ # noqa: E501
    count: StrictInt = Field(description="The feature count")
    feature_type: StrictStr = Field(description="The feature type:   * `nodeLocked` - Node-locked on the host running the license server   * `floating`    - Allows concurrent users ", alias="featureType")
    is_uncounted: StrictBool = Field(description="Feature is uncounted or not", alias="isUncounted")
    name: StrictStr = Field(description="The feature name")
    reservation: FeatureReservation
    __properties: ClassVar[List[str]] = ["count", "featureType", "isUncounted", "name", "reservation"]

    @field_validator('feature_type')
    def feature_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['nodeLocked', 'floating']):
            raise ValueError("must be one of enum values ('nodeLocked', 'floating')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Feature from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of reservation
        if self.reservation:
            _dict['reservation'] = self.reservation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Feature from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "count": obj.get("count"),
                        "featureType": obj.get("featureType"),
                        "isUncounted": obj.get("isUncounted"),
                        "name": obj.get("name"),
                        "reservation": FeatureReservation.from_dict(obj["reservation"]) if obj.get("reservation") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


