# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictBytes, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from cyperf.models.attack_metadata_keywords_inner import AttackMetadataKeywordsInner
from cyperf.models.file_metadata import FileMetadata
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class GenericFile(BaseModel):
    """
    GenericFile
    """ # noqa: E501
    content: Optional[Union[StrictBytes, StrictStr]] = Field(default=None, description="The content of the file")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the file")
    is_public: Optional[StrictBool] = Field(default=None, description="Indicates if the resource is accessible by all users.", alias="isPublic")
    md5: Optional[StrictStr] = Field(default=None, description="The md5 value of the file")
    metadata: Optional[FileMetadata] = None
    name: Optional[StrictStr] = Field(default=None, description="The name of the file")
    options: Optional[Dict[str, AttackMetadataKeywordsInner]] = Field(default=None, description="The characteristics of the file")
    owner: Optional[StrictStr] = Field(default=None, description="The user-visible name of the file's owner")
    owner_id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the file's owner", alias="ownerId")
    reference_links: Optional[Dict[str, StrictInt]] = Field(default=None, alias="referenceLinks")
    size: Optional[StrictInt] = Field(default=None, description="The size of the file")
    type: Optional[StrictStr] = Field(default=None, description="The type of file")
    __properties: ClassVar[List[str]] = ["content", "id", "isPublic", "md5", "metadata", "name", "options", "owner", "ownerId", "referenceLinks", "size", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GenericFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "owner",
            "owner_id",
            "type",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in options (dict)
        _field_dict = {}
        if self.options:
            for _key in self.options:
                if self.options[_key]:
                    _field_dict[_key] = self.options[_key].to_dict()
            _dict['options'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GenericFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "content": obj.get("content"),
                        "id": obj.get("id"),
                        "isPublic": obj.get("isPublic"),
                        "md5": obj.get("md5"),
                        "metadata": FileMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
                        "name": obj.get("name"),
                        "options": dict(
                (_k, AttackMetadataKeywordsInner.from_dict(_v))
                for _k, _v in obj["options"].items()
            )
            if obj.get("options") is not None
            else None,
                        "owner": obj.get("owner"),
                        "ownerId": obj.get("ownerId"),
                        "referenceLinks": obj.get("referenceLinks"),
                        "size": obj.get("size"),
                        "type": obj.get("type")
            ,
            "links": obj.get("links")
        })
        return _obj


