# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.category_filter import CategoryFilter
from cyperf.models.sort_body_field import SortBodyField
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class GetStrikesOperation(BaseModel):
    """
    GetStrikesOperation
    """ # noqa: E501
    categories: Optional[List[CategoryFilter]] = None
    compatible_with: Optional[StrictStr] = Field(default=None, alias="compatibleWith")
    filter_mode: Optional[StrictStr] = Field(default=None, alias="filterMode")
    search_col: Optional[List[StrictStr]] = Field(default=None, alias="searchCol")
    search_val: Optional[List[StrictStr]] = Field(default=None, alias="searchVal")
    skip: Optional[StrictStr] = None
    sort: Optional[List[SortBodyField]] = None
    take: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["categories", "compatibleWith", "filterMode", "searchCol", "searchVal", "skip", "sort", "take"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetStrikesOperation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in categories (list)
        _items = []
        if self.categories:
            for _item in self.categories:
                if _item:
                    _items.append(_item.to_dict())
            _dict['categories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sort (list)
        _items = []
        if self.sort:
            for _item in self.sort:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sort'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetStrikesOperation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "categories": [CategoryFilter.from_dict(_item) for _item in obj["categories"]] if obj.get("categories") is not None else None,
                        "compatibleWith": obj.get("compatibleWith"),
                        "filterMode": obj.get("filterMode"),
                        "searchCol": obj.get("searchCol"),
                        "searchVal": obj.get("searchVal"),
                        "skip": obj.get("skip"),
                        "sort": [SortBodyField.from_dict(_item) for _item in obj["sort"]] if obj.get("sort") is not None else None,
                        "take": obj.get("take")
            ,
            "links": obj.get("links")
        })
        return _obj


