# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cyperf.models.agent_assignments import AgentAssignments
from cyperf.models.api_link import APILink
from cyperf.models.dns_resolver import DNSResolver
from cyperf.models.dns_server import DNSServer
from cyperf.models.emulated_router import EmulatedRouter
from cyperf.models.eth_range import EthRange
from cyperf.models.ip_range import IPRange
from cyperf.models.ip_sec_stack import IPSecStack
from cyperf.models.mac_dtls_stack import MacDtlsStack
from cyperf.models.tunnel_stack import TunnelStack
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class IPNetwork(BaseModel):
    """
    The IP network configuration
    """ # noqa: E501
    name: Annotated[str, Field(strict=True)] = Field(alias="Name")
    id: StrictStr
    network_tags: Optional[List[StrictStr]] = Field(default=None, description="A list of tags.", alias="networkTags")
    dns_resolver: Optional[DNSResolver] = Field(default=None, alias="DNSResolver")
    dns_server: Optional[DNSServer] = Field(default=None, description="The DNS Server configuration for Network Segment", alias="DNSServer")
    dut_connections: Optional[List[StrictStr]] = Field(default=None, description="The connected DUT network segments.", alias="DUTConnections")
    emulated_router: Optional[EmulatedRouter] = Field(default=None, alias="EmulatedRouter")
    eth_range: Optional[EthRange] = Field(default=None, alias="EthRange")
    ip_ranges: Optional[List[IPRange]] = Field(default=None, alias="IPRanges")
    ip_sec_stacks: Optional[List[IPSecStack]] = Field(default=None, alias="IPSecStacks")
    mac_dtls_stacks: Optional[List[MacDtlsStack]] = Field(default=None, alias="MacDtlsStacks")
    tunnel_stacks: Optional[List[TunnelStack]] = Field(default=None, alias="TunnelStacks")
    active: Optional[StrictBool] = Field(default=None, description="A flag indicating if the network segment is active.(default: true)")
    agent_assignments: Optional[AgentAssignments] = Field(default=None, alias="agentAssignments")
    links: Optional[List[APILink]] = None
    min_agents: Optional[StrictInt] = Field(default=None, description="The minimum number of agents that should be assigned to this network segment in a valid test (default: 1).", alias="minAgents")
    __properties: ClassVar[List[str]] = ["Name", "id", "networkTags", "DNSResolver", "DNSServer", "DUTConnections", "EmulatedRouter", "EthRange", "IPRanges", "IPSecStacks", "MacDtlsStacks", "TunnelStacks", "active", "agentAssignments", "links", "minAgents"]

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^$|^[^\"\\]+$", value):
            raise ValueError(r"must validate the regular expression /^$|^[^\"\\]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IPNetwork from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dns_resolver
        if self.dns_resolver:
            _dict['DNSResolver'] = self.dns_resolver.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dns_server
        if self.dns_server:
            _dict['DNSServer'] = self.dns_server.to_dict()
        # override the default output from pydantic by calling `to_dict()` of emulated_router
        if self.emulated_router:
            _dict['EmulatedRouter'] = self.emulated_router.to_dict()
        # override the default output from pydantic by calling `to_dict()` of eth_range
        if self.eth_range:
            _dict['EthRange'] = self.eth_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ip_ranges (list)
        _items = []
        if self.ip_ranges:
            for _item in self.ip_ranges:
                if _item:
                    _items.append(_item.to_dict())
            _dict['IPRanges'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ip_sec_stacks (list)
        _items = []
        if self.ip_sec_stacks:
            for _item in self.ip_sec_stacks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['IPSecStacks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in mac_dtls_stacks (list)
        _items = []
        if self.mac_dtls_stacks:
            for _item in self.mac_dtls_stacks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['MacDtlsStacks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tunnel_stacks (list)
        _items = []
        if self.tunnel_stacks:
            for _item in self.tunnel_stacks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['TunnelStacks'] = _items
        # override the default output from pydantic by calling `to_dict()` of agent_assignments
        if self.agent_assignments:
            _dict['agentAssignments'] = self.agent_assignments.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IPNetwork from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
                        "id": obj.get("id"),
                        "networkTags": obj.get("networkTags"),
                        "DNSResolver": DNSResolver.from_dict(obj["DNSResolver"]) if obj.get("DNSResolver") is not None else None,
                        "DNSServer": DNSServer.from_dict(obj["DNSServer"]) if obj.get("DNSServer") is not None else None,
                        "EmulatedRouter": EmulatedRouter.from_dict(obj["EmulatedRouter"]) if obj.get("EmulatedRouter") is not None else None,
                        "EthRange": EthRange.from_dict(obj["EthRange"]) if obj.get("EthRange") is not None else None,
                        "EthRange": obj.get("EthRange"),
                        "IPRanges": [IPRange.from_dict(_item) for _item in obj["IPRanges"]] if obj.get("IPRanges") is not None else None,
                        "IPSecStacks": [IPSecStack.from_dict(_item) for _item in obj["IPSecStacks"]] if obj.get("IPSecStacks") is not None else None,
                        "MacDtlsStacks": [MacDtlsStack.from_dict(_item) for _item in obj["MacDtlsStacks"]] if obj.get("MacDtlsStacks") is not None else None,
                        "TunnelStacks": [TunnelStack.from_dict(_item) for _item in obj["TunnelStacks"]] if obj.get("TunnelStacks") is not None else None,
                        "active": obj.get("active"),
                        "agentAssignments": AgentAssignments.from_dict(obj["agentAssignments"]) if obj.get("agentAssignments") is not None else None,
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
                        "minAgents": obj.get("minAgents")
            ,
            "links": obj.get("links")
        })
        return _obj


