# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cyperf.models.api_link import APILink
from cyperf.models.authentication_settings import AuthenticationSettings
from cyperf.models.p1_config import P1Config
from cyperf.models.p2_config import P2Config
from cyperf.models.protected_subnet_config import ProtectedSubnetConfig
from cyperf.models.remote_access import RemoteAccess
from cyperf.models.remote_subnet_config import RemoteSubnetConfig
from cyperf.models.timers import Timers
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class IPSecRange(BaseModel):
    """
    IPSecRange
    """ # noqa: E501
    var_auth_settings: Optional[AuthenticationSettings] = Field(default=None, alias="AuthSettings")
    ike_phase1_config: Optional[P1Config] = Field(default=None, alias="IKEPhase1Config")
    ike_phase2_config: Optional[P2Config] = Field(default=None, alias="IKEPhase2Config")
    ip_sec_range_name: Annotated[str, Field(strict=True)] = Field(alias="IPSecRangeName")
    multi_p2_over_p1: Optional[StrictBool] = Field(default=None, alias="MultiP2OverP1")
    protected_sub_config: Optional[ProtectedSubnetConfig] = Field(default=None, description="Deeprecated. Use RemoteSubConfig instead.", alias="ProtectedSubConfig")
    public_peer: Annotated[str, Field(strict=True)] = Field(alias="PublicPeer")
    public_peer_increment: Annotated[str, Field(strict=True)] = Field(alias="PublicPeerIncrement")
    remote_access: Optional[RemoteAccess] = Field(default=None, alias="RemoteAccess")
    remote_sub_config: Optional[RemoteSubnetConfig] = Field(default=None, alias="RemoteSubConfig")
    test_scenario: StrictStr = Field(alias="TestScenario")
    timers: Optional[Timers] = Field(default=None, alias="Timers")
    tunnel_count_per_outer_ip: StrictInt = Field(alias="TunnelCountPerOuterIP")
    id: StrictStr
    links: Optional[List[APILink]] = None
    __properties: ClassVar[List[str]] = ["AuthSettings", "IKEPhase1Config", "IKEPhase2Config", "IPSecRangeName", "MultiP2OverP1", "ProtectedSubConfig", "PublicPeer", "PublicPeerIncrement", "RemoteAccess", "RemoteSubConfig", "TestScenario", "Timers", "TunnelCountPerOuterIP", "id", "links"]

    @field_validator('ip_sec_range_name')
    def ip_sec_range_name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^$|^[^\"\\]+$", value):
            raise ValueError(r"must validate the regular expression /^$|^[^\"\\]+$/")
        return value

    @field_validator('public_peer')
    def public_peer_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^$|(^(((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))|(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|(([0-9a-fA-F]{1,4}:){5,5}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}|([0-9a-fA-F]{1,4}:){1,4}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){2,2}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){3,3}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){4,4})|:(:[0-9a-fA-F]{1,4}){1,5}):((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])))$)", value):
            raise ValueError(r"must validate the regular expression /^$|(^(((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))|(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|(([0-9a-fA-F]{1,4}:){5,5}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}|([0-9a-fA-F]{1,4}:){1,4}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){2,2}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){3,3}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){4,4})|:(:[0-9a-fA-F]{1,4}){1,5}):((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])))$)/")
        return value

    @field_validator('public_peer_increment')
    def public_peer_increment_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^$|(^(((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))|(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|(([0-9a-fA-F]{1,4}:){5,5}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}|([0-9a-fA-F]{1,4}:){1,4}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){2,2}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){3,3}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){4,4})|:(:[0-9a-fA-F]{1,4}){1,5}):((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])))$)", value):
            raise ValueError(r"must validate the regular expression /^$|(^(((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))|(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|(([0-9a-fA-F]{1,4}:){5,5}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}|([0-9a-fA-F]{1,4}:){1,4}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){2,2}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){3,3}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){4,4})|:(:[0-9a-fA-F]{1,4}){1,5}):((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])))$)/")
        return value

    @field_validator('test_scenario')
    def test_scenario_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['REMOTE-ACCESS', 'SITE-TO-SITE']):
            raise ValueError("must be one of enum values ('REMOTE-ACCESS', 'SITE-TO-SITE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IPSecRange from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of var_auth_settings
        if self.var_auth_settings:
            _dict['AuthSettings'] = self.var_auth_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ike_phase1_config
        if self.ike_phase1_config:
            _dict['IKEPhase1Config'] = self.ike_phase1_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ike_phase2_config
        if self.ike_phase2_config:
            _dict['IKEPhase2Config'] = self.ike_phase2_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of protected_sub_config
        if self.protected_sub_config:
            _dict['ProtectedSubConfig'] = self.protected_sub_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of remote_access
        if self.remote_access:
            _dict['RemoteAccess'] = self.remote_access.to_dict()
        # override the default output from pydantic by calling `to_dict()` of remote_sub_config
        if self.remote_sub_config:
            _dict['RemoteSubConfig'] = self.remote_sub_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of timers
        if self.timers:
            _dict['Timers'] = self.timers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IPSecRange from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "AuthSettings": AuthenticationSettings.from_dict(obj["AuthSettings"]) if obj.get("AuthSettings") is not None else None,
                        "IKEPhase1Config": P1Config.from_dict(obj["IKEPhase1Config"]) if obj.get("IKEPhase1Config") is not None else None,
                        "IKEPhase2Config": P2Config.from_dict(obj["IKEPhase2Config"]) if obj.get("IKEPhase2Config") is not None else None,
                        "IPSecRangeName": obj.get("IPSecRangeName"),
                        "MultiP2OverP1": obj.get("MultiP2OverP1"),
                        "ProtectedSubConfig": ProtectedSubnetConfig.from_dict(obj["ProtectedSubConfig"]) if obj.get("ProtectedSubConfig") is not None else None,
                        "PublicPeer": obj.get("PublicPeer"),
                        "PublicPeerIncrement": obj.get("PublicPeerIncrement"),
                        "RemoteAccess": RemoteAccess.from_dict(obj["RemoteAccess"]) if obj.get("RemoteAccess") is not None else None,
                        "RemoteSubConfig": RemoteSubnetConfig.from_dict(obj["RemoteSubConfig"]) if obj.get("RemoteSubConfig") is not None else None,
                        "TestScenario": obj.get("TestScenario"),
                        "Timers": Timers.from_dict(obj["Timers"]) if obj.get("Timers") is not None else None,
                        "TunnelCountPerOuterIP": obj.get("TunnelCountPerOuterIP"),
                        "id": obj.get("id"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


