# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cyperf.models.api_link import APILink
from cyperf.models.emulated_subnet_config import EmulatedSubnetConfig
from cyperf.models.ip_range import IPRange
from cyperf.models.ip_sec_range import IPSecRange
from cyperf.models.local_subnet_config import LocalSubnetConfig
from cyperf.models.params import Params
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class IPSecStack(BaseModel):
    """
    IPSecStack
    """ # noqa: E501
    ca_certificate_file: Optional[Params] = Field(default=None, description="The authentication CA certificate file of the IPsec tunnel(s).", alias="CACertificateFile")
    emulated_sub_config: Optional[EmulatedSubnetConfig] = Field(default=None, description="Deeprecated. Use LocalSubConfig instead.", alias="EmulatedSubConfig")
    enable_rekey: StrictBool = Field(alias="EnableRekey")
    ip_sec_range: Optional[IPSecRange] = Field(default=None, alias="IPSecRange")
    ip_sec_stack_name: Annotated[str, Field(strict=True)] = Field(alias="IPSecStackName")
    local_sub_config: Optional[LocalSubnetConfig] = Field(default=None, alias="LocalSubConfig")
    log_keys: StrictBool = Field(alias="LogKeys")
    max_initiation_rate: StrictInt = Field(alias="MaxInitiationRate")
    max_pending: StrictInt = Field(alias="MaxPending")
    outer_ip_range: Optional[IPRange] = Field(default=None, alias="OuterIPRange")
    rekey_margin: StrictInt = Field(alias="RekeyMargin")
    rekey_retry_count: StrictInt = Field(alias="RekeyRetryCount")
    retransmission_timeout: StrictInt = Field(alias="RetransmissionTimeout")
    retry_count: StrictInt = Field(alias="RetryCount")
    retry_interval: Optional[StrictInt] = Field(default=None, alias="RetryInterval")
    retry_interval_increment: Optional[StrictInt] = Field(default=None, alias="RetryIntervalIncrement")
    setup_timeout: StrictInt = Field(alias="SetupTimeout")
    stack_role: StrictStr = Field(alias="StackRole")
    id: StrictStr
    links: Optional[List[APILink]] = None
    __properties: ClassVar[List[str]] = ["CACertificateFile", "EmulatedSubConfig", "EnableRekey", "IPSecRange", "IPSecStackName", "LocalSubConfig", "LogKeys", "MaxInitiationRate", "MaxPending", "OuterIPRange", "RekeyMargin", "RekeyRetryCount", "RetransmissionTimeout", "RetryCount", "RetryInterval", "RetryIntervalIncrement", "SetupTimeout", "StackRole", "id", "links"]

    @field_validator('ip_sec_stack_name')
    def ip_sec_stack_name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^$|^[^\"\\]+$", value):
            raise ValueError(r"must validate the regular expression /^$|^[^\"\\]+$/")
        return value

    @field_validator('stack_role')
    def stack_role_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['INITIATOR', 'RESPONDER']):
            raise ValueError("must be one of enum values ('INITIATOR', 'RESPONDER')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IPSecStack from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ca_certificate_file
        if self.ca_certificate_file:
            _dict['CACertificateFile'] = self.ca_certificate_file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of emulated_sub_config
        if self.emulated_sub_config:
            _dict['EmulatedSubConfig'] = self.emulated_sub_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ip_sec_range
        if self.ip_sec_range:
            _dict['IPSecRange'] = self.ip_sec_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of local_sub_config
        if self.local_sub_config:
            _dict['LocalSubConfig'] = self.local_sub_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of outer_ip_range
        if self.outer_ip_range:
            _dict['OuterIPRange'] = self.outer_ip_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IPSecStack from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "CACertificateFile": Params.from_dict(obj["CACertificateFile"]) if obj.get("CACertificateFile") is not None else None,
                        "EmulatedSubConfig": EmulatedSubnetConfig.from_dict(obj["EmulatedSubConfig"]) if obj.get("EmulatedSubConfig") is not None else None,
                        "EnableRekey": obj.get("EnableRekey"),
                        "IPSecRange": IPSecRange.from_dict(obj["IPSecRange"]) if obj.get("IPSecRange") is not None else None,
                        "IPSecStackName": obj.get("IPSecStackName"),
                        "LocalSubConfig": LocalSubnetConfig.from_dict(obj["LocalSubConfig"]) if obj.get("LocalSubConfig") is not None else None,
                        "LogKeys": obj.get("LogKeys"),
                        "MaxInitiationRate": obj.get("MaxInitiationRate"),
                        "MaxPending": obj.get("MaxPending"),
                        "OuterIPRange": IPRange.from_dict(obj["OuterIPRange"]) if obj.get("OuterIPRange") is not None else None,
                        "RekeyMargin": obj.get("RekeyMargin"),
                        "RekeyRetryCount": obj.get("RekeyRetryCount"),
                        "RetransmissionTimeout": obj.get("RetransmissionTimeout"),
                        "RetryCount": obj.get("RetryCount"),
                        "RetryInterval": obj.get("RetryInterval"),
                        "RetryIntervalIncrement": obj.get("RetryIntervalIncrement"),
                        "SetupTimeout": obj.get("SetupTimeout"),
                        "StackRole": obj.get("StackRole"),
                        "id": obj.get("id"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


