# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cyperf.models.api_link import APILink
from cyperf.models.ip_range import IPRange
from cyperf.models.network_meshing import NetworkMeshing
from cyperf.models.vlan_range import VLANRange
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class MacDtlsStack(BaseModel):
    """
    MacDtlsStack
    """ # noqa: E501
    dtls_enabled: Optional[StrictBool] = Field(default=None, alias="DTLSEnabled")
    dtls_range_name: Annotated[str, Field(strict=True)] = Field(alias="DTLSRangeName")
    epoch: StrictInt = Field(alias="Epoch")
    epoch_incr: Optional[StrictInt] = Field(default=None, alias="EpochIncr")
    ip_range: Optional[IPRange] = Field(default=None, alias="IPRange")
    in_iv: Annotated[str, Field(strict=True)] = Field(description="The in IV start for the DTLSRange (default: 0x22222222).", alias="InIV")
    in_iv_incr: Annotated[str, Field(strict=True)] = Field(description="The in IV increment for the DTLSRange (default: 0x00000001).", alias="InIVIncr")
    in_key: Annotated[str, Field(strict=True)] = Field(description="The in key start for the DTLSRange (default: 0xBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB).", alias="InKey")
    in_key_incr: Annotated[str, Field(strict=True)] = Field(description="The in key increment for the DTLSRange (default: 0x0000000000000000000000000000000000000000000000000000000000000001).", alias="InKeyIncr")
    network_meshing: Optional[NetworkMeshing] = Field(default=None, alias="NetworkMeshing")
    out_iv: Annotated[str, Field(strict=True)] = Field(description="The out IV start for the DTLSRange (default: 0x11111111).", alias="OutIV")
    out_iv_incr: Annotated[str, Field(strict=True)] = Field(description="The out IV increment for the DTLSRange (default: 0x00000001).", alias="OutIVIncr")
    out_key: Annotated[str, Field(strict=True)] = Field(description="The out key start for the DTLSRange (default: 0xAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA).", alias="OutKey")
    out_key_incr: Annotated[str, Field(strict=True)] = Field(description="The out key start for the DTLSRange (default: 0x0000000000000000000000000000000000000000000000000000000000000001).", alias="OutKeyIncr")
    tunnel_count: StrictInt = Field(alias="TunnelCount")
    tunnel_destination_mac_incr: Annotated[str, Field(strict=True)] = Field(description="The MAC address increment rule for the DTLSRange (default: 00:00:00:00:00:01).", alias="TunnelDestinationMacIncr")
    tunnel_destination_mac_start: Annotated[str, Field(strict=True)] = Field(description="The MAC start address for the DTLSRange (default: AA:BB:CC:DD:EE:FF).", alias="TunnelDestinationMacStart")
    vlan_range: Optional[VLANRange] = Field(default=None, description="The inner VLAN range assigned to the current DTLS Range configuration", alias="VlanRange")
    id: StrictStr
    links: Optional[List[APILink]] = None
    __properties: ClassVar[List[str]] = ["DTLSEnabled", "DTLSRangeName", "Epoch", "EpochIncr", "IPRange", "InIV", "InIVIncr", "InKey", "InKeyIncr", "NetworkMeshing", "OutIV", "OutIVIncr", "OutKey", "OutKeyIncr", "TunnelCount", "TunnelDestinationMacIncr", "TunnelDestinationMacStart", "VlanRange", "id", "links"]

    @field_validator('dtls_range_name')
    def dtls_range_name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^$|^[^\"\\]+$", value):
            raise ValueError(r"must validate the regular expression /^$|^[^\"\\]+$/")
        return value

    @field_validator('in_iv')
    def in_iv_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0x[A-Fa-f0-9]{8}$", value):
            raise ValueError(r"must validate the regular expression /^0x[A-Fa-f0-9]{8}$/")
        return value

    @field_validator('in_iv_incr')
    def in_iv_incr_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0x[A-Fa-f0-9]{8}$", value):
            raise ValueError(r"must validate the regular expression /^0x[A-Fa-f0-9]{8}$/")
        return value

    @field_validator('in_key')
    def in_key_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0x[A-Fa-f0-9]{64}$", value):
            raise ValueError(r"must validate the regular expression /^0x[A-Fa-f0-9]{64}$/")
        return value

    @field_validator('in_key_incr')
    def in_key_incr_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0x[A-Fa-f0-9]{64}$", value):
            raise ValueError(r"must validate the regular expression /^0x[A-Fa-f0-9]{64}$/")
        return value

    @field_validator('out_iv')
    def out_iv_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0x[A-Fa-f0-9]{8}$", value):
            raise ValueError(r"must validate the regular expression /^0x[A-Fa-f0-9]{8}$/")
        return value

    @field_validator('out_iv_incr')
    def out_iv_incr_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0x[A-Fa-f0-9]{8}$", value):
            raise ValueError(r"must validate the regular expression /^0x[A-Fa-f0-9]{8}$/")
        return value

    @field_validator('out_key')
    def out_key_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0x[A-Fa-f0-9]{64}$", value):
            raise ValueError(r"must validate the regular expression /^0x[A-Fa-f0-9]{64}$/")
        return value

    @field_validator('out_key_incr')
    def out_key_incr_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0x[A-Fa-f0-9]{64}$", value):
            raise ValueError(r"must validate the regular expression /^0x[A-Fa-f0-9]{64}$/")
        return value

    @field_validator('tunnel_destination_mac_incr')
    def tunnel_destination_mac_incr_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^$|(^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$)", value):
            raise ValueError(r"must validate the regular expression /^$|(^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$)/")
        return value

    @field_validator('tunnel_destination_mac_start')
    def tunnel_destination_mac_start_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^$|(^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$)", value):
            raise ValueError(r"must validate the regular expression /^$|(^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$)/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MacDtlsStack from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ip_range
        if self.ip_range:
            _dict['IPRange'] = self.ip_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_meshing
        if self.network_meshing:
            _dict['NetworkMeshing'] = self.network_meshing.to_dict()
        # override the default output from pydantic by calling `to_dict()` of vlan_range
        if self.vlan_range:
            _dict['VlanRange'] = self.vlan_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MacDtlsStack from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "DTLSEnabled": obj.get("DTLSEnabled"),
                        "DTLSRangeName": obj.get("DTLSRangeName"),
                        "Epoch": obj.get("Epoch"),
                        "EpochIncr": obj.get("EpochIncr"),
                        "IPRange": IPRange.from_dict(obj["IPRange"]) if obj.get("IPRange") is not None else None,
                        "InIV": obj.get("InIV"),
                        "InIVIncr": obj.get("InIVIncr"),
                        "InKey": obj.get("InKey"),
                        "InKeyIncr": obj.get("InKeyIncr"),
                        "NetworkMeshing": NetworkMeshing.from_dict(obj["NetworkMeshing"]) if obj.get("NetworkMeshing") is not None else None,
                        "OutIV": obj.get("OutIV"),
                        "OutIVIncr": obj.get("OutIVIncr"),
                        "OutKey": obj.get("OutKey"),
                        "OutKeyIncr": obj.get("OutKeyIncr"),
                        "TunnelCount": obj.get("TunnelCount"),
                        "TunnelDestinationMacIncr": obj.get("TunnelDestinationMacIncr"),
                        "TunnelDestinationMacStart": obj.get("TunnelDestinationMacStart"),
                        "VlanRange": VLANRange.from_dict(obj["VlanRange"]) if obj.get("VlanRange") is not None else None,
                        "id": obj.get("id"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


