# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class Notification(BaseModel):
    """
    Notification
    """ # noqa: E501
    alerting: Optional[StrictBool] = Field(default=None, description="A flag indicating if the current notification should raise an alert")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the notification")
    message: Optional[StrictStr] = Field(default=None, description="A user friendly notification message")
    owner: Optional[StrictStr] = Field(default=None, description="The friendly display name of the entity that created the notification")
    owner_id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the entity that created the notification", alias="ownerId")
    seen: Optional[StrictBool] = Field(default=None, description="A flag indicating if the current notification was already seen by an end user. Notifications that have been seen are automatically filtered.")
    severity: Optional[StrictStr] = Field(default=None, description="The severity of the notification")
    sticky: Optional[StrictBool] = Field(default=None, description="A flag indicating that the current notification should not be automatically dismissed or hidden after a certain period")
    tags: Optional[Dict[str, StrictStr]] = Field(default=None, description="A list of custom tags that provide additional information about the notification")
    timestamp: Optional[StrictInt] = Field(default=None, description="A Unix timestamp that indicates when the notification was generated")
    __properties: ClassVar[List[str]] = ["alerting", "id", "message", "owner", "ownerId", "seen", "severity", "sticky", "tags", "timestamp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Notification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "alerting",
            "id",
            "message",
            "owner",
            "owner_id",
            "seen",
            "severity",
            "sticky",
            "tags",
            "timestamp",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Notification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "alerting": obj.get("alerting"),
                        "id": obj.get("id"),
                        "message": obj.get("message"),
                        "owner": obj.get("owner"),
                        "ownerId": obj.get("ownerId"),
                        "seen": obj.get("seen"),
                        "severity": obj.get("severity"),
                        "sticky": obj.get("sticky"),
                        "tags": obj.get("tags"),
                        "timestamp": obj.get("timestamp")
            ,
            "links": obj.get("links")
        })
        return _obj


