# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List
from cyperf.models.dh_p1_group import DhP1Group
from cyperf.models.enc_p1_algorithm import EncP1Algorithm
from cyperf.models.hash_p1_algorithm import HashP1Algorithm
from cyperf.models.prf_p1_algorithm import PrfP1Algorithm
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class P1Config(BaseModel):
    """
    P1Config
    """ # noqa: E501
    dh_group: DhP1Group = Field(alias="DHGroup")
    enc_algorithm: EncP1Algorithm = Field(alias="EncAlgorithm")
    hash_algorithm: HashP1Algorithm = Field(alias="HashAlgorithm")
    initial_contact: StrictBool = Field(alias="InitialContact")
    lifetime: StrictInt = Field(alias="Lifetime")
    prf_algorithm: PrfP1Algorithm = Field(alias="PrfAlgorithm")
    __properties: ClassVar[List[str]] = ["DHGroup", "EncAlgorithm", "HashAlgorithm", "InitialContact", "Lifetime", "PrfAlgorithm"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of P1Config from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of P1Config from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "DHGroup": obj.get("DHGroup"),
                        "EncAlgorithm": obj.get("EncAlgorithm"),
                        "HashAlgorithm": obj.get("HashAlgorithm"),
                        "InitialContact": obj.get("InitialContact"),
                        "Lifetime": obj.get("Lifetime"),
                        "PrfAlgorithm": obj.get("PrfAlgorithm")
            ,
            "links": obj.get("links")
        })
        return _obj


