# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List
from cyperf.models.enc_p2_algorithm import EncP2Algorithm
from cyperf.models.hash_p2_algorithm import HashP2Algorithm
from cyperf.models.pfs_p2_group import PfsP2Group
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class P2Config(BaseModel):
    """
    P2Config
    """ # noqa: E501
    enc_algorithm: EncP2Algorithm = Field(alias="EncAlgorithm")
    hash_algorithm: HashP2Algorithm = Field(alias="HashAlgorithm")
    lifetime: StrictInt = Field(alias="Lifetime")
    nat_enabled: StrictBool = Field(alias="NatEnabled")
    pfs_enabled: StrictBool = Field(alias="PfsEnabled")
    pfs_group: PfsP2Group = Field(alias="PfsGroup")
    __properties: ClassVar[List[str]] = ["EncAlgorithm", "HashAlgorithm", "Lifetime", "NatEnabled", "PfsEnabled", "PfsGroup"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of P2Config from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of P2Config from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "EncAlgorithm": obj.get("EncAlgorithm"),
                        "HashAlgorithm": obj.get("HashAlgorithm"),
                        "Lifetime": obj.get("Lifetime"),
                        "NatEnabled": obj.get("NatEnabled"),
                        "PfsEnabled": obj.get("PfsEnabled"),
                        "PfsGroup": obj.get("PfsGroup")
            ,
            "links": obj.get("links")
        })
        return _obj


