# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.api_link import APILink
from cyperf.models.enum import Enum
from cyperf.models.payload_metadata import PayloadMetadata
from cyperf.models.type_info_metadata import TypeInfoMetadata
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class ParameterMetadata(BaseModel):
    """
    ParameterMetadata
    """ # noqa: E501
    category: Optional[StrictStr] = Field(default=None, description="The category associated with the parameter", alias="Category")
    category_index: Optional[StrictInt] = Field(default=None, description="The position of the category in the category list", alias="CategoryIndex")
    default: Optional[StrictStr] = Field(default=None, description="The default value of the parameter", alias="Default")
    description: Optional[StrictStr] = Field(default=None, description="The description of the parameter", alias="Description")
    display_name: Optional[StrictStr] = Field(default=None, description="The user friendly name of the parameter", alias="DisplayName")
    enum: Optional[Enum] = Field(default=None, alias="Enum")
    flow_identifier: Optional[StrictBool] = Field(default=None, description="If true, the value of this parameter is used to uniquely identify an application/attack", alias="FlowIdentifier")
    input: Optional[StrictStr] = Field(default=None, description="The input of the parameter", alias="Input")
    legacy_names: Optional[List[StrictStr]] = Field(default=None, description="The names of the equivalent parameters", alias="LegacyNames")
    mandatory: Optional[StrictBool] = Field(default=None, description="The mandatory status of the parameter", alias="Mandatory")
    payload: Optional[PayloadMetadata] = Field(default=None, alias="Payload")
    readonly: Optional[StrictBool] = Field(default=None, description="The read-only status of the parameter", alias="Readonly")
    shared: Optional[StrictBool] = Field(default=None, description="The shared status of the parameter", alias="Shared")
    type: Optional[StrictStr] = Field(default=None, description="The type of the parameter", alias="Type")
    type_info: Optional[TypeInfoMetadata] = Field(default=None, alias="TypeInfo")
    unique_value: Optional[StrictBool] = Field(default=None, description="If true, the value of this parameter must be unique across all Applications/Actions", alias="UniqueValue")
    links: Optional[List[APILink]] = None
    __properties: ClassVar[List[str]] = ["Category", "CategoryIndex", "Default", "Description", "DisplayName", "Enum", "FlowIdentifier", "Input", "LegacyNames", "Mandatory", "Payload", "Readonly", "Shared", "Type", "TypeInfo", "UniqueValue", "links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ParameterMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of enum
        if self.enum:
            _dict['Enum'] = self.enum.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payload
        if self.payload:
            _dict['Payload'] = self.payload.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type_info
        if self.type_info:
            _dict['TypeInfo'] = self.type_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ParameterMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "Category": obj.get("Category"),
                        "CategoryIndex": obj.get("CategoryIndex"),
                        "Default": obj.get("Default"),
                        "Description": obj.get("Description"),
                        "DisplayName": obj.get("DisplayName"),
                        "Enum": Enum.from_dict(obj["Enum"]) if obj.get("Enum") is not None else None,
                        "FlowIdentifier": obj.get("FlowIdentifier"),
                        "Input": obj.get("Input"),
                        "LegacyNames": obj.get("LegacyNames"),
                        "Mandatory": obj.get("Mandatory"),
                        "Payload": PayloadMetadata.from_dict(obj["Payload"]) if obj.get("Payload") is not None else None,
                        "Readonly": obj.get("Readonly"),
                        "Shared": obj.get("Shared"),
                        "Type": obj.get("Type"),
                        "TypeInfo": TypeInfoMetadata.from_dict(obj["TypeInfo"]) if obj.get("TypeInfo") is not None else None,
                        "UniqueValue": obj.get("UniqueValue"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


