# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictBytes, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from cyperf.models.api_link import APILink
from cyperf.models.file_value import FileValue
from cyperf.models.media_file import MediaFile
from cyperf.models.param_metadata import ParamMetadata
from cyperf.models.params_enum import ParamsEnum
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class Params(BaseModel):
    """
    Params
    """ # noqa: E501
    array_element_type: Optional[StrictStr] = Field(default=None, description="The type of the array elements.", alias="ArrayElementType")
    array_elements: Optional[List[Dict[str, StrictStr]]] = Field(default=None, alias="ArrayElements")
    category: Optional[StrictStr] = Field(default=None, description="The category associated with the parameter", alias="Category")
    category_index: Optional[StrictInt] = Field(default=None, description="The position of the category in the category list", alias="CategoryIndex")
    deprecated_previous_source: Optional[StrictStr] = Field(default=None, description="A value indicating that this parameter had a source that was deprecated", alias="DeprecatedPreviousSource")
    description: Optional[StrictStr] = Field(default=None, description="The description of the parameter", alias="Description")
    dictionary_value: Optional[Dict[str, StrictStr]] = Field(default=None, description="The dictionary value of the parameter.", alias="DictionaryValue")
    enum: Optional[ParamsEnum] = Field(default=None, alias="Enum")
    file_value: Optional[FileValue] = Field(default=None, alias="FileValue")
    flow_identifier: Optional[StrictBool] = Field(default=None, description="If true, the value of this parameter is used to uniquely identify an application/attack", alias="FlowIdentifier")
    is_deprecated: Optional[StrictBool] = Field(default=None, alias="IsDeprecated")
    is_modified: Optional[StrictBool] = Field(default=None, alias="IsModified")
    media_files: Optional[List[MediaFile]] = Field(default=None, alias="MediaFiles")
    metadata: Optional[ParamMetadata] = Field(default=None, alias="Metadata")
    name: Optional[StrictStr] = Field(default=None, description="The name of the parameter.", alias="Name")
    param_id: Optional[StrictStr] = Field(default=None, description="The id of the parameter.", alias="ParamId")
    readonly: Optional[StrictBool] = Field(default=None, alias="Readonly")
    source: Optional[StrictStr] = Field(default=None, description="The source of the parameter.", alias="Source")
    supported_sources: Optional[List[StrictStr]] = Field(default=None, description="A list that indicates possible sources for the parameter", alias="SupportedSources")
    type: Optional[StrictStr] = Field(default=None, description="The type of the parameter.", alias="Type")
    value: Optional[StrictStr] = Field(default=None, description="The value of the parameter.", alias="Value")
    file_upload: Optional[List[Union[StrictBytes, StrictStr]]] = Field(default=None, alias="file-upload")
    _file_upload_json_schema_extra: dict = PrivateAttr(default={"x-operation": "-,UploadFile" })
    id: StrictStr
    links: Optional[List[APILink]] = None
    supports_dynamic_payload: Optional[StrictBool] = Field(default=None, description="A value that indicates if the parameter can have dynamic payload.", alias="supportsDynamicPayload")
    upload_url: Optional[StrictStr] = Field(default=None, description="The URL where the file parameter content could be uploaded.", alias="uploadURL")
    __properties: ClassVar[List[str]] = ["ArrayElementType", "ArrayElements", "Category", "CategoryIndex", "DeprecatedPreviousSource", "Description", "DictionaryValue", "Enum", "FileValue", "FlowIdentifier", "IsDeprecated", "IsModified", "MediaFiles", "Metadata", "Name", "ParamId", "Readonly", "Source", "SupportedSources", "Type", "Value", "file-upload", "id", "links", "supportsDynamicPayload", "uploadURL"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Params from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of enum
        if self.enum:
            _dict['Enum'] = self.enum.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file_value
        if self.file_value:
            _dict['FileValue'] = self.file_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in media_files (list)
        _items = []
        if self.media_files:
            for _item in self.media_files:
                if _item:
                    _items.append(_item.to_dict())
            _dict['MediaFiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['Metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Params from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "ArrayElementType": obj.get("ArrayElementType"),
                        "ArrayElements": obj.get("ArrayElements"),
                        "Category": obj.get("Category"),
                        "CategoryIndex": obj.get("CategoryIndex"),
                        "DeprecatedPreviousSource": obj.get("DeprecatedPreviousSource"),
                        "Description": obj.get("Description"),
                        "DictionaryValue": obj.get("DictionaryValue"),
                        "Enum": ParamsEnum.from_dict(obj["Enum"]) if obj.get("Enum") is not None else None,
                        "FileValue": FileValue.from_dict(obj["FileValue"]) if obj.get("FileValue") is not None else None,
                        "FlowIdentifier": obj.get("FlowIdentifier"),
                        "IsDeprecated": obj.get("IsDeprecated"),
                        "IsModified": obj.get("IsModified"),
                        "MediaFiles": [MediaFile.from_dict(_item) for _item in obj["MediaFiles"]] if obj.get("MediaFiles") is not None else None,
                        "Metadata": ParamMetadata.from_dict(obj["Metadata"]) if obj.get("Metadata") is not None else None,
                        "Name": obj.get("Name"),
                        "ParamId": obj.get("ParamId"),
                        "Readonly": obj.get("Readonly"),
                        "Source": obj.get("Source"),
                        "SupportedSources": obj.get("SupportedSources"),
                        "Type": obj.get("Type"),
                        "Value": obj.get("Value"),
                        "file-upload": obj.get("file-upload"),
                        "id": obj.get("id"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
                        "supportsDynamicPayload": obj.get("supportsDynamicPayload"),
                        "uploadURL": obj.get("uploadURL")
            ,
            "links": obj.get("links")
        })
        return _obj


