# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.prepared_test_options import PreparedTestOptions
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class PrepareTestOperation(BaseModel):
    """
    PrepareTestOperation
    """ # noqa: E501
    options: Optional[PreparedTestOptions] = Field(default=None, alias="Options")
    message: Optional[StrictStr] = Field(default=None, description="An optional message that describes the reason the test ended")
    new_state: Optional[StrictStr] = Field(default=None, description="An optional enum that identifies the current state of the test", alias="newState")
    old_state: Optional[StrictStr] = Field(default=None, description="An optional enum that identifies the previous state of the test", alias="oldState")
    owner: Optional[StrictStr] = Field(default=None, description="An optional friendly display name for the user which initiated the operation")
    owner_id: Optional[StrictStr] = Field(default=None, description="An optional identifier that uniquely identifies the user which initiated the operation", alias="ownerId")
    reason: Optional[StrictStr] = Field(default=None, description="An optional enum that identifies the underlying reason for the test's end")
    test_id: Optional[StrictStr] = Field(default=None, description="The test to which the state change refers", alias="testId")
    timestamp: Optional[StrictInt] = Field(default=None, description="An optional Unix timestamp that indicates when the test state was changed")
    __properties: ClassVar[List[str]] = ["Options", "message", "newState", "oldState", "owner", "ownerId", "reason", "testId", "timestamp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrepareTestOperation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['Options'] = self.options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrepareTestOperation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "Options": PreparedTestOptions.from_dict(obj["Options"]) if obj.get("Options") is not None else None,
                        "message": obj.get("message"),
                        "newState": obj.get("newState"),
                        "oldState": obj.get("oldState"),
                        "owner": obj.get("owner"),
                        "ownerId": obj.get("ownerId"),
                        "reason": obj.get("reason"),
                        "testId": obj.get("testId"),
                        "timestamp": obj.get("timestamp")
            ,
            "links": obj.get("links")
        })
        return _obj


