# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.agent_reservation import AgentReservation
from cyperf.models.payload_meta import PayloadMeta
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class ReserveOperationInput(BaseModel):
    """
    ReserveOperationInput
    """ # noqa: E501
    agents_data: Optional[List[AgentReservation]] = Field(default=None, alias="agentsData")
    force: Optional[StrictBool] = None
    owner: Optional[StrictStr] = None
    owner_id: Optional[StrictStr] = Field(default=None, alias="ownerId")
    payloads: Optional[Dict[str, PayloadMeta]] = None
    session_id: Optional[StrictStr] = Field(default=None, alias="sessionId")
    session_name: Optional[StrictStr] = Field(default=None, alias="sessionName")
    __properties: ClassVar[List[str]] = ["agentsData", "force", "owner", "ownerId", "payloads", "sessionId", "sessionName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReserveOperationInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in agents_data (list)
        _items = []
        if self.agents_data:
            for _item in self.agents_data:
                if _item:
                    _items.append(_item.to_dict())
            _dict['agentsData'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in payloads (dict)
        _field_dict = {}
        if self.payloads:
            for _key in self.payloads:
                if self.payloads[_key]:
                    _field_dict[_key] = self.payloads[_key].to_dict()
            _dict['payloads'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReserveOperationInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "agentsData": [AgentReservation.from_dict(_item) for _item in obj["agentsData"]] if obj.get("agentsData") is not None else None,
                        "force": obj.get("force"),
                        "owner": obj.get("owner"),
                        "ownerId": obj.get("ownerId"),
                        "payloads": dict(
                (_k, PayloadMeta.from_dict(_v))
                for _k, _v in obj["payloads"].items()
            )
            if obj.get("payloads") is not None
            else None,
                        "sessionId": obj.get("sessionId"),
                        "sessionName": obj.get("sessionName")
            ,
            "links": obj.get("links")
        })
        return _obj


