# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from cyperf.models.objective_type import ObjectiveType
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class SecondaryObjective(BaseModel):
    """
    SecondaryObjective
    """ # noqa: E501
    enabled: StrictBool = Field(description="If false, the values of this objective will be ignored.", alias="Enabled")
    max_pending_simulated_users: Annotated[str, Field(strict=True)] = Field(description="Only applies if Type is SimulatedUsers. The maximum number or percentage of users that can be in the pending state (not yet connected and sending traffic) at any time. You can either specify a number or a percentage using the % sign.", alias="MaxPendingSimulatedUsers")
    max_simulated_users_per_interval: Optional[StrictInt] = Field(default=None, description="Only applies if Type is SimulatedUsers. The maximum number of simulated users at which new users are initiated and teardown per interval(1 second). Default value is 0 (no limit)", alias="MaxSimulatedUsersPerInterval")
    objective_unit: StrictStr = Field(description="The objective's unit.", alias="ObjectiveUnit")
    objective_value: Union[StrictFloat, StrictInt] = Field(description="The value of the secondary objective. This value will be used for the whole duration of the test.", alias="ObjectiveValue")
    type: ObjectiveType = Field(description="The objective's type (default: SimulatedUsers).", alias="Type")
    __properties: ClassVar[List[str]] = ["Enabled", "MaxPendingSimulatedUsers", "MaxSimulatedUsersPerInterval", "ObjectiveUnit", "ObjectiveValue", "Type"]

    @field_validator('max_pending_simulated_users')
    def max_pending_simulated_users_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+%?$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+%?$/")
        return value

    @field_validator('objective_unit')
    def objective_unit_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['', 'bps', 'Kbps', 'Mbps', 'Gbps']):
            raise ValueError("must be one of enum values ('', 'bps', 'Kbps', 'Mbps', 'Gbps')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecondaryObjective from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecondaryObjective from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "Enabled": obj.get("Enabled"),
                        "MaxPendingSimulatedUsers": obj.get("MaxPendingSimulatedUsers"),
                        "MaxSimulatedUsersPerInterval": obj.get("MaxSimulatedUsersPerInterval"),
                        "ObjectiveUnit": obj.get("ObjectiveUnit"),
                        "ObjectiveValue": obj.get("ObjectiveValue"),
                        "Type": obj.get("Type")
            ,
            "links": obj.get("links")
        })
        return _obj


