# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.api_link import APILink
from cyperf.models.appsec_config import AppsecConfig
from cyperf.models.pair import Pair
from cyperf.models.test_info import TestInfo
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class Session(BaseModel):
    """
    Session
    """ # noqa: E501
    application: Optional[StrictStr] = Field(default=None, description="The user-friendly name for the application that controls this session")
    config: Optional[AppsecConfig] = None
    config_name: Optional[StrictStr] = Field(default=None, description="The display name of the configuration loaded in the session", alias="configName")
    config_url: Optional[StrictStr] = Field(default=None, description="The external URL of the configuration loaded in the session", alias="configUrl")
    created: Optional[StrictInt] = Field(default=None, description="A Unix timestamp that indicates when the session was created")
    data_model_url: Optional[StrictStr] = Field(default=None, description="The URL of the data model loaded in the session", alias="dataModelUrl")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the session")
    index: Optional[StrictInt] = Field(default=None, description="The session's index")
    last_visited: Optional[StrictInt] = Field(default=None, description="A Unix timestamp that indicates when the session was last visited", alias="lastVisited")
    links: Optional[List[APILink]] = None
    meta: Optional[List[Pair]] = Field(default=None, description="The session's metadata as a list of key-value pairs")
    name: Optional[StrictStr] = Field(default=None, description="The user-visible name of the session")
    owner: Optional[StrictStr] = Field(default=None, description="The user-visible name of the session's owner")
    owner_id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the session's owner", alias="ownerID")
    pinned: Optional[StrictBool] = Field(default=None, description="A flag that indicates if the session is pinned")
    state: Optional[StrictStr] = Field(default=None, description="The current state of the session")
    test: Optional[TestInfo] = None
    __properties: ClassVar[List[str]] = ["application", "config", "configName", "configUrl", "created", "dataModelUrl", "id", "index", "lastVisited", "links", "meta", "name", "owner", "ownerID", "pinned", "state", "test"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Session from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "created",
            "data_model_url",
            "id",
            "index",
            "last_visited",
            "owner",
            "owner_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in meta (list)
        _items = []
        if self.meta:
            for _item in self.meta:
                if _item:
                    _items.append(_item.to_dict())
            _dict['meta'] = _items
        # override the default output from pydantic by calling `to_dict()` of test
        if self.test:
            _dict['test'] = self.test.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Session from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "application": obj.get("application"),
                        "config": AppsecConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
                        "configName": obj.get("configName"),
                        "configUrl": obj.get("configUrl"),
                        "created": obj.get("created"),
                        "dataModelUrl": obj.get("dataModelUrl"),
                        "id": obj.get("id"),
                        "index": obj.get("index"),
                        "lastVisited": obj.get("lastVisited"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
                        "meta": [Pair.from_dict(_item) for _item in obj["meta"]] if obj.get("meta") is not None else None,
                        "name": obj.get("name"),
                        "owner": obj.get("owner"),
                        "ownerID": obj.get("ownerID"),
                        "pinned": obj.get("pinned"),
                        "state": obj.get("state"),
                        "test": TestInfo.from_dict(obj["test"]) if obj.get("test") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


