# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cyperf.models.api_link import APILink
from cyperf.models.objective_type import ObjectiveType
from cyperf.models.objective_unit import ObjectiveUnit
from cyperf.models.timeline_segment_union import TimelineSegmentUnion
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class SpecificObjective(BaseModel):
    """
    SpecificObjective
    """ # noqa: E501
    max_pending_simulated_users: Annotated[str, Field(strict=True)] = Field(description="Only applies if Type is SimulatedUsers. The maximum number or percentage of users that can be in the pending state (not yet connected and sending traffic) at any time. You can either specify a number or a percentage using the % sign.", alias="MaxPendingSimulatedUsers")
    max_simulated_users_per_interval: Optional[StrictInt] = Field(default=None, description="Only applies if Type is SimulatedUsers. The maximum number of simulated users at which new users are initiated and teardown per interval(1 second). Default value is 0 (no limit)", alias="MaxSimulatedUsersPerInterval")
    timeline: Optional[List[TimelineSegmentUnion]] = Field(default=None, description="The timeline of this objective.", alias="Timeline")
    type: ObjectiveType = Field(description="The objective's type (default: Throughput).", alias="Type")
    unit: ObjectiveUnit = Field(description="The objective's unit. Must be one of: bps or ''.", alias="Unit")
    id: StrictStr
    links: Optional[List[APILink]] = None
    __properties: ClassVar[List[str]] = ["MaxPendingSimulatedUsers", "MaxSimulatedUsersPerInterval", "Timeline", "Type", "Unit", "id", "links"]

    @field_validator('max_pending_simulated_users')
    def max_pending_simulated_users_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"$|^[0-9]+%?$", value):
            raise ValueError(r"must validate the regular expression /$|^[0-9]+%?$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpecificObjective from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in timeline (list)
        _items = []
        if self.timeline:
            for _item in self.timeline:
                if _item:
                    _items.append(_item.to_dict())
            _dict['Timeline'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpecificObjective from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "MaxPendingSimulatedUsers": obj.get("MaxPendingSimulatedUsers"),
                        "MaxSimulatedUsersPerInterval": obj.get("MaxSimulatedUsersPerInterval"),
                        "Timeline": [TimelineSegmentUnion.from_dict(_item) for _item in obj["Timeline"]] if obj.get("Timeline") is not None else None,
                        "Type": obj.get("Type"),
                        "Unit": obj.get("Unit"),
                        "id": obj.get("id"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


