# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.chassis_info import ChassisInfo
from cyperf.models.traffic_agent_info import TrafficAgentInfo
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class SystemInfo(BaseModel):
    """
    SystemInfo
    """ # noqa: E501
    chassis_info: Optional[ChassisInfo] = Field(default=None, alias="chassisInfo")
    kernel_version: Optional[StrictStr] = Field(default=None, alias="kernelVersion")
    os_name: Optional[StrictStr] = Field(default=None, alias="osName")
    port_manager_version: Optional[StrictStr] = Field(default=None, alias="portManagerVersion")
    traffic_agent_info: Optional[List[TrafficAgentInfo]] = Field(default=None, alias="trafficAgentInfo")
    __properties: ClassVar[List[str]] = ["chassisInfo", "kernelVersion", "osName", "portManagerVersion", "trafficAgentInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SystemInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "kernel_version",
            "os_name",
            "port_manager_version",
            "traffic_agent_info",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chassis_info
        if self.chassis_info:
            _dict['chassisInfo'] = self.chassis_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in traffic_agent_info (list)
        _items = []
        if self.traffic_agent_info:
            for _item in self.traffic_agent_info:
                if _item:
                    _items.append(_item.to_dict())
            _dict['trafficAgentInfo'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SystemInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "chassisInfo": ChassisInfo.from_dict(obj["chassisInfo"]) if obj.get("chassisInfo") is not None else None,
                        "kernelVersion": obj.get("kernelVersion"),
                        "osName": obj.get("osName"),
                        "portManagerVersion": obj.get("portManagerVersion"),
                        "trafficAgentInfo": [TrafficAgentInfo.from_dict(_item) for _item in obj["trafficAgentInfo"]] if obj.get("trafficAgentInfo") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


