# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.dashboard import Dashboard
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class TestInfo(BaseModel):
    """
    TestInfo
    """ # noqa: E501
    dashboards: Optional[List[Dashboard]] = Field(default=None, description="All the dashboards generated for the current test")
    default_dashboard_index: Optional[StrictInt] = Field(default=None, description="The index of the dashboard that should be opened when user first accesses the UI", alias="defaultDashboardIndex")
    default_polling_interval: Optional[StrictInt] = Field(default=None, description="The default polling interval that should be used by the dashboards to refresh their data from the underlying stats source", alias="defaultPollingInterval")
    status: Optional[StrictStr] = Field(default=None, description="The status of the test")
    test_details: Optional[StrictStr] = Field(default=None, description="An optional message that gives more details about the test run", alias="testDetails")
    test_duration: Optional[StrictInt] = Field(default=None, description="The run duration (in seconds) of the test", alias="testDuration")
    test_elapsed: Optional[StrictInt] = Field(default=None, description="The elapsed time (in seconds) since the test started", alias="testElapsed")
    test_id: Optional[StrictStr] = Field(default=None, description="The identifier of the test run", alias="testId")
    test_initialized: Optional[StrictInt] = Field(default=None, description="A Unix timestamp that indicates when the last test was initialized", alias="testInitialized")
    test_started: Optional[StrictInt] = Field(default=None, description="A Unix timestamp that indicates when the test was started", alias="testStarted")
    test_stopped: Optional[StrictInt] = Field(default=None, description="A Unix timestamp that indicates when the test was stopped. May be null if the test is still running.", alias="testStopped")
    __properties: ClassVar[List[str]] = ["dashboards", "defaultDashboardIndex", "defaultPollingInterval", "status", "testDetails", "testDuration", "testElapsed", "testId", "testInitialized", "testStarted", "testStopped"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "test_elapsed",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in dashboards (list)
        _items = []
        if self.dashboards:
            for _item in self.dashboards:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dashboards'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "dashboards": [Dashboard.from_dict(_item) for _item in obj["dashboards"]] if obj.get("dashboards") is not None else None,
                        "defaultDashboardIndex": obj.get("defaultDashboardIndex"),
                        "defaultPollingInterval": obj.get("defaultPollingInterval"),
                        "status": obj.get("status"),
                        "testDetails": obj.get("testDetails"),
                        "testDuration": obj.get("testDuration"),
                        "testElapsed": obj.get("testElapsed"),
                        "testId": obj.get("testId"),
                        "testInitialized": obj.get("testInitialized"),
                        "testStarted": obj.get("testStarted"),
                        "testStopped": obj.get("testStopped")
            ,
            "links": obj.get("links")
        })
        return _obj


