# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cyperf.models.api_link import APILink
from cyperf.models.inner_ip_range import InnerIPRange
from cyperf.models.ip_range import IPRange
from cyperf.models.tunnel_range import TunnelRange
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class TunnelStack(BaseModel):
    """
    The tunnel stack assigned to the current test configuration
    """ # noqa: E501
    inner_ip_range: Optional[InnerIPRange] = Field(default=None, alias="InnerIPRange")
    outer_ip_range: Optional[IPRange] = Field(default=None, alias="OuterIPRange")
    tunnel_range: Optional[TunnelRange] = Field(default=None, alias="TunnelRange")
    tunnel_stack_name: Annotated[str, Field(strict=True)] = Field(alias="TunnelStackName")
    id: StrictStr
    links: Optional[List[APILink]] = None
    __properties: ClassVar[List[str]] = ["InnerIPRange", "OuterIPRange", "TunnelRange", "TunnelStackName", "id", "links"]

    @field_validator('tunnel_stack_name')
    def tunnel_stack_name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^$|^[^\"\\]+$", value):
            raise ValueError(r"must validate the regular expression /^$|^[^\"\\]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TunnelStack from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of inner_ip_range
        if self.inner_ip_range:
            _dict['InnerIPRange'] = self.inner_ip_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of outer_ip_range
        if self.outer_ip_range:
            _dict['OuterIPRange'] = self.outer_ip_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tunnel_range
        if self.tunnel_range:
            _dict['TunnelRange'] = self.tunnel_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TunnelStack from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "InnerIPRange": InnerIPRange.from_dict(obj["InnerIPRange"]) if obj.get("InnerIPRange") is not None else None,
                        "OuterIPRange": IPRange.from_dict(obj["OuterIPRange"]) if obj.get("OuterIPRange") is not None else None,
                        "TunnelRange": TunnelRange.from_dict(obj["TunnelRange"]) if obj.get("TunnelRange") is not None else None,
                        "TunnelStackName": obj.get("TunnelStackName"),
                        "id": obj.get("id"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


