# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.type_array_v2_metadata import TypeArrayV2Metadata
from cyperf.models.type_int_metadata import TypeIntMetadata
from cyperf.models.type_media_metadata import TypeMediaMetadata
from cyperf.models.type_string_metadata import TypeStringMetadata
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class TypeInfoMetadata(BaseModel):
    """
    TypeInfoMetadata
    """ # noqa: E501
    array_v2: Optional[TypeArrayV2Metadata] = Field(default=None, alias="arrayV2")
    int: Optional[TypeIntMetadata] = None
    media: Optional[TypeMediaMetadata] = None
    string: Optional[TypeStringMetadata] = None
    __properties: ClassVar[List[str]] = ["arrayV2", "int", "media", "string"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TypeInfoMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of array_v2
        if self.array_v2:
            _dict['arrayV2'] = self.array_v2.to_dict()
        # override the default output from pydantic by calling `to_dict()` of int
        if self.int:
            _dict['int'] = self.int.to_dict()
        # override the default output from pydantic by calling `to_dict()` of media
        if self.media:
            _dict['media'] = self.media.to_dict()
        # override the default output from pydantic by calling `to_dict()` of string
        if self.string:
            _dict['string'] = self.string.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TypeInfoMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "arrayV2": TypeArrayV2Metadata.from_dict(obj["arrayV2"]) if obj.get("arrayV2") is not None else None,
                        "int": TypeIntMetadata.from_dict(obj["int"]) if obj.get("int") is not None else None,
                        "media": TypeMediaMetadata.from_dict(obj["media"]) if obj.get("media") is not None else None,
                        "string": TypeStringMetadata.from_dict(obj["string"]) if obj.get("string") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


