# coding: utf-8

"""
    CyPerf Application API

    CyPerf REST API

    The version of the OpenAPI document: 1.0.0
    Contact: support@keysight.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cyperf.models.api_link import APILink
from cyperf.models.static_arp_entry import StaticARPEntry
from typing import Optional, Set, Union, GenericAlias, get_args
from typing_extensions import Self
from pydantic import Field, PrivateAttr

class VLANRange(BaseModel):
    """
    The VLAN range assigned to an IP range configuration
    """ # noqa: E501
    count: Optional[StrictInt] = Field(default=None, description="The number of VLANs generated (default: 1).", alias="Count")
    count_per_agent: Optional[StrictInt] = Field(default=None, description="The number of VLANs that should be assigned to each traffic agent for this VLAN range segment in a valid test (default: 1).", alias="CountPerAgent")
    max_count_per_agent: Optional[StrictInt] = Field(default=None, description="The maximum number of VLANs that should be assigned to each traffic agent for this VLAN range segment in a valid test (default: 1).", alias="MaxCountPerAgent")
    priority: Optional[StrictInt] = Field(default=None, description="The priority code point value (default: 0).", alias="Priority")
    static_arp_table: Optional[List[StaticARPEntry]] = Field(default=None, alias="StaticARPTable")
    tag_protocol_id: Optional[StrictInt] = Field(default=None, description="The tag protocol identifier (default: 33024).", alias="TagProtocolId")
    vlan_auto: StrictBool = Field(description="A flag indicating if VLAN settings for the VLANRange should be determined automatically (default: false).", alias="VlanAuto")
    vlan_enabled: Optional[StrictBool] = Field(default=None, description="The enable status of the VLAN configuration, if not determined automatically (default: false).", alias="VlanEnabled")
    vlan_id: Optional[StrictInt] = Field(default=None, description="The VLAN identifier (default: 1).", alias="VlanId")
    vlan_incr: Optional[StrictInt] = Field(default=None, description="The VLAN incrementation rule (default: 1).", alias="VlanIncr")
    links: Optional[List[APILink]] = None
    __properties: ClassVar[List[str]] = ["Count", "CountPerAgent", "MaxCountPerAgent", "Priority", "StaticARPTable", "TagProtocolId", "VlanAuto", "VlanEnabled", "VlanId", "VlanIncr", "links"]

    @field_validator('tag_protocol_id')
    def tag_protocol_id_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([33024]):
            raise ValueError("must be one of enum values (33024)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VLANRange from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in static_arp_table (list)
        _items = []
        if self.static_arp_table:
            for _item in self.static_arp_table:
                if _item:
                    _items.append(_item.to_dict())
            _dict['StaticARPTable'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VLANRange from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            _obj = cls.model_validate(obj)
#            _obj.api_client = client
            return _obj

        _obj = cls.model_validate({
            "Count": obj.get("Count"),
                        "CountPerAgent": obj.get("CountPerAgent"),
                        "MaxCountPerAgent": obj.get("MaxCountPerAgent"),
                        "Priority": obj.get("Priority"),
                        "StaticARPTable": [StaticARPEntry.from_dict(_item) for _item in obj["StaticARPTable"]] if obj.get("StaticARPTable") is not None else None,
                        "TagProtocolId": obj.get("TagProtocolId"),
                        "VlanAuto": obj.get("VlanAuto"),
                        "VlanEnabled": obj.get("VlanEnabled"),
                        "VlanId": obj.get("VlanId"),
                        "VlanIncr": obj.get("VlanIncr"),
                        "links": [APILink.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None
            ,
            "links": obj.get("links")
        })
        return _obj


