# vim: set fileencoding=utf-8 :


def get(ccy, default=None):
    return _dump.get(ccy, default)


if __name__ == "__main__":
    """Download and dump ISO4217 current currency list."""
    import urllib.request
    import xml.etree.ElementTree as ET

    url = "https://www.six-group.com/dam/download/financial-information/data-center/iso-currrency/lists/list-one.xml"

    tree = ET.parse(urllib.request.urlopen(url))
    items = {}
    for e in tree.findall("./CcyTbl/CcyNtry"):
        ccy = e.findtext("./Ccy")
        if ccy is not None:
            exp = e.findtext("./CcyMnrUnts", "N.A.")
            items[ccy] = {
                "name": e.findtext("./CcyNm"),
                "fraction": None if exp == "N.A." else "1" + "0" * int(exp),
            }
    print(items)

_dump = \
{'AFN': {'name': 'Afghani', 'fraction': '100'}, 'EUR': {'name': 'Euro', 'fraction': '100'}, 'ALL': {'name': 'Lek', 'fraction': '100'}, 'DZD': {'name': 'Algerian Dinar', 'fraction': '100'}, 'USD': {'name': 'US Dollar', 'fraction': '100'}, 'AOA': {'name': 'Kwanza', 'fraction': '100'}, 'XCD': {'name': 'East Caribbean Dollar', 'fraction': '100'}, 'ARS': {'name': 'Argentine Peso', 'fraction': '100'}, 'AMD': {'name': 'Armenian Dram', 'fraction': '100'}, 'AWG': {'name': 'Aruban Florin', 'fraction': '100'}, 'AUD': {'name': 'Australian Dollar', 'fraction': '100'}, 'AZN': {'name': 'Azerbaijan Manat', 'fraction': '100'}, 'BSD': {'name': 'Bahamian Dollar', 'fraction': '100'}, 'BHD': {'name': 'Bahraini Dinar', 'fraction': '1000'}, 'BDT': {'name': 'Taka', 'fraction': '100'}, 'BBD': {'name': 'Barbados Dollar', 'fraction': '100'}, 'BYN': {'name': 'Belarusian Ruble', 'fraction': '100'}, 'BZD': {'name': 'Belize Dollar', 'fraction': '100'}, 'XOF': {'name': 'CFA Franc BCEAO', 'fraction': '1'}, 'BMD': {'name': 'Bermudian Dollar', 'fraction': '100'}, 'INR': {'name': 'Indian Rupee', 'fraction': '100'}, 'BTN': {'name': 'Ngultrum', 'fraction': '100'}, 'BOB': {'name': 'Boliviano', 'fraction': '100'}, 'BOV': {'name': 'Mvdol', 'fraction': '100'}, 'BAM': {'name': 'Convertible Mark', 'fraction': '100'}, 'BWP': {'name': 'Pula', 'fraction': '100'}, 'NOK': {'name': 'Norwegian Krone', 'fraction': '100'}, 'BRL': {'name': 'Brazilian Real', 'fraction': '100'}, 'BND': {'name': 'Brunei Dollar', 'fraction': '100'}, 'BGN': {'name': 'Bulgarian Lev', 'fraction': '100'}, 'BIF': {'name': 'Burundi Franc', 'fraction': '1'}, 'CVE': {'name': 'Cabo Verde Escudo', 'fraction': '100'}, 'KHR': {'name': 'Riel', 'fraction': '100'}, 'XAF': {'name': 'CFA Franc BEAC', 'fraction': '1'}, 'CAD': {'name': 'Canadian Dollar', 'fraction': '100'}, 'KYD': {'name': 'Cayman Islands Dollar', 'fraction': '100'}, 'CLP': {'name': 'Chilean Peso', 'fraction': '1'}, 'CLF': {'name': 'Unidad de Fomento', 'fraction': '10000'}, 'CNY': {'name': 'Yuan Renminbi', 'fraction': '100'}, 'COP': {'name': 'Colombian Peso', 'fraction': '100'}, 'COU': {'name': 'Unidad de Valor Real', 'fraction': '100'}, 'KMF': {'name': 'Comorian Franc ', 'fraction': '1'}, 'CDF': {'name': 'Congolese Franc', 'fraction': '100'}, 'NZD': {'name': 'New Zealand Dollar', 'fraction': '100'}, 'CRC': {'name': 'Costa Rican Colon', 'fraction': '100'}, 'CUP': {'name': 'Cuban Peso', 'fraction': '100'}, 'CUC': {'name': 'Peso Convertible', 'fraction': '100'}, 'ANG': {'name': 'Netherlands Antillean Guilder', 'fraction': '100'}, 'CZK': {'name': 'Czech Koruna', 'fraction': '100'}, 'DKK': {'name': 'Danish Krone', 'fraction': '100'}, 'DJF': {'name': 'Djibouti Franc', 'fraction': '1'}, 'DOP': {'name': 'Dominican Peso', 'fraction': '100'}, 'EGP': {'name': 'Egyptian Pound', 'fraction': '100'}, 'SVC': {'name': 'El Salvador Colon', 'fraction': '100'}, 'ERN': {'name': 'Nakfa', 'fraction': '100'}, 'SZL': {'name': 'Lilangeni', 'fraction': '100'}, 'ETB': {'name': 'Ethiopian Birr', 'fraction': '100'}, 'FKP': {'name': 'Falkland Islands Pound', 'fraction': '100'}, 'FJD': {'name': 'Fiji Dollar', 'fraction': '100'}, 'XPF': {'name': 'CFP Franc', 'fraction': '1'}, 'GMD': {'name': 'Dalasi', 'fraction': '100'}, 'GEL': {'name': 'Lari', 'fraction': '100'}, 'GHS': {'name': 'Ghana Cedi', 'fraction': '100'}, 'GIP': {'name': 'Gibraltar Pound', 'fraction': '100'}, 'GTQ': {'name': 'Quetzal', 'fraction': '100'}, 'GBP': {'name': 'Pound Sterling', 'fraction': '100'}, 'GNF': {'name': 'Guinean Franc', 'fraction': '1'}, 'GYD': {'name': 'Guyana Dollar', 'fraction': '100'}, 'HTG': {'name': 'Gourde', 'fraction': '100'}, 'HNL': {'name': 'Lempira', 'fraction': '100'}, 'HKD': {'name': 'Hong Kong Dollar', 'fraction': '100'}, 'HUF': {'name': 'Forint', 'fraction': '100'}, 'ISK': {'name': 'Iceland Krona', 'fraction': '1'}, 'IDR': {'name': 'Rupiah', 'fraction': '100'}, 'XDR': {'name': 'SDR (Special Drawing Right)', 'fraction': None}, 'IRR': {'name': 'Iranian Rial', 'fraction': '100'}, 'IQD': {'name': 'Iraqi Dinar', 'fraction': '1000'}, 'ILS': {'name': 'New Israeli Sheqel', 'fraction': '100'}, 'JMD': {'name': 'Jamaican Dollar', 'fraction': '100'}, 'JPY': {'name': 'Yen', 'fraction': '1'}, 'JOD': {'name': 'Jordanian Dinar', 'fraction': '1000'}, 'KZT': {'name': 'Tenge', 'fraction': '100'}, 'KES': {'name': 'Kenyan Shilling', 'fraction': '100'}, 'KPW': {'name': 'North Korean Won', 'fraction': '100'}, 'KRW': {'name': 'Won', 'fraction': '1'}, 'KWD': {'name': 'Kuwaiti Dinar', 'fraction': '1000'}, 'KGS': {'name': 'Som', 'fraction': '100'}, 'LAK': {'name': 'Lao Kip', 'fraction': '100'}, 'LBP': {'name': 'Lebanese Pound', 'fraction': '100'}, 'LSL': {'name': 'Loti', 'fraction': '100'}, 'ZAR': {'name': 'Rand', 'fraction': '100'}, 'LRD': {'name': 'Liberian Dollar', 'fraction': '100'}, 'LYD': {'name': 'Libyan Dinar', 'fraction': '1000'}, 'CHF': {'name': 'Swiss Franc', 'fraction': '100'}, 'MOP': {'name': 'Pataca', 'fraction': '100'}, 'MKD': {'name': 'Denar', 'fraction': '100'}, 'MGA': {'name': 'Malagasy Ariary', 'fraction': '100'}, 'MWK': {'name': 'Malawi Kwacha', 'fraction': '100'}, 'MYR': {'name': 'Malaysian Ringgit', 'fraction': '100'}, 'MVR': {'name': 'Rufiyaa', 'fraction': '100'}, 'MRU': {'name': 'Ouguiya', 'fraction': '100'}, 'MUR': {'name': 'Mauritius Rupee', 'fraction': '100'}, 'XUA': {'name': 'ADB Unit of Account', 'fraction': None}, 'MXN': {'name': 'Mexican Peso', 'fraction': '100'}, 'MXV': {'name': 'Mexican Unidad de Inversion (UDI)', 'fraction': '100'}, 'MDL': {'name': 'Moldovan Leu', 'fraction': '100'}, 'MNT': {'name': 'Tugrik', 'fraction': '100'}, 'MAD': {'name': 'Moroccan Dirham', 'fraction': '100'}, 'MZN': {'name': 'Mozambique Metical', 'fraction': '100'}, 'MMK': {'name': 'Kyat', 'fraction': '100'}, 'NAD': {'name': 'Namibia Dollar', 'fraction': '100'}, 'NPR': {'name': 'Nepalese Rupee', 'fraction': '100'}, 'NIO': {'name': 'Cordoba Oro', 'fraction': '100'}, 'NGN': {'name': 'Naira', 'fraction': '100'}, 'OMR': {'name': 'Rial Omani', 'fraction': '1000'}, 'PKR': {'name': 'Pakistan Rupee', 'fraction': '100'}, 'PAB': {'name': 'Balboa', 'fraction': '100'}, 'PGK': {'name': 'Kina', 'fraction': '100'}, 'PYG': {'name': 'Guarani', 'fraction': '1'}, 'PEN': {'name': 'Sol', 'fraction': '100'}, 'PHP': {'name': 'Philippine Peso', 'fraction': '100'}, 'PLN': {'name': 'Zloty', 'fraction': '100'}, 'QAR': {'name': 'Qatari Rial', 'fraction': '100'}, 'RON': {'name': 'Romanian Leu', 'fraction': '100'}, 'RUB': {'name': 'Russian Ruble', 'fraction': '100'}, 'RWF': {'name': 'Rwanda Franc', 'fraction': '1'}, 'SHP': {'name': 'Saint Helena Pound', 'fraction': '100'}, 'WST': {'name': 'Tala', 'fraction': '100'}, 'STN': {'name': 'Dobra', 'fraction': '100'}, 'SAR': {'name': 'Saudi Riyal', 'fraction': '100'}, 'RSD': {'name': 'Serbian Dinar', 'fraction': '100'}, 'SCR': {'name': 'Seychelles Rupee', 'fraction': '100'}, 'SLE': {'name': 'Leone', 'fraction': '100'}, 'SGD': {'name': 'Singapore Dollar', 'fraction': '100'}, 'XSU': {'name': 'Sucre', 'fraction': None}, 'SBD': {'name': 'Solomon Islands Dollar', 'fraction': '100'}, 'SOS': {'name': 'Somali Shilling', 'fraction': '100'}, 'SSP': {'name': 'South Sudanese Pound', 'fraction': '100'}, 'LKR': {'name': 'Sri Lanka Rupee', 'fraction': '100'}, 'SDG': {'name': 'Sudanese Pound', 'fraction': '100'}, 'SRD': {'name': 'Surinam Dollar', 'fraction': '100'}, 'SEK': {'name': 'Swedish Krona', 'fraction': '100'}, 'CHE': {'name': 'WIR Euro', 'fraction': '100'}, 'CHW': {'name': 'WIR Franc', 'fraction': '100'}, 'SYP': {'name': 'Syrian Pound', 'fraction': '100'}, 'TWD': {'name': 'New Taiwan Dollar', 'fraction': '100'}, 'TJS': {'name': 'Somoni', 'fraction': '100'}, 'TZS': {'name': 'Tanzanian Shilling', 'fraction': '100'}, 'THB': {'name': 'Baht', 'fraction': '100'}, 'TOP': {'name': 'Pa’anga', 'fraction': '100'}, 'TTD': {'name': 'Trinidad and Tobago Dollar', 'fraction': '100'}, 'TND': {'name': 'Tunisian Dinar', 'fraction': '1000'}, 'TRY': {'name': 'Turkish Lira', 'fraction': '100'}, 'TMT': {'name': 'Turkmenistan New Manat', 'fraction': '100'}, 'UGX': {'name': 'Uganda Shilling', 'fraction': '1'}, 'UAH': {'name': 'Hryvnia', 'fraction': '100'}, 'AED': {'name': 'UAE Dirham', 'fraction': '100'}, 'USN': {'name': 'US Dollar (Next day)', 'fraction': '100'}, 'UYU': {'name': 'Peso Uruguayo', 'fraction': '100'}, 'UYI': {'name': 'Uruguay Peso en Unidades Indexadas (UI)', 'fraction': '1'}, 'UYW': {'name': 'Unidad Previsional', 'fraction': '10000'}, 'UZS': {'name': 'Uzbekistan Sum', 'fraction': '100'}, 'VUV': {'name': 'Vatu', 'fraction': '1'}, 'VES': {'name': 'Bolívar Soberano', 'fraction': '100'}, 'VED': {'name': 'Bolívar Soberano', 'fraction': '100'}, 'VND': {'name': 'Dong', 'fraction': '1'}, 'YER': {'name': 'Yemeni Rial', 'fraction': '100'}, 'ZMW': {'name': 'Zambian Kwacha', 'fraction': '100'}, 'ZWL': {'name': 'Zimbabwe Dollar', 'fraction': '100'}, 'XBA': {'name': 'Bond Markets Unit European Composite Unit (EURCO)', 'fraction': None}, 'XBB': {'name': 'Bond Markets Unit European Monetary Unit (E.M.U.-6)', 'fraction': None}, 'XBC': {'name': 'Bond Markets Unit European Unit of Account 9 (E.U.A.-9)', 'fraction': None}, 'XBD': {'name': 'Bond Markets Unit European Unit of Account 17 (E.U.A.-17)', 'fraction': None}, 'XTS': {'name': 'Codes specifically reserved for testing purposes', 'fraction': None}, 'XXX': {'name': 'The codes assigned for transactions where no currency is involved', 'fraction': None}, 'XAU': {'name': 'Gold', 'fraction': None}, 'XPD': {'name': 'Palladium', 'fraction': None}, 'XPT': {'name': 'Platinum', 'fraction': None}, 'XAG': {'name': 'Silver', 'fraction': None}}
