"""sec

Revision ID: 0a4bbaa82cd1
Revises: ca2d5f47456a
Create Date: 2025-10-28 09:22:18.123782

"""

from typing import Sequence, Union

import sqlmodel
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "0a4bbaa82cd1"
down_revision: Union[str, None] = "ca2d5f47456a"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "sec",
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("cusip", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("shares", sa.Integer(), nullable=True),
        sa.Column("period", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("filed_date", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("ticker", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("company_name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.PrimaryKeyConstraint("name", "period", "filed_date", "source"),
        sqlite_autoincrement=True,
    )
    with op.batch_alter_table("sec", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_sec_filed_date"), ["filed_date"], unique=False
        )
        batch_op.create_index(batch_op.f("ix_sec_name"), ["name"], unique=False)
        batch_op.create_index(batch_op.f("ix_sec_period"), ["period"], unique=False)
        batch_op.create_index(batch_op.f("ix_sec_source"), ["source"], unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("sec", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_sec_source"))
        batch_op.drop_index(batch_op.f("ix_sec_period"))
        batch_op.drop_index(batch_op.f("ix_sec_name"))
        batch_op.drop_index(batch_op.f("ix_sec_filed_date"))

    op.drop_table("sec")
    # ### end Alembic commands ###
