"""price_etf

Revision ID: 4e44f10ee322
Revises: f94459e49cae
Create Date: 2025-11-16 17:16:23.412608

"""

from typing import Sequence, Union

import sqlmodel
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "4e44f10ee322"
down_revision: Union[str, None] = "f94459e49cae"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "secshareincrease",
        sa.Column("ticker", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("previous_period", sa.Date(), nullable=True),
        sa.Column("max_period", sa.Date(), nullable=True),
        sa.Column("occurrences", sa.Integer(), nullable=True),
        sa.Column("prev_total_value", sa.Float(), nullable=True),
        sa.Column("total_value", sa.Float(), nullable=True),
        sa.Column("total_increase", sa.Float(), nullable=True),
        sa.Column("prev_total_shares", sa.Float(), nullable=True),
        sa.Column("total_shares", sa.Float(), nullable=True),
        sa.Column("shares_increase", sa.Float(), nullable=True),
        sa.PrimaryKeyConstraint("ticker"),
        sqlite_autoincrement=True,
    )
    with op.batch_alter_table("secshareincrease", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_secshareincrease_ticker"), ["ticker"], unique=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("secshareincrease", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_secshareincrease_ticker"))

    op.drop_table("secshareincrease")
    # ### end Alembic commands ###
