"""index table

Revision ID: 79d40a2eeef5
Revises: b62d0afd2675
Create Date: 2025-10-26 13:03:29.683677

"""

from typing import Sequence, Union

import sqlmodel
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "79d40a2eeef5"
down_revision: Union[str, None] = "b62d0afd2675"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "index",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.Date(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("isin", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("base_symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("modifier", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("summary", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("currency", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("market", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("country", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("category_group", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("category", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sqlite_autoincrement=True,
    )
    with op.batch_alter_table("index", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_index_country"), ["country"], unique=False)
        batch_op.create_index(batch_op.f("ix_index_source"), ["source"], unique=False)
        batch_op.create_index(batch_op.f("ix_index_symbol"), ["symbol"], unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("index", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_index_symbol"))
        batch_op.drop_index(batch_op.f("ix_index_source"))
        batch_op.drop_index(batch_op.f("ix_index_country"))

    op.drop_table("index")
    # ### end Alembic commands ###
