"""price_etf

Revision ID: f94459e49cae
Revises: f7b416c59e27
Create Date: 2025-11-12 08:38:29.802110

"""

from typing import Sequence, Union

import sqlmodel
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "f94459e49cae"
down_revision: Union[str, None] = "f7b416c59e27"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "priceetf",
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.DateTime(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("open", sa.Float(), nullable=False),
        sa.Column("high", sa.Float(), nullable=False),
        sa.Column("low", sa.Float(), nullable=False),
        sa.Column("close", sa.Float(), nullable=False),
        sa.Column("volume", sa.Float(), nullable=False),
        sa.Column("dividends", sa.Float(), nullable=True),
        sa.Column("stock_splits", sa.Float(), nullable=True),
        sa.PrimaryKeyConstraint("symbol", "source", "date"),
    )
    with op.batch_alter_table("priceetf", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_priceetf_date"), ["date"], unique=False)
        batch_op.create_index(
            batch_op.f("ix_priceetf_source"), ["source"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_priceetf_symbol"), ["symbol"], unique=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("priceetf", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_priceetf_symbol"))
        batch_op.drop_index(batch_op.f("ix_priceetf_source"))
        batch_op.drop_index(batch_op.f("ix_priceetf_date"))

    op.drop_table("priceetf")
    # ### end Alembic commands ###
