from typing import Optional

from pydantic import Field

from bearish.models.base import DataSourceBase


class FinancialMetrics(DataSourceBase):

    ebitda: Optional[float] = Field(
        None,
        description="Earnings before interest, taxes, depreciation, and amortization",
    )
    net_income: Optional[float] = Field(
        None, description="Total earnings or profit of the company"
    )
    pe_ratio: Optional[float] = Field(None)
    market_capitalization: Optional[float] = Field(None)
    basic_eps: Optional[float] = Field(
        None,
        description="Earnings per share for basic shares outstanding",
    )
    diluted_eps: Optional[float] = Field(
        None, alias="Diluted EPS", description="Earnings per share for diluted shares"
    )
    total_revenue: Optional[float] = Field(
        None,
        description="Total revenue generated by the company",
    )
    operating_revenue: Optional[float] = Field(
        None, description="Revenue from operating activities"
    )
    gross_profit: Optional[float] = Field(
        None,
        description="Revenue after deducting cost of goods sold",
    )
    total_expenses: Optional[float] = Field(
        None,
        description="Total expenses incurred by the company",
    )
    operating_income: Optional[float] = Field(
        None, description="Income generated from operations"
    )
    profit_margin: Optional[float] = Field(None, description="Net profit margin")
    cost_of_revenue: Optional[float] = Field(
        None, description="Cost incurred to generate revenue"
    )
    tax_provision: Optional[float] = Field(None, description="Provision for income tax")
    tax_rate: Optional[float] = Field(
        None, description="Effective tax rate used in calculations"
    )


class QuarterlyFinancialMetrics(FinancialMetrics): ...
