简体中文 | [English](https://github.com/chenwei-zhao/captcha-recognizer/blob/main/README_en.md)

# Captcha-Recognizer

Captcha-Recognizer是一个易用的通用滑块验证码识别库，通过深度学习训练通用的缺口检测模型，基于训练的结果，识别出验证码中的滑块缺口位置，并返回缺口的坐标与可信度。

# 当前最新版本

Beat版本：1.0.0-Beta
稳定版本：0.10.0

# Note
1.0.0-Beta 版本已发布，欢迎测试使用
```shell
pip install --pre captcha-recognizer
```

更多版本见
[Pypi 版本历史](https://pypi.org/project/captcha-recognizer/#history)
[Github 版本历史](https://github.com/chenwei-zhao/captcha-recognizer/blob/main/HISTORY.md)

# 支持的验证码类型

- 单缺口验证码背景图
- ~~多缺口验证码背景图 (1.0.0及之后版本移除)~~
- 验证码全图（图片包含滑块和背景图）

# 在线演示

- [在线演示](http://47.94.198.97/)

<p>
<img 
  src="https://raw.githubusercontent.com/chenwei-zhao/captcha-recognizer/main/images_example/online-demo.gif" 
  alt="https://captcha-slider.oss-cn-beijing.aliyuncs.com/slider/online-demo.gif"
>
</p>


# 版本要求

* ``Python`` >= 3.6.0
* ``opencv-python``
* ``shapely``
* ``onnxruntime``

* Works on Linux, Windows, MacOS

# 使用方式

- Pypi
- [HTTP API](https://github.com/chenwei-zhao/captcha-api)

## Pypi

### 从 Pypi 安装

```bash
pip install captcha-recognizer
```

## HTTP API

请移步: [captcha-api](https://github.com/chenwei-zhao/captcha-api)

# 使用示例

<<<<<<< Updated upstream
## V2 增强版

V2增强版，增强了对多缺口复杂验证码的识别效果

V2支持以下类型验证码的识别

- 单缺口验证码背景图（不含滑块的背景图）
- 多缺口验证码截图或合成图（含滑块和背景图）

### V2 Beta 增强版使用示例

```shell
pip install captcha-recognizer --upgrade
```


```python3
# V2增强版


from captcha_recognizer.slider import SliderV2

box, confidence = SliderV2().identify(source=f'images_example/example8.png', show=True)
print(f'缺口坐标: {box}')
print('置信度', confidence)
```

## V1 版本

### 基于单缺口/多缺口验证码背景图识别滑块缺口

```Python

from captcha_recognizer.recognizer import Recognizer

# source传入图片， 支持 Union[str, Path, bytes, np.ndarray]
# is_single 默认为False表示支持多缺口背景图识别，is_single=True表示仅支持单缺口背景图识别（指定is_single为True时，对单缺口背景图识别准确度更高）
recognizer = Recognizer()
box, confidence = recognizer.identify_gap(source='your_example_image.png')

print(f'缺口坐标: {box}')
print(f'可信度: {confidence}')

"""
打印结果如下:
缺口方框坐标: [331.72052001953125, 55.96122741699219, 422.079345703125, 161.7498779296875]
可信度: 0.9513089656829834

坐标原点：图片左上角
缺口方框坐标为缺口方框左上角和右下角距离坐标原点的距离
"""
```

### 基于单缺口/多缺口验证码背景图识别滑块缺口的示例图片

包括且不限于以下类型、尺寸的滑块图片检测


<p>示例图 1</p>
<p>尺寸 552*344</p>
<img 
  src="https://raw.githubusercontent.com/chenwei-zhao/captcha-recognizer/main/images_example/example1.png" 
  alt="https://captcha-slider.oss-cn-beijing.aliyuncs.com/slider/example1.png"
>
<p>识别效果示例图 1</p>
<img src="https://raw.githubusercontent.com/chenwei-zhao/captcha-recognizer/main/images_predict/predict1.png" 
  alt="https://captcha-slider.oss-cn-beijing.aliyuncs.com/slider/predict1.png"
>

<p>示例图 2</p>
<p>尺寸 260*160</p>
<img src="https://raw.githubusercontent.com/chenwei-zhao/captcha-recognizer/main/images_example/example2.png" 
  alt="https://captcha-slider.oss-cn-beijing.aliyuncs.com/slider/example2.png"
>

<p>识别效果示例图 2</p>
<img src="https://raw.githubusercontent.com/chenwei-zhao/captcha-recognizer/main/images_predict/predict2.png"
  alt="https://captcha-slider.oss-cn-beijing.aliyuncs.com/slider/predict2.png"
>
=======
支持以下类型验证码的识别
>>>>>>> Stashed changes

1. 单缺口验证码背景图（不含滑块的背景图） 
2. 单缺口、多缺口验证码全图（图片含滑块和背景图）

## 单缺口验证码背景图 识别示例

<p>示例图 4</p>
<p>尺寸 672*390</p>
<img src="https://raw.githubusercontent.com/chenwei-zhao/captcha-recognizer/main/images_example/example4.png" 
  alt="https://captcha-slider.oss-cn-beijing.aliyuncs.com/slider/example4.png"
>
<p>识别效果示例图4</p>
<img src="https://raw.githubusercontent.com/chenwei-zhao/captcha-recognizer/main/images_predict/predict4.png" 
  alt="https://captcha-slider.oss-cn-beijing.aliyuncs.com/slider/predict4.png"
>


## 单缺口、多缺口验证码全图 识别示例

<p>示例图 8</p>
<p>尺寸 305*156</p>
<img 
  src="https://raw.githubusercontent.com/chenwei-zhao/captcha-recognizer/main/images_example/example8.png" 
  alt="https://captcha-slider.oss-cn-beijing.aliyuncs.com/slider/example8.png"
>
<p>识别效果示例图 8</p>
<img src="https://raw.githubusercontent.com/chenwei-zhao/captcha-recognizer/main/images_predict/predict8.png" 
  alt="https://captcha-slider.oss-cn-beijing.aliyuncs.com/slider/predict8.png"
>


## 代码示例

```python3
from captcha_recognizer.slider import Slider

# source传入待识别图片，支持数据类型为 Union[str, Path, bytes, np.ndarray]
# show为布尔值，默认值为False, 为True表示展示图片识别效果，线上环境请缺省，或设置为False
box, confidence = Slider().identify(source=f'images_example/example8.png', show=True)
print(f'缺口坐标: {box}')
print('置信度', confidence)
```

# 注意事项

## 偏移量

某些种类的滑块验证码，滑块初始位置存在一定偏移，以下面图中的滑块初始位置为例：

<p>示例图 9</p>
<img 
  src="https://raw.githubusercontent.com/chenwei-zhao/captcha-recognizer/main/images_example/offset2.png"
  alt="https://captcha-slider.oss-cn-beijing.aliyuncs.com/slider/offset2.png"
>



如示例图9中：

- 第一条黑线位置为滑块初始位置，距离图片边框有大概有8个像素的偏移量（offset为8）
- 识别结果的缺口坐标为 [x1, y1, x2, y2] 对应缺口的左上角和右下角坐标（坐标原点为图片左上角）
- 第二条黑线的X轴坐标值对应缺口识别结果左上角的X轴坐标值，此处值为154（x1为154）
- 因此实际滑块的距离为 x1-offset (154-8=146)
- 也就是说，实际的滑块距离为缺口的x1值减去滑块距离图片边框的偏移量(offset)

## 图片缩放

某些验证码，前端渲染时会对图片进行缩放，因此实际的滑块距离也要按照图片缩放比例进行计算。

<p>示例图 10</p>
<img 
  src="https://raw.githubusercontent.com/chenwei-zhao/captcha-recognizer/main/images_example/rendered_size.png" 
  alt="https://captcha-slider.oss-cn-beijing.aliyuncs.com/slider/rendered_size.png"
>



## opencv-python与numpy的兼容性问题
  兼容版本1:

```
opencv-python==4.12.0.88
numpy==2.2.6
```

兼容版本2:

```markdown
opencv-python==4.8.0.74
numpy==1.23.0
```

更多兼容的版本请自行尝试

# 了解更多

[点击此处进入DeepWiki文档](https://deepwiki.com/chenwei-zhao/captcha-recognizer)

DeepWiki文档内可通过底部AI对话框进行交流，自由了解本项目。

# 项目维护

- 感谢 Star 支持;
- 项目长期维护;
- 有任何疑问或问题，欢迎提[issue](https://github.com/chenwei-zhao/captcha-recognizer/issues)。


# 更多联系方式

- Gmail: chenwei.zhaozhao@gmail.com
- 163/网易: chenwei_nature@163.com

# 免责声明

本项目不针对任何一家验证码厂商，项目所有内容仅供学习交流使用，不用于其他任何目的，严禁用于非法用途。

# 许可证

MIT license

# 感谢你的支持

## Stargazers

[![Stargazers repo roster for @chenwei-zhao/captcha-recognizer](https://reporoster.com/stars/dark/chenwei-zhao/captcha-recognizer)](https://github.com/chenwei-zhao/captcha-recognizer/stargazers)

## Forkers

[![Forkers repo roster for @chenwei-zhao/captcha-recognizer](https://reporoster.com/forks/dark/chenwei-zhao/captcha-recognizer)](https://github.com/chenwei-zhao/captcha-recognizer/network/members)

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=chenwei-zhao/captcha-recognizer&type=Date)](https://star-history.com/#chenwei-zhao/captcha-recognizer&Date)

## 捐赠

- 感谢支持开源项目
- 如果项目有帮助到您，可以选择捐赠一些费用，帮助项目持续更新。

<img src="https://captcha-slider.oss-cn-beijing.aliyuncs.com/payment/wechat.jpg" width="168" alt="微信支付">

<img src="https://captcha-slider.oss-cn-beijing.aliyuncs.com/payment/alipay.jpg" width="168" alt="支付宝支付">


