# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertArgs', 'Alert']

@pulumi.input_type
class AlertArgs:
    def __init__(__self__, *,
                 minutes: pulumi.Input[_builtins.int],
                 tags: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 additional_information: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_triage_dashboards: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAlertTriageDashboardArgs']]]] = None,
                 alert_type: Optional[pulumi.Input[_builtins.str]] = None,
                 can_modifies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 can_views: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_resend_frequency_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 process_rate_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 resolve_after_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 runbook_links: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 threshold_targets: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Alert resource.
        :param pulumi.Input[_builtins.int] minutes: The number of consecutive minutes that a series matching the condition query must
               evaluate to "true" (non-zero value) before the alert fires.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A set of tags to assign to this resource.
        :param pulumi.Input[_builtins.str] additional_information: User-supplied additional explanatory information for this alert.
               Useful for linking runbooks, migrations, etc.
        :param pulumi.Input[Sequence[pulumi.Input['AlertAlertTriageDashboardArgs']]] alert_triage_dashboards: A set of user-supplied dashboard and parameters to create dashboard links for triaging alerts.
        :param pulumi.Input[_builtins.str] alert_type: The type of alert in Wavefront. Either `CLASSIC` (default)
               or `THRESHOLD`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] can_modifies: A list of valid users or groups that can modify this resource on a tenant.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] can_views: A list of valid users or groups that can view this resource on a tenant. Default is Empty list.
        :param pulumi.Input[_builtins.str] condition: A Wavefront query that is evaluated at regular intervals (default is 1 minute).
               The alert fires and notifications are triggered when a data series matching this query evaluates
               to a non-zero value for a set number of consecutive minutes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] conditions: a string->string map of `severity` to `condition`
               for which this alert will trigger.
        :param pulumi.Input[_builtins.str] display_expression: A second query whose results are displayed in the alert user
               interface instead of the condition query. This field is often used to display a version
               of the condition query with Boolean operators removed so that numerical values are plotted.
        :param pulumi.Input[_builtins.str] name: The name of the alert as it is displayed in Wavefront.
        :param pulumi.Input[_builtins.int] notification_resend_frequency_minutes: How often to re-trigger a continually failing alert.
               If absent or <= 0, no re-triggering occurs.
        :param pulumi.Input[_builtins.int] process_rate_minutes: The specified query is executed every `process_rate_minutes` minutes. Default value is 5 minutes.
        :param pulumi.Input[_builtins.int] resolve_after_minutes: The number of consecutive minutes that a firing series matching the condition
               query must evaluate to "false" (zero value) before the alert resolves. When unset, this defaults to
               the same value as `minutes`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] runbook_links: A list of user-supplied runbook links for this alert.
        :param pulumi.Input[_builtins.str] severity: Severity of the alert, valid values are `INFO`, `SMOKE`, `WARN`, `SEVERE`.
        :param pulumi.Input[_builtins.str] target: A comma-separated list of the email address or integration endpoint
               (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
               Alert target format: ({email}|pd:{pd_key}|target:{alert-target-id}).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] threshold_targets: A string to string map of Targets for severity.
        """
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "tags", tags)
        if additional_information is not None:
            pulumi.set(__self__, "additional_information", additional_information)
        if alert_triage_dashboards is not None:
            pulumi.set(__self__, "alert_triage_dashboards", alert_triage_dashboards)
        if alert_type is not None:
            pulumi.set(__self__, "alert_type", alert_type)
        if can_modifies is not None:
            pulumi.set(__self__, "can_modifies", can_modifies)
        if can_views is not None:
            pulumi.set(__self__, "can_views", can_views)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if display_expression is not None:
            pulumi.set(__self__, "display_expression", display_expression)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_resend_frequency_minutes is not None:
            pulumi.set(__self__, "notification_resend_frequency_minutes", notification_resend_frequency_minutes)
        if process_rate_minutes is not None:
            pulumi.set(__self__, "process_rate_minutes", process_rate_minutes)
        if resolve_after_minutes is not None:
            pulumi.set(__self__, "resolve_after_minutes", resolve_after_minutes)
        if runbook_links is not None:
            pulumi.set(__self__, "runbook_links", runbook_links)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if threshold_targets is not None:
            pulumi.set(__self__, "threshold_targets", threshold_targets)

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> pulumi.Input[_builtins.int]:
        """
        The number of consecutive minutes that a series matching the condition query must
        evaluate to "true" (non-zero value) before the alert fires.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "minutes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A set of tags to assign to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-supplied additional explanatory information for this alert.
        Useful for linking runbooks, migrations, etc.
        """
        return pulumi.get(self, "additional_information")

    @additional_information.setter
    def additional_information(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "additional_information", value)

    @_builtins.property
    @pulumi.getter(name="alertTriageDashboards")
    def alert_triage_dashboards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertAlertTriageDashboardArgs']]]]:
        """
        A set of user-supplied dashboard and parameters to create dashboard links for triaging alerts.
        """
        return pulumi.get(self, "alert_triage_dashboards")

    @alert_triage_dashboards.setter
    def alert_triage_dashboards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAlertTriageDashboardArgs']]]]):
        pulumi.set(self, "alert_triage_dashboards", value)

    @_builtins.property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of alert in Wavefront. Either `CLASSIC` (default)
        or `THRESHOLD`.
        """
        return pulumi.get(self, "alert_type")

    @alert_type.setter
    def alert_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_type", value)

    @_builtins.property
    @pulumi.getter(name="canModifies")
    def can_modifies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of valid users or groups that can modify this resource on a tenant.
        """
        return pulumi.get(self, "can_modifies")

    @can_modifies.setter
    def can_modifies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "can_modifies", value)

    @_builtins.property
    @pulumi.getter(name="canViews")
    def can_views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of valid users or groups that can view this resource on a tenant. Default is Empty list.
        """
        return pulumi.get(self, "can_views")

    @can_views.setter
    def can_views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "can_views", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Wavefront query that is evaluated at regular intervals (default is 1 minute).
        The alert fires and notifications are triggered when a data series matching this query evaluates
        to a non-zero value for a set number of consecutive minutes.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        a string->string map of `severity` to `condition`
        for which this alert will trigger.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="displayExpression")
    def display_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A second query whose results are displayed in the alert user
        interface instead of the condition query. This field is often used to display a version
        of the condition query with Boolean operators removed so that numerical values are plotted.
        """
        return pulumi.get(self, "display_expression")

    @display_expression.setter
    def display_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_expression", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the alert as it is displayed in Wavefront.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationResendFrequencyMinutes")
    def notification_resend_frequency_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often to re-trigger a continually failing alert.
        If absent or <= 0, no re-triggering occurs.
        """
        return pulumi.get(self, "notification_resend_frequency_minutes")

    @notification_resend_frequency_minutes.setter
    def notification_resend_frequency_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "notification_resend_frequency_minutes", value)

    @_builtins.property
    @pulumi.getter(name="processRateMinutes")
    def process_rate_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The specified query is executed every `process_rate_minutes` minutes. Default value is 5 minutes.
        """
        return pulumi.get(self, "process_rate_minutes")

    @process_rate_minutes.setter
    def process_rate_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "process_rate_minutes", value)

    @_builtins.property
    @pulumi.getter(name="resolveAfterMinutes")
    def resolve_after_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive minutes that a firing series matching the condition
        query must evaluate to "false" (zero value) before the alert resolves. When unset, this defaults to
        the same value as `minutes`.
        """
        return pulumi.get(self, "resolve_after_minutes")

    @resolve_after_minutes.setter
    def resolve_after_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resolve_after_minutes", value)

    @_builtins.property
    @pulumi.getter(name="runbookLinks")
    def runbook_links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of user-supplied runbook links for this alert.
        """
        return pulumi.get(self, "runbook_links")

    @runbook_links.setter
    def runbook_links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "runbook_links", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Severity of the alert, valid values are `INFO`, `SMOKE`, `WARN`, `SEVERE`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A comma-separated list of the email address or integration endpoint
        (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
        Alert target format: ({email}|pd:{pd_key}|target:{alert-target-id}).
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="thresholdTargets")
    def threshold_targets(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A string to string map of Targets for severity.
        """
        return pulumi.get(self, "threshold_targets")

    @threshold_targets.setter
    def threshold_targets(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "threshold_targets", value)


@pulumi.input_type
class _AlertState:
    def __init__(__self__, *,
                 additional_information: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_triage_dashboards: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAlertTriageDashboardArgs']]]] = None,
                 alert_type: Optional[pulumi.Input[_builtins.str]] = None,
                 can_modifies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 can_views: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_resend_frequency_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 process_rate_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 resolve_after_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 runbook_links: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 threshold_targets: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Alert resources.
        :param pulumi.Input[_builtins.str] additional_information: User-supplied additional explanatory information for this alert.
               Useful for linking runbooks, migrations, etc.
        :param pulumi.Input[Sequence[pulumi.Input['AlertAlertTriageDashboardArgs']]] alert_triage_dashboards: A set of user-supplied dashboard and parameters to create dashboard links for triaging alerts.
        :param pulumi.Input[_builtins.str] alert_type: The type of alert in Wavefront. Either `CLASSIC` (default)
               or `THRESHOLD`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] can_modifies: A list of valid users or groups that can modify this resource on a tenant.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] can_views: A list of valid users or groups that can view this resource on a tenant. Default is Empty list.
        :param pulumi.Input[_builtins.str] condition: A Wavefront query that is evaluated at regular intervals (default is 1 minute).
               The alert fires and notifications are triggered when a data series matching this query evaluates
               to a non-zero value for a set number of consecutive minutes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] conditions: a string->string map of `severity` to `condition`
               for which this alert will trigger.
        :param pulumi.Input[_builtins.str] display_expression: A second query whose results are displayed in the alert user
               interface instead of the condition query. This field is often used to display a version
               of the condition query with Boolean operators removed so that numerical values are plotted.
        :param pulumi.Input[_builtins.int] minutes: The number of consecutive minutes that a series matching the condition query must
               evaluate to "true" (non-zero value) before the alert fires.
        :param pulumi.Input[_builtins.str] name: The name of the alert as it is displayed in Wavefront.
        :param pulumi.Input[_builtins.int] notification_resend_frequency_minutes: How often to re-trigger a continually failing alert.
               If absent or <= 0, no re-triggering occurs.
        :param pulumi.Input[_builtins.int] process_rate_minutes: The specified query is executed every `process_rate_minutes` minutes. Default value is 5 minutes.
        :param pulumi.Input[_builtins.int] resolve_after_minutes: The number of consecutive minutes that a firing series matching the condition
               query must evaluate to "false" (zero value) before the alert resolves. When unset, this defaults to
               the same value as `minutes`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] runbook_links: A list of user-supplied runbook links for this alert.
        :param pulumi.Input[_builtins.str] severity: Severity of the alert, valid values are `INFO`, `SMOKE`, `WARN`, `SEVERE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A set of tags to assign to this resource.
        :param pulumi.Input[_builtins.str] target: A comma-separated list of the email address or integration endpoint
               (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
               Alert target format: ({email}|pd:{pd_key}|target:{alert-target-id}).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] threshold_targets: A string to string map of Targets for severity.
        """
        if additional_information is not None:
            pulumi.set(__self__, "additional_information", additional_information)
        if alert_triage_dashboards is not None:
            pulumi.set(__self__, "alert_triage_dashboards", alert_triage_dashboards)
        if alert_type is not None:
            pulumi.set(__self__, "alert_type", alert_type)
        if can_modifies is not None:
            pulumi.set(__self__, "can_modifies", can_modifies)
        if can_views is not None:
            pulumi.set(__self__, "can_views", can_views)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if display_expression is not None:
            pulumi.set(__self__, "display_expression", display_expression)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_resend_frequency_minutes is not None:
            pulumi.set(__self__, "notification_resend_frequency_minutes", notification_resend_frequency_minutes)
        if process_rate_minutes is not None:
            pulumi.set(__self__, "process_rate_minutes", process_rate_minutes)
        if resolve_after_minutes is not None:
            pulumi.set(__self__, "resolve_after_minutes", resolve_after_minutes)
        if runbook_links is not None:
            pulumi.set(__self__, "runbook_links", runbook_links)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if threshold_targets is not None:
            pulumi.set(__self__, "threshold_targets", threshold_targets)

    @_builtins.property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-supplied additional explanatory information for this alert.
        Useful for linking runbooks, migrations, etc.
        """
        return pulumi.get(self, "additional_information")

    @additional_information.setter
    def additional_information(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "additional_information", value)

    @_builtins.property
    @pulumi.getter(name="alertTriageDashboards")
    def alert_triage_dashboards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertAlertTriageDashboardArgs']]]]:
        """
        A set of user-supplied dashboard and parameters to create dashboard links for triaging alerts.
        """
        return pulumi.get(self, "alert_triage_dashboards")

    @alert_triage_dashboards.setter
    def alert_triage_dashboards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAlertTriageDashboardArgs']]]]):
        pulumi.set(self, "alert_triage_dashboards", value)

    @_builtins.property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of alert in Wavefront. Either `CLASSIC` (default)
        or `THRESHOLD`.
        """
        return pulumi.get(self, "alert_type")

    @alert_type.setter
    def alert_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_type", value)

    @_builtins.property
    @pulumi.getter(name="canModifies")
    def can_modifies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of valid users or groups that can modify this resource on a tenant.
        """
        return pulumi.get(self, "can_modifies")

    @can_modifies.setter
    def can_modifies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "can_modifies", value)

    @_builtins.property
    @pulumi.getter(name="canViews")
    def can_views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of valid users or groups that can view this resource on a tenant. Default is Empty list.
        """
        return pulumi.get(self, "can_views")

    @can_views.setter
    def can_views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "can_views", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Wavefront query that is evaluated at regular intervals (default is 1 minute).
        The alert fires and notifications are triggered when a data series matching this query evaluates
        to a non-zero value for a set number of consecutive minutes.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        a string->string map of `severity` to `condition`
        for which this alert will trigger.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="displayExpression")
    def display_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A second query whose results are displayed in the alert user
        interface instead of the condition query. This field is often used to display a version
        of the condition query with Boolean operators removed so that numerical values are plotted.
        """
        return pulumi.get(self, "display_expression")

    @display_expression.setter
    def display_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_expression", value)

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive minutes that a series matching the condition query must
        evaluate to "true" (non-zero value) before the alert fires.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minutes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the alert as it is displayed in Wavefront.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationResendFrequencyMinutes")
    def notification_resend_frequency_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often to re-trigger a continually failing alert.
        If absent or <= 0, no re-triggering occurs.
        """
        return pulumi.get(self, "notification_resend_frequency_minutes")

    @notification_resend_frequency_minutes.setter
    def notification_resend_frequency_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "notification_resend_frequency_minutes", value)

    @_builtins.property
    @pulumi.getter(name="processRateMinutes")
    def process_rate_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The specified query is executed every `process_rate_minutes` minutes. Default value is 5 minutes.
        """
        return pulumi.get(self, "process_rate_minutes")

    @process_rate_minutes.setter
    def process_rate_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "process_rate_minutes", value)

    @_builtins.property
    @pulumi.getter(name="resolveAfterMinutes")
    def resolve_after_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive minutes that a firing series matching the condition
        query must evaluate to "false" (zero value) before the alert resolves. When unset, this defaults to
        the same value as `minutes`.
        """
        return pulumi.get(self, "resolve_after_minutes")

    @resolve_after_minutes.setter
    def resolve_after_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resolve_after_minutes", value)

    @_builtins.property
    @pulumi.getter(name="runbookLinks")
    def runbook_links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of user-supplied runbook links for this alert.
        """
        return pulumi.get(self, "runbook_links")

    @runbook_links.setter
    def runbook_links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "runbook_links", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Severity of the alert, valid values are `INFO`, `SMOKE`, `WARN`, `SEVERE`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of tags to assign to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A comma-separated list of the email address or integration endpoint
        (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
        Alert target format: ({email}|pd:{pd_key}|target:{alert-target-id}).
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="thresholdTargets")
    def threshold_targets(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A string to string map of Targets for severity.
        """
        return pulumi.get(self, "threshold_targets")

    @threshold_targets.setter
    def threshold_targets(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "threshold_targets", value)


@pulumi.type_token("wavefront:index/alert:Alert")
class Alert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_information: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_triage_dashboards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertAlertTriageDashboardArgs', 'AlertAlertTriageDashboardArgsDict']]]]] = None,
                 alert_type: Optional[pulumi.Input[_builtins.str]] = None,
                 can_modifies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 can_views: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_resend_frequency_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 process_rate_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 resolve_after_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 runbook_links: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 threshold_targets: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Wavefront Alert resource. This allows alerts to be created, updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        foobar = wavefront.Alert("foobar",
            name="Test Alert",
            target="test@example.com,target:alert-target-id",
            condition="100-ts(\\"cpu.usage_idle\\", environment=preprod and cpu=cpu-total ) > 80",
            display_expression="100-ts(\\"cpu.usage_idle\\", environment=preprod and cpu=cpu-total )",
            minutes=5,
            resolve_after_minutes=5,
            severity="WARN",
            tags=[
                "terraform",
                "test",
            ])
        ```

        ## Import

        Alerts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import wavefront:index/alert:Alert alert_target 1479868728473
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] additional_information: User-supplied additional explanatory information for this alert.
               Useful for linking runbooks, migrations, etc.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertAlertTriageDashboardArgs', 'AlertAlertTriageDashboardArgsDict']]]] alert_triage_dashboards: A set of user-supplied dashboard and parameters to create dashboard links for triaging alerts.
        :param pulumi.Input[_builtins.str] alert_type: The type of alert in Wavefront. Either `CLASSIC` (default)
               or `THRESHOLD`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] can_modifies: A list of valid users or groups that can modify this resource on a tenant.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] can_views: A list of valid users or groups that can view this resource on a tenant. Default is Empty list.
        :param pulumi.Input[_builtins.str] condition: A Wavefront query that is evaluated at regular intervals (default is 1 minute).
               The alert fires and notifications are triggered when a data series matching this query evaluates
               to a non-zero value for a set number of consecutive minutes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] conditions: a string->string map of `severity` to `condition`
               for which this alert will trigger.
        :param pulumi.Input[_builtins.str] display_expression: A second query whose results are displayed in the alert user
               interface instead of the condition query. This field is often used to display a version
               of the condition query with Boolean operators removed so that numerical values are plotted.
        :param pulumi.Input[_builtins.int] minutes: The number of consecutive minutes that a series matching the condition query must
               evaluate to "true" (non-zero value) before the alert fires.
        :param pulumi.Input[_builtins.str] name: The name of the alert as it is displayed in Wavefront.
        :param pulumi.Input[_builtins.int] notification_resend_frequency_minutes: How often to re-trigger a continually failing alert.
               If absent or <= 0, no re-triggering occurs.
        :param pulumi.Input[_builtins.int] process_rate_minutes: The specified query is executed every `process_rate_minutes` minutes. Default value is 5 minutes.
        :param pulumi.Input[_builtins.int] resolve_after_minutes: The number of consecutive minutes that a firing series matching the condition
               query must evaluate to "false" (zero value) before the alert resolves. When unset, this defaults to
               the same value as `minutes`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] runbook_links: A list of user-supplied runbook links for this alert.
        :param pulumi.Input[_builtins.str] severity: Severity of the alert, valid values are `INFO`, `SMOKE`, `WARN`, `SEVERE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A set of tags to assign to this resource.
        :param pulumi.Input[_builtins.str] target: A comma-separated list of the email address or integration endpoint
               (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
               Alert target format: ({email}|pd:{pd_key}|target:{alert-target-id}).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] threshold_targets: A string to string map of Targets for severity.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Wavefront Alert resource. This allows alerts to be created, updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        foobar = wavefront.Alert("foobar",
            name="Test Alert",
            target="test@example.com,target:alert-target-id",
            condition="100-ts(\\"cpu.usage_idle\\", environment=preprod and cpu=cpu-total ) > 80",
            display_expression="100-ts(\\"cpu.usage_idle\\", environment=preprod and cpu=cpu-total )",
            minutes=5,
            resolve_after_minutes=5,
            severity="WARN",
            tags=[
                "terraform",
                "test",
            ])
        ```

        ## Import

        Alerts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import wavefront:index/alert:Alert alert_target 1479868728473
        ```

        :param str resource_name: The name of the resource.
        :param AlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_information: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_triage_dashboards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertAlertTriageDashboardArgs', 'AlertAlertTriageDashboardArgsDict']]]]] = None,
                 alert_type: Optional[pulumi.Input[_builtins.str]] = None,
                 can_modifies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 can_views: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_resend_frequency_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 process_rate_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 resolve_after_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 runbook_links: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 threshold_targets: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertArgs.__new__(AlertArgs)

            __props__.__dict__["additional_information"] = additional_information
            __props__.__dict__["alert_triage_dashboards"] = alert_triage_dashboards
            __props__.__dict__["alert_type"] = alert_type
            __props__.__dict__["can_modifies"] = can_modifies
            __props__.__dict__["can_views"] = can_views
            __props__.__dict__["condition"] = condition
            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["display_expression"] = display_expression
            if minutes is None and not opts.urn:
                raise TypeError("Missing required property 'minutes'")
            __props__.__dict__["minutes"] = minutes
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_resend_frequency_minutes"] = notification_resend_frequency_minutes
            __props__.__dict__["process_rate_minutes"] = process_rate_minutes
            __props__.__dict__["resolve_after_minutes"] = resolve_after_minutes
            __props__.__dict__["runbook_links"] = runbook_links
            __props__.__dict__["severity"] = severity
            if tags is None and not opts.urn:
                raise TypeError("Missing required property 'tags'")
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target"] = target
            __props__.__dict__["threshold_targets"] = threshold_targets
        super(Alert, __self__).__init__(
            'wavefront:index/alert:Alert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_information: Optional[pulumi.Input[_builtins.str]] = None,
            alert_triage_dashboards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertAlertTriageDashboardArgs', 'AlertAlertTriageDashboardArgsDict']]]]] = None,
            alert_type: Optional[pulumi.Input[_builtins.str]] = None,
            can_modifies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            can_views: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            condition: Optional[pulumi.Input[_builtins.str]] = None,
            conditions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_expression: Optional[pulumi.Input[_builtins.str]] = None,
            minutes: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notification_resend_frequency_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            process_rate_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            resolve_after_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            runbook_links: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            severity: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            target: Optional[pulumi.Input[_builtins.str]] = None,
            threshold_targets: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Alert':
        """
        Get an existing Alert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] additional_information: User-supplied additional explanatory information for this alert.
               Useful for linking runbooks, migrations, etc.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertAlertTriageDashboardArgs', 'AlertAlertTriageDashboardArgsDict']]]] alert_triage_dashboards: A set of user-supplied dashboard and parameters to create dashboard links for triaging alerts.
        :param pulumi.Input[_builtins.str] alert_type: The type of alert in Wavefront. Either `CLASSIC` (default)
               or `THRESHOLD`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] can_modifies: A list of valid users or groups that can modify this resource on a tenant.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] can_views: A list of valid users or groups that can view this resource on a tenant. Default is Empty list.
        :param pulumi.Input[_builtins.str] condition: A Wavefront query that is evaluated at regular intervals (default is 1 minute).
               The alert fires and notifications are triggered when a data series matching this query evaluates
               to a non-zero value for a set number of consecutive minutes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] conditions: a string->string map of `severity` to `condition`
               for which this alert will trigger.
        :param pulumi.Input[_builtins.str] display_expression: A second query whose results are displayed in the alert user
               interface instead of the condition query. This field is often used to display a version
               of the condition query with Boolean operators removed so that numerical values are plotted.
        :param pulumi.Input[_builtins.int] minutes: The number of consecutive minutes that a series matching the condition query must
               evaluate to "true" (non-zero value) before the alert fires.
        :param pulumi.Input[_builtins.str] name: The name of the alert as it is displayed in Wavefront.
        :param pulumi.Input[_builtins.int] notification_resend_frequency_minutes: How often to re-trigger a continually failing alert.
               If absent or <= 0, no re-triggering occurs.
        :param pulumi.Input[_builtins.int] process_rate_minutes: The specified query is executed every `process_rate_minutes` minutes. Default value is 5 minutes.
        :param pulumi.Input[_builtins.int] resolve_after_minutes: The number of consecutive minutes that a firing series matching the condition
               query must evaluate to "false" (zero value) before the alert resolves. When unset, this defaults to
               the same value as `minutes`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] runbook_links: A list of user-supplied runbook links for this alert.
        :param pulumi.Input[_builtins.str] severity: Severity of the alert, valid values are `INFO`, `SMOKE`, `WARN`, `SEVERE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A set of tags to assign to this resource.
        :param pulumi.Input[_builtins.str] target: A comma-separated list of the email address or integration endpoint
               (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
               Alert target format: ({email}|pd:{pd_key}|target:{alert-target-id}).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] threshold_targets: A string to string map of Targets for severity.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertState.__new__(_AlertState)

        __props__.__dict__["additional_information"] = additional_information
        __props__.__dict__["alert_triage_dashboards"] = alert_triage_dashboards
        __props__.__dict__["alert_type"] = alert_type
        __props__.__dict__["can_modifies"] = can_modifies
        __props__.__dict__["can_views"] = can_views
        __props__.__dict__["condition"] = condition
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["display_expression"] = display_expression
        __props__.__dict__["minutes"] = minutes
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_resend_frequency_minutes"] = notification_resend_frequency_minutes
        __props__.__dict__["process_rate_minutes"] = process_rate_minutes
        __props__.__dict__["resolve_after_minutes"] = resolve_after_minutes
        __props__.__dict__["runbook_links"] = runbook_links
        __props__.__dict__["severity"] = severity
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target"] = target
        __props__.__dict__["threshold_targets"] = threshold_targets
        return Alert(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-supplied additional explanatory information for this alert.
        Useful for linking runbooks, migrations, etc.
        """
        return pulumi.get(self, "additional_information")

    @_builtins.property
    @pulumi.getter(name="alertTriageDashboards")
    def alert_triage_dashboards(self) -> pulumi.Output[Optional[Sequence['outputs.AlertAlertTriageDashboard']]]:
        """
        A set of user-supplied dashboard and parameters to create dashboard links for triaging alerts.
        """
        return pulumi.get(self, "alert_triage_dashboards")

    @_builtins.property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of alert in Wavefront. Either `CLASSIC` (default)
        or `THRESHOLD`.
        """
        return pulumi.get(self, "alert_type")

    @_builtins.property
    @pulumi.getter(name="canModifies")
    def can_modifies(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of valid users or groups that can modify this resource on a tenant.
        """
        return pulumi.get(self, "can_modifies")

    @_builtins.property
    @pulumi.getter(name="canViews")
    def can_views(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of valid users or groups that can view this resource on a tenant. Default is Empty list.
        """
        return pulumi.get(self, "can_views")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A Wavefront query that is evaluated at regular intervals (default is 1 minute).
        The alert fires and notifications are triggered when a data series matching this query evaluates
        to a non-zero value for a set number of consecutive minutes.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        a string->string map of `severity` to `condition`
        for which this alert will trigger.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="displayExpression")
    def display_expression(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A second query whose results are displayed in the alert user
        interface instead of the condition query. This field is often used to display a version
        of the condition query with Boolean operators removed so that numerical values are plotted.
        """
        return pulumi.get(self, "display_expression")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> pulumi.Output[_builtins.int]:
        """
        The number of consecutive minutes that a series matching the condition query must
        evaluate to "true" (non-zero value) before the alert fires.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the alert as it is displayed in Wavefront.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationResendFrequencyMinutes")
    def notification_resend_frequency_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How often to re-trigger a continually failing alert.
        If absent or <= 0, no re-triggering occurs.
        """
        return pulumi.get(self, "notification_resend_frequency_minutes")

    @_builtins.property
    @pulumi.getter(name="processRateMinutes")
    def process_rate_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The specified query is executed every `process_rate_minutes` minutes. Default value is 5 minutes.
        """
        return pulumi.get(self, "process_rate_minutes")

    @_builtins.property
    @pulumi.getter(name="resolveAfterMinutes")
    def resolve_after_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of consecutive minutes that a firing series matching the condition
        query must evaluate to "false" (zero value) before the alert resolves. When unset, this defaults to
        the same value as `minutes`.
        """
        return pulumi.get(self, "resolve_after_minutes")

    @_builtins.property
    @pulumi.getter(name="runbookLinks")
    def runbook_links(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of user-supplied runbook links for this alert.
        """
        return pulumi.get(self, "runbook_links")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Output[_builtins.str]:
        """
        Severity of the alert, valid values are `INFO`, `SMOKE`, `WARN`, `SEVERE`.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A set of tags to assign to this resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A comma-separated list of the email address or integration endpoint
        (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
        Alert target format: ({email}|pd:{pd_key}|target:{alert-target-id}).
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="thresholdTargets")
    def threshold_targets(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A string to string map of Targets for severity.
        """
        return pulumi.get(self, "threshold_targets")

