# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudIntegrationNewRelicArgs', 'CloudIntegrationNewRelic']

@pulumi.input_type
class CloudIntegrationNewRelicArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[_builtins.str],
                 additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 app_filter_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 force_save: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_filter_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_filters: Optional[pulumi.Input[Sequence[pulumi.Input['CloudIntegrationNewRelicMetricFilterArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 service_refresh_rate_in_minutes: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a CloudIntegrationNewRelic resource.
        :param pulumi.Input[_builtins.str] api_key: New Relic REST API key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_tags: A list of point tag key-values to add to every point ingested using this integration.
        :param pulumi.Input[_builtins.str] app_filter_regex: A regular expression that an application name must match (case-insensitively) in order to collect metrics.
        :param pulumi.Input[_builtins.bool] force_save: Forces this resource to save, even if errors are present.
        :param pulumi.Input[_builtins.str] host_filter_regex: A regular expression that a host name must match (case-insensitively) in order to collect metrics.
        :param pulumi.Input[Sequence[pulumi.Input['CloudIntegrationNewRelicMetricFilterArgs']]] metric_filters: See Metric Filter.
        :param pulumi.Input[_builtins.str] name: The human-readable name of this integration.
        :param pulumi.Input[_builtins.str] service: A value denoting which cloud service this service integrates with.
        :param pulumi.Input[_builtins.int] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service.
        """
        pulumi.set(__self__, "api_key", api_key)
        if additional_tags is not None:
            pulumi.set(__self__, "additional_tags", additional_tags)
        if app_filter_regex is not None:
            pulumi.set(__self__, "app_filter_regex", app_filter_regex)
        if force_save is not None:
            pulumi.set(__self__, "force_save", force_save)
        if host_filter_regex is not None:
            pulumi.set(__self__, "host_filter_regex", host_filter_regex)
        if metric_filters is not None:
            pulumi.set(__self__, "metric_filters", metric_filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_refresh_rate_in_minutes is not None:
            pulumi.set(__self__, "service_refresh_rate_in_minutes", service_refresh_rate_in_minutes)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[_builtins.str]:
        """
        New Relic REST API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="additionalTags")
    def additional_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A list of point tag key-values to add to every point ingested using this integration.
        """
        return pulumi.get(self, "additional_tags")

    @additional_tags.setter
    def additional_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_tags", value)

    @_builtins.property
    @pulumi.getter(name="appFilterRegex")
    def app_filter_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A regular expression that an application name must match (case-insensitively) in order to collect metrics.
        """
        return pulumi.get(self, "app_filter_regex")

    @app_filter_regex.setter
    def app_filter_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_filter_regex", value)

    @_builtins.property
    @pulumi.getter(name="forceSave")
    def force_save(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Forces this resource to save, even if errors are present.
        """
        return pulumi.get(self, "force_save")

    @force_save.setter
    def force_save(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_save", value)

    @_builtins.property
    @pulumi.getter(name="hostFilterRegex")
    def host_filter_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A regular expression that a host name must match (case-insensitively) in order to collect metrics.
        """
        return pulumi.get(self, "host_filter_regex")

    @host_filter_regex.setter
    def host_filter_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_filter_regex", value)

    @_builtins.property
    @pulumi.getter(name="metricFilters")
    def metric_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudIntegrationNewRelicMetricFilterArgs']]]]:
        """
        See Metric Filter.
        """
        return pulumi.get(self, "metric_filters")

    @metric_filters.setter
    def metric_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudIntegrationNewRelicMetricFilterArgs']]]]):
        pulumi.set(self, "metric_filters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable name of this integration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A value denoting which cloud service this service integrates with.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter(name="serviceRefreshRateInMinutes")
    def service_refresh_rate_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often, in minutes, to refresh the service.
        """
        return pulumi.get(self, "service_refresh_rate_in_minutes")

    @service_refresh_rate_in_minutes.setter
    def service_refresh_rate_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "service_refresh_rate_in_minutes", value)


@pulumi.input_type
class _CloudIntegrationNewRelicState:
    def __init__(__self__, *,
                 additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 app_filter_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 force_save: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_filter_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_filters: Optional[pulumi.Input[Sequence[pulumi.Input['CloudIntegrationNewRelicMetricFilterArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 service_refresh_rate_in_minutes: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CloudIntegrationNewRelic resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_tags: A list of point tag key-values to add to every point ingested using this integration.
        :param pulumi.Input[_builtins.str] api_key: New Relic REST API key.
        :param pulumi.Input[_builtins.str] app_filter_regex: A regular expression that an application name must match (case-insensitively) in order to collect metrics.
        :param pulumi.Input[_builtins.bool] force_save: Forces this resource to save, even if errors are present.
        :param pulumi.Input[_builtins.str] host_filter_regex: A regular expression that a host name must match (case-insensitively) in order to collect metrics.
        :param pulumi.Input[Sequence[pulumi.Input['CloudIntegrationNewRelicMetricFilterArgs']]] metric_filters: See Metric Filter.
        :param pulumi.Input[_builtins.str] name: The human-readable name of this integration.
        :param pulumi.Input[_builtins.str] service: A value denoting which cloud service this service integrates with.
        :param pulumi.Input[_builtins.int] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service.
        """
        if additional_tags is not None:
            pulumi.set(__self__, "additional_tags", additional_tags)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if app_filter_regex is not None:
            pulumi.set(__self__, "app_filter_regex", app_filter_regex)
        if force_save is not None:
            pulumi.set(__self__, "force_save", force_save)
        if host_filter_regex is not None:
            pulumi.set(__self__, "host_filter_regex", host_filter_regex)
        if metric_filters is not None:
            pulumi.set(__self__, "metric_filters", metric_filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_refresh_rate_in_minutes is not None:
            pulumi.set(__self__, "service_refresh_rate_in_minutes", service_refresh_rate_in_minutes)

    @_builtins.property
    @pulumi.getter(name="additionalTags")
    def additional_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A list of point tag key-values to add to every point ingested using this integration.
        """
        return pulumi.get(self, "additional_tags")

    @additional_tags.setter
    def additional_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_tags", value)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        New Relic REST API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="appFilterRegex")
    def app_filter_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A regular expression that an application name must match (case-insensitively) in order to collect metrics.
        """
        return pulumi.get(self, "app_filter_regex")

    @app_filter_regex.setter
    def app_filter_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_filter_regex", value)

    @_builtins.property
    @pulumi.getter(name="forceSave")
    def force_save(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Forces this resource to save, even if errors are present.
        """
        return pulumi.get(self, "force_save")

    @force_save.setter
    def force_save(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_save", value)

    @_builtins.property
    @pulumi.getter(name="hostFilterRegex")
    def host_filter_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A regular expression that a host name must match (case-insensitively) in order to collect metrics.
        """
        return pulumi.get(self, "host_filter_regex")

    @host_filter_regex.setter
    def host_filter_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_filter_regex", value)

    @_builtins.property
    @pulumi.getter(name="metricFilters")
    def metric_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudIntegrationNewRelicMetricFilterArgs']]]]:
        """
        See Metric Filter.
        """
        return pulumi.get(self, "metric_filters")

    @metric_filters.setter
    def metric_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudIntegrationNewRelicMetricFilterArgs']]]]):
        pulumi.set(self, "metric_filters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable name of this integration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A value denoting which cloud service this service integrates with.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter(name="serviceRefreshRateInMinutes")
    def service_refresh_rate_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often, in minutes, to refresh the service.
        """
        return pulumi.get(self, "service_refresh_rate_in_minutes")

    @service_refresh_rate_in_minutes.setter
    def service_refresh_rate_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "service_refresh_rate_in_minutes", value)


@pulumi.type_token("wavefront:index/cloudIntegrationNewRelic:CloudIntegrationNewRelic")
class CloudIntegrationNewRelic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 app_filter_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 force_save: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_filter_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudIntegrationNewRelicMetricFilterArgs', 'CloudIntegrationNewRelicMetricFilterArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 service_refresh_rate_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Wavefront Cloud Integration for New Relic. This allows New Relic cloud integrations to be created,
        updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        newrelic = wavefront.CloudIntegrationNewRelic("newrelic",
            name="Test Integration",
            api_key="example-api-key")
        ```

        ## Import

        NewRelic Integrations can be imported by using the `id`, e.g.:

        ```sh
        $ pulumi import wavefront:index/cloudIntegrationNewRelic:CloudIntegrationNewRelic newrelic a411c16b-3cf7-4f03-bf11-8ca05aab898d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_tags: A list of point tag key-values to add to every point ingested using this integration.
        :param pulumi.Input[_builtins.str] api_key: New Relic REST API key.
        :param pulumi.Input[_builtins.str] app_filter_regex: A regular expression that an application name must match (case-insensitively) in order to collect metrics.
        :param pulumi.Input[_builtins.bool] force_save: Forces this resource to save, even if errors are present.
        :param pulumi.Input[_builtins.str] host_filter_regex: A regular expression that a host name must match (case-insensitively) in order to collect metrics.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudIntegrationNewRelicMetricFilterArgs', 'CloudIntegrationNewRelicMetricFilterArgsDict']]]] metric_filters: See Metric Filter.
        :param pulumi.Input[_builtins.str] name: The human-readable name of this integration.
        :param pulumi.Input[_builtins.str] service: A value denoting which cloud service this service integrates with.
        :param pulumi.Input[_builtins.int] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudIntegrationNewRelicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Wavefront Cloud Integration for New Relic. This allows New Relic cloud integrations to be created,
        updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        newrelic = wavefront.CloudIntegrationNewRelic("newrelic",
            name="Test Integration",
            api_key="example-api-key")
        ```

        ## Import

        NewRelic Integrations can be imported by using the `id`, e.g.:

        ```sh
        $ pulumi import wavefront:index/cloudIntegrationNewRelic:CloudIntegrationNewRelic newrelic a411c16b-3cf7-4f03-bf11-8ca05aab898d
        ```

        :param str resource_name: The name of the resource.
        :param CloudIntegrationNewRelicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudIntegrationNewRelicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 app_filter_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 force_save: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_filter_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudIntegrationNewRelicMetricFilterArgs', 'CloudIntegrationNewRelicMetricFilterArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 service_refresh_rate_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudIntegrationNewRelicArgs.__new__(CloudIntegrationNewRelicArgs)

            __props__.__dict__["additional_tags"] = additional_tags
            if api_key is None and not opts.urn:
                raise TypeError("Missing required property 'api_key'")
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["app_filter_regex"] = app_filter_regex
            __props__.__dict__["force_save"] = force_save
            __props__.__dict__["host_filter_regex"] = host_filter_regex
            __props__.__dict__["metric_filters"] = metric_filters
            __props__.__dict__["name"] = name
            __props__.__dict__["service"] = service
            __props__.__dict__["service_refresh_rate_in_minutes"] = service_refresh_rate_in_minutes
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CloudIntegrationNewRelic, __self__).__init__(
            'wavefront:index/cloudIntegrationNewRelic:CloudIntegrationNewRelic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            app_filter_regex: Optional[pulumi.Input[_builtins.str]] = None,
            force_save: Optional[pulumi.Input[_builtins.bool]] = None,
            host_filter_regex: Optional[pulumi.Input[_builtins.str]] = None,
            metric_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudIntegrationNewRelicMetricFilterArgs', 'CloudIntegrationNewRelicMetricFilterArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            service: Optional[pulumi.Input[_builtins.str]] = None,
            service_refresh_rate_in_minutes: Optional[pulumi.Input[_builtins.int]] = None) -> 'CloudIntegrationNewRelic':
        """
        Get an existing CloudIntegrationNewRelic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_tags: A list of point tag key-values to add to every point ingested using this integration.
        :param pulumi.Input[_builtins.str] api_key: New Relic REST API key.
        :param pulumi.Input[_builtins.str] app_filter_regex: A regular expression that an application name must match (case-insensitively) in order to collect metrics.
        :param pulumi.Input[_builtins.bool] force_save: Forces this resource to save, even if errors are present.
        :param pulumi.Input[_builtins.str] host_filter_regex: A regular expression that a host name must match (case-insensitively) in order to collect metrics.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudIntegrationNewRelicMetricFilterArgs', 'CloudIntegrationNewRelicMetricFilterArgsDict']]]] metric_filters: See Metric Filter.
        :param pulumi.Input[_builtins.str] name: The human-readable name of this integration.
        :param pulumi.Input[_builtins.str] service: A value denoting which cloud service this service integrates with.
        :param pulumi.Input[_builtins.int] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudIntegrationNewRelicState.__new__(_CloudIntegrationNewRelicState)

        __props__.__dict__["additional_tags"] = additional_tags
        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["app_filter_regex"] = app_filter_regex
        __props__.__dict__["force_save"] = force_save
        __props__.__dict__["host_filter_regex"] = host_filter_regex
        __props__.__dict__["metric_filters"] = metric_filters
        __props__.__dict__["name"] = name
        __props__.__dict__["service"] = service
        __props__.__dict__["service_refresh_rate_in_minutes"] = service_refresh_rate_in_minutes
        return CloudIntegrationNewRelic(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalTags")
    def additional_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A list of point tag key-values to add to every point ingested using this integration.
        """
        return pulumi.get(self, "additional_tags")

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[_builtins.str]:
        """
        New Relic REST API key.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="appFilterRegex")
    def app_filter_regex(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A regular expression that an application name must match (case-insensitively) in order to collect metrics.
        """
        return pulumi.get(self, "app_filter_regex")

    @_builtins.property
    @pulumi.getter(name="forceSave")
    def force_save(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Forces this resource to save, even if errors are present.
        """
        return pulumi.get(self, "force_save")

    @_builtins.property
    @pulumi.getter(name="hostFilterRegex")
    def host_filter_regex(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A regular expression that a host name must match (case-insensitively) in order to collect metrics.
        """
        return pulumi.get(self, "host_filter_regex")

    @_builtins.property
    @pulumi.getter(name="metricFilters")
    def metric_filters(self) -> pulumi.Output[Optional[Sequence['outputs.CloudIntegrationNewRelicMetricFilter']]]:
        """
        See Metric Filter.
        """
        return pulumi.get(self, "metric_filters")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The human-readable name of this integration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Output[_builtins.str]:
        """
        A value denoting which cloud service this service integrates with.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter(name="serviceRefreshRateInMinutes")
    def service_refresh_rate_in_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How often, in minutes, to refresh the service.
        """
        return pulumi.get(self, "service_refresh_rate_in_minutes")

