############################################################
#
#       #   #  #   #   #    #
#      ##  ##  #  ##  #    #
#     # # # #  # # # #    #  #
#    #  ##  #  ##  ##    ######
#   #   #   #  #   #       #
#
# Python-based Tool for interaction with the 10micron mounts
# GUI with PySide
#
# written in python3, (c) 2019-2025 by mworion
# Licence APL2.0
#
###########################################################
#
# this file is auto generated for the purpose of getting data prepared
# to show the alignment stars in mountwizzard
#
# standard libraries
# external packages
# local import


def generateAlignStars():
    """
    generateAlignStars is the function where the alignment stars which were
    present in the mount computer from hipparcos catalogue are stored. for a
    correct calculation we need beside the J2000 coordinated the proper motion in
    ra and dec, the parallax and the radial velocity as the stars move over time.
    the data is calculated from the hipparcos catalogue using skyfield library

    the data is written in
    [name, hip no, ra, dec, ra proper motion, dec proper motion, parallax,
    radial velocity] based on J2000 epoch. the units are fitting erfa needs:
    [str, int, radians, radians, radians / year, radians/year, arc sec, km /s]
    """

    star = {}
    star["Achernar"] = [
        0.42635506995907607,
        -0.9989698721359219,
        4.2673525759820365e-07,
        -1.943125977115248e-07,
        0.02267999999992084,
        0.0003167502564713614,
    ]
    star["Acrux"] = [
        3.2576512864528886,
        -1.101286904826098,
        -1.7147902160979606e-07,
        -7.141295136130161e-08,
        0.010170000000154411,
        9.35888419199978e-06,
    ]
    star["Adhara"] = [
        1.8265996517525316,
        -0.505658252449314,
        1.2750598440896192e-08,
        1.110223390053311e-08,
        0.007570000000003465,
        2.800807867466727e-07,
    ]
    star["Albireo"] = [
        5.1082355548040095,
        0.487988493164614,
        -3.4373281271162636e-08,
        -2.729501452991444e-08,
        0.008460000000023256,
        1.6864932050137538e-06,
    ]
    star["Alcor"] = [
        3.513455837250785,
        0.9597209098682812,
        5.834720675264054e-07,
        -8.21288380803576e-08,
        0.04019000000151324,
        2.530550909884062e-05,
    ]
    star["Aldebaran"] = [
        1.2039308165580604,
        0.28814166253131995,
        3.0436457894318447e-07,
        -9.180434074427846e-07,
        0.05009000001146675,
        0.0001585789211928221,
    ]
    star["Alderamin"] = [
        5.57884816439538,
        1.092324307334224,
        7.267899307112835e-07,
        2.3401767388248366e-07,
        0.06684000000195339,
        2.1353840766936493e-05,
    ]
    star["Algenib"] = [
        0.8915260068606703,
        0.8702417522558126,
        1.168882724683577e-07,
        -1.2610009740186727e-07,
        0.0055100000003035126,
        3.352331537061314e-05,
    ]
    star["Algieba"] = [
        2.705139847445134,
        0.346299303753731,
        1.506648421275404e-06,
        -7.411895001776125e-07,
        0.025960000033972072,
        0.0008434026928508933,
    ]
    star["Algol"] = [
        0.8210415037834745,
        0.7148108996219749,
        1.158704574925575e-08,
        -6.981317589803856e-09,
        0.035140000000001614,
        3.05256816398171e-08,
    ]
    star["Alhena"] = [
        1.7353445977036466,
        0.28622094379493473,
        -9.890182560437117e-09,
        -3.244373156278081e-07,
        0.03112000000137838,
        2.8977450370070085e-05,
    ]
    star["Alioth"] = [
        3.377335599016013,
        0.976683127865405,
        5.417301952979467e-07,
        -4.358594163516689e-08,
        0.040300000001195005,
        1.9935819844802488e-05,
    ]
    star["Alkaid"] = [
        3.610829903320896,
        0.8606788398861204,
        -5.877387226590185e-07,
        -7.543850370132115e-08,
        0.032390000001987905,
        4.030266398028019e-05,
    ]
    star["Almach"] = [
        0.5406116794736521,
        0.7387930668804668,
        2.0885691266108436e-07,
        -2.465279469506438e-07,
        0.009190000001178217,
        7.881471025189807e-05,
    ]
    star["Alnair"] = [
        5.795507653347898,
        -0.819623644322571,
        6.186305746827898e-07,
        -7.170862444881037e-07,
        0.032160000009032644,
        0.00018431299531260673,
    ]
    star["Alnilam"] = [
        1.4670083915012704,
        -0.02097745833746889,
        7.2237238621687114e-09,
        -5.1390250101810046e-09,
        0.002430000000001115,
        2.767647528554548e-07,
    ]
    star["Alnitak"] = [
        1.4868406913498162,
        -0.03390428143013612,
        1.9344065734811443e-08,
        1.2314267611160056e-08,
        0.003990000000007422,
        1.1271649225724928e-06,
    ]
    star["Alphard"] = [
        2.4765671847023185,
        -0.15112112215068238,
        -7.024947219927349e-08,
        1.6120055539839789e-07,
        0.01840000000041811,
        1.433254439299072e-05,
    ]
    star["Alpheratz"] = [
        0.03659716798611327,
        0.5077238156833932,
        6.577901367872488e-07,
        -7.900054984440228e-07,
        0.03359999999877105,
        0.0015913509611004788,
    ]
    star["Altair"] = [
        5.195772123915302,
        0.15478142574597795,
        2.6025900895845885e-06,
        1.8691416330407734e-06,
        0.19444000006898107,
        0.00044490620582886075,
    ]
    star["Aludra"] = [
        1.9377301930466717,
        -0.5114356387785041,
        -1.8228988625897067e-08,
        3.228859240346924e-08,
        0.0010200000000184408,
        1.0869774259672181e-05,
    ]
    star["Ankaa"] = [
        0.1146829107879592,
        -0.7383786779763821,
        1.1284831383404688e-06,
        -1.7144895291169717e-06,
        0.04213999999412877,
        0.0040035348174432,
    ]
    star["Antares"] = [
        4.317105473309646,
        -0.4613254718829243,
        -4.925711810625137e-08,
        -1.1252524661051282e-07,
        0.0053999999999969775,
        0.0008219386508180743,
    ]
    star["Arcturus"] = [
        3.733529012714681,
        0.3347961767029305,
        -5.300882113287412e-06,
        -9.693441003092346e-06,
        0.0888500012940421,
        0.011467277405555558,
    ]
    star["Atria"] = [
        4.401129594008038,
        -1.2047609033269415,
        8.653987296196387e-08,
        -1.5960064190983694e-07,
        0.007850000000369397,
        2.8821943319029024e-05,
    ]
    star["Avior"] = [
        2.192631681379373,
        -1.0386364152210767,
        -1.2285138441820442e-07,
        1.1014972611646225e-07,
        0.00516000000022552,
        2.657294475548769e-05,
    ]
    star["Becrux"] = [
        3.34981703178929,
        -1.0417654518737323,
        -2.3387455510248137e-07,
        -6.21529052883799e-08,
        0.009250000000247748,
        1.646772425062188e-05,
    ]
    star["Bellatrix"] = [
        1.4186518374129689,
        0.11082321019807921,
        -4.2421191775724186e-08,
        -6.438325858295131e-08,
        0.013420000000081509,
        3.77778985795775e-06,
    ]
    star["Betelgeuse"] = [
        1.5497291218333036,
        0.12927763286721894,
        1.324995949259527e-07,
        5.2650746120233373e-08,
        0.0076300000002801896,
        2.2478299265541744e-05,
    ]
    star["Birdun"] = [
        3.577435124514057,
        -0.9331646108382332,
        -7.078290116660212e-08,
        -6.200764883423321e-08,
        0.00868000000007837,
        5.542656158511533e-06,
    ]
    star["Canopus"] = [
        1.6753053550581112,
        -0.9197127760270881,
        9.691399928699686e-08,
        1.1475543795563986e-07,
        0.01043000000023061,
        1.3638797482580787e-05,
    ]
    star["Capella"] = [
        1.3818164179749326,
        0.8028163852556699,
        3.661175465513113e-07,
        -2.0707852618187437e-06,
        0.07729000004925092,
        0.0004820766940057257,
    ]
    star["Caph"] = [
        0.040025864271171274,
        1.0323584023330052,
        2.537401264788819e-06,
        -8.747256573612981e-07,
        0.05989000002945251,
        0.0003513394160527818,
    ]
    star["Castor"] = [
        1.9835582691444889,
        0.55655541096058,
        -1.0003082378134486e-06,
        -7.18400840114895e-07,
        0.06326999999699984,
        0.0006603500780342239,
    ]
    star["Deneb"] = [
        5.416768549639101,
        0.7902909845019924,
        7.563094426808563e-09,
        7.514611803495459e-09,
        0.0010099999999999966,
        0.00013325736873785185,
    ]
    star["Denebola"] = [
        3.0938569610040525,
        0.2543304289930705,
        -2.419311156063305e-06,
        -5.516334832548955e-07,
        0.09016000006262251,
        0.0005494092119495847,
    ]
    star["Diphda"] = [
        0.1901946478083879,
        -0.313925470771022,
        1.1285967507789465e-06,
        1.5858583005313695e-07,
        0.03404000001527349,
        0.0002960809516413248,
    ]
    star["Dschubba"] = [
        4.1902451316147795,
        -0.39482332143123317,
        -4.2033400895683004e-08,
        -1.7889624233267226e-07,
        0.008119999999989573,
        0.0008457168978493212,
    ]
    star["Dubhe"] = [
        2.8960653511533034,
        1.0777588451611648,
        -6.615730649573739e-07,
        -1.7089842010161175e-07,
        0.02638000000168808,
        4.129163182305979e-05,
    ]
    star["Durre Menthor"] = [
        0.45408540819664434,
        -0.2781614838923893,
        -8.347446041643784e-06,
        4.140809252755996e-06,
        0.2741700003075673,
        0.0025467724108209243,
    ]
    star["Elnath"] = [
        1.4237168137688543,
        0.49929418963649913,
        1.1286371385556528e-07,
        -8.446424361125599e-07,
        0.02488999999931021,
        0.0021102759572637353,
    ]
    star["Enif"] = [
        5.690584783936927,
        0.1723514602597197,
        1.4554107003664866e-07,
        6.690397468497408e-09,
        0.004850000000290319,
        3.6364339479757246e-05,
    ]
    star["Etamin"] = [
        4.69758079842709,
        0.8986507452358823,
        -4.13060240615731e-08,
        -1.1174956075521153e-07,
        0.022099999999988868,
        4.802365092647439e-05,
    ]
    star["Fomalhaut"] = [
        6.011133398285404,
        -0.5170055560865453,
        1.596116251175188e-06,
        -7.961514442642038e-07,
        0.13008000002377812,
        0.00016839652699463895,
    ]
    star["Foramen"] = [
        4.975479708318686,
        -0.9602030279549373,
        8.193332974001665e-09,
        8.896331075961123e-08,
        0.004790000000111848,
        1.4182818294769256e-05,
    ]
    star["Gacrux"] = [
        3.277578934434846,
        -0.9968135958390298,
        1.3546164292018533e-07,
        -1.2815079298710082e-06,
        0.03709000002118096,
        0.00038026031212998385,
    ]
    star["Gemma"] = [
        4.078344297757775,
        0.4662593500177362,
        5.836164784602716e-07,
        -4.3361855305783936e-07,
        0.04364999999923094,
        0.0004749733026092676,
    ]
    star["Gienah"] = [
        5.437619832660372,
        0.5928928235555605,
        1.7267450215552336e-06,
        1.6012305300227907e-06,
        0.04526000005787727,
        0.0008727564774680463,
    ]
    star["Girtab"] = [
        4.613423671040447,
        -0.750453597552295,
        2.9379711284354737e-08,
        -4.605726201560463e-09,
        0.011990000000006672,
        3.447754303400006e-07,
    ]
    star["Gruid"] = [
        5.9457560075832445,
        -0.8182902354262535,
        6.57795471464524e-07,
        -2.186320714946966e-08,
        0.01917000000274361,
        9.046731034516553e-05,
    ]
    star["Hadar"] = [
        3.681875666769781,
        -1.0537083159099074,
        -1.6464334143778704e-07,
        -1.2149420614057753e-07,
        0.006209999999994911,
        0.0009137322626429944,
    ]
    star["Hamal"] = [
        0.5548981381429913,
        0.40949653104300493,
        9.246801678210333e-07,
        -7.067156367318856e-07,
        0.04948000001509084,
        0.00021087217637601825,
    ]
    star["Herschel Star"] = [
        5.6876250069680605,
        1.0259053385102446,
        2.5404226643504052e-08,
        -1.3962636520298012e-08,
        0.0006200000000052498,
        5.085416049876108e-06,
    ]
    star["Izar"] = [
        3.8614843432159414,
        0.4725343244285851,
        -2.4555834257143246e-07,
        9.696252229133127e-08,
        0.015550000000782651,
        3.1492226299260285e-05,
    ]
    star["Kaus Australis"] = [
        4.81785946005412,
        -0.6001247657331712,
        -1.920360828391738e-07,
        -6.014112209360647e-07,
        0.02255000000518801,
        0.00014683170217628355,
    ]
    star["Kochab"] = [
        3.88643929589975,
        1.2942577193687248,
        -1.5654689526730107e-07,
        5.7741253070346283e-08,
        0.02579000000006858,
        1.7129342004436014e-06,
    ]
    star["Koo She"] = [
        2.289451216840046,
        -0.9548490600305676,
        1.3953112000316027e-07,
        -5.048848871271923e-07,
        0.040900000003322244,
        5.470925163339363e-05,
    ]
    star["Marchab"] = [
        6.042159155901372,
        0.265381926804241,
        2.962208678925014e-07,
        -2.0633689681602876e-07,
        0.023359999999888748,
        0.0004087188162900425,
    ]
    star["Marfikent"] = [
        3.8201207423147325,
        -0.7357928431030926,
        -1.7118813759578646e-07,
        -1.5727343050882903e-07,
        0.01057000000056649,
        3.307245114865675e-05,
    ]
    star["Markab"] = [
        2.4526837794332965,
        -0.9601172799234833,
        -5.197195577037533e-08,
        5.4493068865207765e-08,
        0.0060500000000541804,
        5.458012450383491e-06,
    ]
    star["Megrez"] = [
        3.208897607188377,
        0.9954069461371868,
        5.020735613243368e-07,
        3.786294101930466e-08,
        0.040050000000969345,
        1.6259857547990848e-05,
    ]
    star["Men"] = [
        3.8481427681460767,
        -0.8270801195052182,
        -1.0253832271040569e-07,
        -1.1742182770277311e-07,
        0.0059500000002614,
        2.6768924741820013e-05,
    ]
    star["Menkalinan"] = [
        1.5687409473992977,
        0.7844806923295367,
        -2.734833771211616e-07,
        -4.2666877732678e-09,
        0.03972000000047807,
        8.077866841049545e-06,
    ]
    star["Menkent"] = [
        3.694354541960444,
        -0.6347754647829705,
        -2.517670402545959e-06,
        -2.5106780511175216e-06,
        0.05351999997864442,
        0.007462351002327535,
    ]
    star["Merak"] = [
        2.8878245742140867,
        0.9840589883938196,
        3.9590055731762915e-07,
        1.6357550334360702e-07,
        0.041069999999882284,
        8.630312273508286e-05,
    ]
    star["Miaplacidus"] = [
        2.413801174909946,
        -1.2167948180623211,
        -7.643381275655257e-07,
        5.280122417775545e-07,
        0.029339999999607635,
        0.0007482912564705958,
    ]
    star["Mintaka"] = [
        1.448652420586415,
        -0.00522014083349973,
        8.09638847252015e-09,
        2.7149566172089492e-09,
        0.0035600000000010315,
        1.7533466749502158e-07,
    ]
    star["Mira"] = [
        0.6080140011354599,
        -0.05196967262254898,
        5.008130002773315e-08,
        -1.1610316590840949e-06,
        0.007789999999596873,
        0.036970271155935756,
    ]
    star["Mirach"] = [
        0.30426179810445714,
        0.6216960108990267,
        8.512785321533603e-07,
        -5.441093978100774e-07,
        0.016360000010577143,
        0.00040545055744113315,
    ]
    star["Mirzam"] = [
        1.6698426991230342,
        -0.31338988448214705,
        -1.6726072214528015e-08,
        -2.2786235829647604e-09,
        0.006530000000003624,
        3.3867852993203564e-07,
    ]
    star["Mizar"] = [
        3.5077838638014485,
        0.958628404984348,
        5.877380617263158e-07,
        -1.06708913392451e-07,
        0.041730000001590425,
        2.5733916214793855e-05,
    ]
    star["Muhlifein"] = [
        3.3227502442743475,
        -0.8545112548127091,
        -9.079591681664306e-07,
        -5.814190122337764e-09,
        0.025010000004733652,
        0.00012164997237657486,
    ]
    star["Naos"] = [
        2.1100341367394244,
        -0.6981866381710968,
        -1.4941939802191323e-07,
        8.13033505639689e-08,
        0.0023300000002796344,
        7.2411876515134e-05,
    ]
    star["Nunki"] = [
        4.953529835884698,
        -0.45896438681501256,
        6.724380594918214e-08,
        -2.5525438690477914e-07,
        0.014539999999961669,
        0.0005593364499884,
    ]
    star["Peacock"] = [
        5.347896386484919,
        -0.9902141254885577,
        3.7379551496239335e-08,
        -4.1766698066042975e-07,
        0.01780000000237717,
        8.409157509678797e-05,
    ]
    star["Phad"] = [
        3.114671253650366,
        0.9371503547781461,
        5.224358961370977e-07,
        5.410406670048923e-08,
        0.03898999999985267,
        0.0001250822294595826,
    ]
    star["Polaris"] = [
        0.6622870783855511,
        1.5579526146588887,
        2.143679770371289e-07,
        -5.6917131328885613e-08,
        0.007560000000045417,
        3.6765977876544674e-06,
    ]
    star["Pollux"] = [
        2.0303268775181493,
        0.4891494417418841,
        -3.0334244212418148e-06,
        -2.2280529815649845e-07,
        0.09674000007630805,
        0.0006388254687689694,
    ]
    star["Procyon"] = [
        2.0040830303405817,
        0.09119331089376545,
        -3.4740014789585755e-06,
        -5.015794951595126e-06,
        0.28593000012325565,
        0.0011114621313062132,
    ]
    star["Rasalhague"] = [
        4.603020032838227,
        0.21921395635258004,
        5.336806521497666e-07,
        -1.0792442623224807e-06,
        0.06983999999615671,
        0.0006455022142178615,
    ]
    star["Regor"] = [
        2.1359886171340388,
        -0.8261793119496096,
        -2.874942507470025e-08,
        4.7996558035644583e-08,
        0.003880000000037908,
        5.919686689624988e-06,
    ]
    star["Regulus"] = [
        2.654523170215836,
        0.2088671656256774,
        -1.2091254273657336e-06,
        2.3801755601775115e-08,
        0.04209000001772499,
        0.0002846563084101535,
    ]
    star["Rigel"] = [
        1.3724303735043253,
        -0.14314563169358496,
        9.066015898862096e-09,
        -2.7149565126160305e-09,
        0.004220000000001239,
        1.7827829792688708e-07,
    ]
    star["Sabik"] = [
        4.495872625690414,
        -0.2744514560029489,
        1.9954884543000435e-07,
        4.734206505343233e-07,
        0.038770000003338655,
        5.7629956315342975e-05,
    ]
    star["Sadira"] = [
        0.9290861576667251,
        -0.16507781574780753,
        -4.733913496726316e-06,
        8.715281870756593e-08,
        0.3107500000516688,
        0.0006008398051309498,
    ]
    star["Sadr"] = [
        5.33297726230201,
        0.7026115986306855,
        1.1780971663460847e-08,
        -4.508767833519213e-09,
        0.0021400000000014355,
        4.0464265596141945e-07,
    ]
    star["Saiph"] = [
        1.5173738959141352,
        -0.16876644074429167,
        7.514612187441671e-09,
        -5.817764091322442e-09,
        0.004519999999999985,
        7.092704480158361e-06,
    ]
    star["Scheat"] = [
        6.0378533161707075,
        0.4901371355826427,
        9.102918408944408e-07,
        6.671490937534174e-07,
        0.01637000001487872,
        0.0005700087133755136,
    ]
    star["Schedar"] = [
        0.1767448848488985,
        0.9867625771254372,
        2.4415116079834703e-07,
        -1.559648010724851e-07,
        0.014269999999976789,
        0.0003578593352524097,
    ]
    star["Shaula"] = [
        4.597235159830863,
        -0.6475838446748894,
        -4.3148500591832e-08,
        -1.45201689650351e-07,
        0.0046400000003139425,
        4.1079552278046575e-05,
    ]
    star["Sirius"] = [
        1.7677953617808355,
        -0.2917512845638483,
        -2.647213688408054e-06,
        -5.929642226411401e-06,
        0.37920999939568256,
        0.001399942073058308,
    ]
    star["South Star"] = [
        5.536041071313252,
        -1.5525837984686774,
        1.2585468727789067e-07,
        2.4337649316578723e-08,
        0.012070000000008256,
        4.237909383943523e-07,
    ]
    star["Spica"] = [
        3.5133172226917027,
        -0.19480181898330715,
        -2.0604592396526213e-07,
        -1.5383131043286519e-07,
        0.012440000000890464,
        4.440134144092039e-05,
    ]
    star["Suhail"] = [
        2.391083880584546,
        -0.758041686556806,
        -1.1252512625451906e-07,
        6.923144900242576e-08,
        0.00569000000016125,
        1.7255360405195454e-05,
    ]
    star["Thuban"] = [
        3.684345910320117,
        1.1235705505483826,
        -2.7401752617480493e-07,
        8.33392154724013e-08,
        0.010560000000291144,
        1.7013085343199824e-05,
    ]
    star["Toliman"] = [
        3.838179148984009,
        -1.0617531618986407,
        -1.7831061001741384e-05,
        2.337210769544031e-06,
        0.7421199976972916,
        0.0011684490964319319,
    ]
    star["Tsih"] = [
        0.2474379539766081,
        1.0597070305476959,
        1.2435463730083218e-07,
        -1.851994037328357e-08,
        0.005320000000056891,
        6.504699275465271e-06,
    ]
    star["Turais"] = [
        2.4307649402371365,
        -1.0345479156330444,
        -9.225987077009457e-08,
        6.355910632051448e-08,
        0.004710000000088263,
        1.1379802060468165e-05,
    ]
    star["Vega"] = [
        4.873563105816288,
        0.6769031238891855,
        9.745915701840644e-07,
        1.3936413475012163e-06,
        0.12893000002352079,
        0.00016726661591985996,
    ]
    star["Wei"] = [
        4.407675429173172,
        -0.5985298099221946,
        -2.9662794787720593e-06,
        -1.2404569108020894e-06,
        0.04985000009329441,
        0.0012954586004889708,
    ]
    star["Wezen"] = [
        1.869210136468276,
        -0.4606482342432647,
        -1.3332374360332953e-08,
        1.6144296200572525e-08,
        0.0018200000000057287,
        1.8966479050654466e-06,
    ]

    return star
