import random
import string
from datetime import (
    datetime,
    timezone,
)

RUN_ID_ADJECTIVES = [
    "tiny",
    "small",
    "large",
    "mega",
    "micro",
    "giant",
    "nano",
    "vast",
    "colossal",
    "atomic",
    "massive",
    "compact",
    "mammoth",
    "expansive",
    "immense",
    "miniature",
    "enormous",
    "substantial",
    "minimal",
    "mighty",
    "petite",
    "grand",
    "extensive",
    "broad",
    "condensed",
    "infinite",
    "limited",
    "scaled",
    "sizeable",
    "microscopic",
    "swift",
    "rapid",
    "fast",
    "quick",
    "agile",
    "turbo",
    "sonic",
    "instant",
    "nimble",
    "speedy",
    "prompt",
    "brisk",
    "hasty",
    "dynamic",
    "responsive",
    "accelerated",
    "efficient",
    "streamlined",
    "optimized",
    "enhanced",
    "expedited",
    "immediate",
    "lightning",
    "blazing",
    "turbocharged",
    "velocity",
    "express",
    "urgent",
    "smooth",
    "steady",
    "consistent",
    "stable",
    "balanced",
    "fluid",
    "seamless",
    "continuous",
    "smart",
    "wise",
    "clever",
    "sharp",
    "bright",
    "neural",
    "deep",
    "learned",
    "trained",
    "evolved",
    "intelligent",
    "advanced",
    "skilled",
    "capable",
    "expert",
    "proficient",
    "seasoned",
    "sophisticated",
    "innovative",
    "creative",
    "analytical",
    "logical",
    "strategic",
    "tactical",
    "calculated",
    "methodical",
    "systematic",
    "organized",
    "structured",
    "planned",
    "precise",
    "accurate",
    "exact",
    "refined",
    "robust",
    "stable",
    "reliable",
    "secure",
    "protected",
    "fortified",
    "hardened",
    "resilient",
    "durable",
    "sustained",
    "persistent",
    "consistent",
    "dependable",
    "proven",
    "tested",
    "verified",
    "validated",
    "certified",
    "approved",
    "confirmed",
    "guaranteed",
    "assured",
    "maintained",
    "monitored",
    "managed",
    "controlled",
    "regulated",
    "standardized",
    "normalized",
    "unified",
    "integrated",
    "cached",
    "indexed",
    "threaded",
    "parallel",
    "serial",
    "distributed",
    "clustered",
    "networked",
    "connected",
    "linked",
    "coupled",
    "joined",
    "unified",
    "integrated",
    "processed",
    "computed",
    "calculated",
    "analyzed",
    "evaluated",
    "measured",
    "assessed",
    "tracked",
    "monitored",
    "logged",
    "recorded",
    "stored",
    "archived",
    "backed",
    "replicated",
    "synced",
    "updated",
    "quantum",
    "atomic",
    "neural",
    "cosmic",
    "binary",
    "digital",
    "linear",
    "nonlinear",
    "exponential",
    "logarithmic",
    "geometric",
    "algebraic",
    "numeric",
    "mathematical",
    "scientific",
    "empirical",
    "theoretical",
    "analytical",
    "statistical",
    "probabilistic",
    "stochastic",
    "deterministic",
    "dynamic",
    "static",
    "kinetic",
    "potential",
    "thermal",
    "electric",
    "magnetic",
    "optical",
    "optimal",
    "efficient",
    "lean",
    "precise",
    "exact",
    "tuned",
    "refined",
    "balanced",
    "scaled",
    "optimized",
    "enhanced",
    "improved",
    "upgraded",
    "advanced",
    "superior",
    "premium",
    "ultimate",
    "maximal",
    "prime",
    "ideal",
    "perfect",
    "complete",
    "absolute",
    "total",
    "full",
    "comprehensive",
    "thorough",
    "extensive",
    "detailed",
    "modern",
    "innovative",
    "novel",
    "fresh",
    "current",
    "contemporary",
    "trending",
    "advanced",
    "progressive",
    "forward",
    "cutting",
    "bleeding",
    "leading",
    "pioneering",
    "groundbreaking",
    "revolutionary",
    "transformative",
    "disruptive",
    "emerging",
    "evolving",
    "developing",
    "growing",
    "expanding",
    "scaling",
    "adapting",
    "stable",
    "reliable",
    "robust",
    "solid",
    "strong",
    "firm",
    "steady",
    "constant",
    "consistent",
    "uniform",
    "regular",
    "standard",
    "typical",
    "normal",
    "natural",
    "genuine",
    "authentic",
    "original",
    "primary",
    "essential",
    "fundamental",
    "basic",
    "core",
    "central",
    "key",
    "critical",
    "crucial",
    "vital",
    "important",
    "professional",
    "enterprise",
    "corporate",
    "business",
    "commercial",
    "industrial",
    "institutional",
    "organizational",
    "operational",
    "functional",
    "practical",
    "pragmatic",
    "realistic",
    "reasonable",
    "sensible",
    "sound",
    "valid",
    "viable",
    "workable",
    "feasible",
    "possible",
    "potential",
    "prospective",
    "promising",
    "active",
    "alert",
    "aware",
    "focused",
    "centered",
    "balanced",
    "harmonious",
    "peaceful",
    "calm",
    "quiet",
    "silent",
    "smooth",
    "sleek",
    "clean",
    "clear",
    "bright",
    "brilliant",
    "radiant",
    "shining",
    "glowing",
    "vibrant",
    "dynamic",
    "energetic",
    "powerful",
    "strong",
    "mighty",
    "forceful",
    "intense",
    "blue",
    "azure",
    "crystal",
    "silver",
    "golden",
    "chrome",
    "platinum",
    "titanium",
    "steel",
    "iron",
    "copper",
    "bronze",
    "metallic",
    "neutral",
    "balanced",
    "clear",
    "transparent",
    "translucent",
    "opaque",
    "solid",
    "matte",
    "glossy",
    "polished",
    "refined",
    "smooth",
    "textured",
    "structured",
    "patterned",
    "graduated",
]

RUN_ID_NOUNS = [
    "dolphin",
    "raven",
    "octopus",
    "elephant",
    "owl",
    "chimp",
    "falcon",
    "wolf",
    "parrot",
    "crow",
    "macaw",
    "eagle",
    "hawk",
    "whale",
    "gorilla",
    "orangutan",
    "raccoon",
    "seal",
    "bear",
    "fox",
    "penguin",
    "turtle",
    "squirrel",
    "beaver",
    "tensor",
    "vector",
    "matrix",
    "graph",
    "neuron",
    "scalar",
    "gradient",
    "kernel",
    "entropy",
    "qubit",
    "lattice",
    "manifold",
    "fractal",
    "polygon",
    "vertex",
    "array",
    "sequence",
    "series",
    "function",
    "factor",
    "quotient",
    "product",
    "dividend",
    "integer",
    "decimal",
    "fraction",
    "equation",
    "formula",
    "theorem",
    "axiom",
    "lemma",
    "proof",
    "hypothesis",
    "theory",
    "law",
    "principle",
    "constant",
    "variable",
    "parameter",
    "coefficient",
    "exponent",
    "logarithm",
    "derivative",
    "integral",
    "polynomial",
    "algorithm",
    "pattern",
    "symmetry",
    "topology",
    "server",
    "cluster",
    "router",
    "switch",
    "beacon",
    "proxy",
    "gateway",
    "bridge",
    "firewall",
    "database",
    "cache",
    "buffer",
    "stack",
    "heap",
    "queue",
    "array",
    "list",
    "tree",
    "graph",
    "table",
    "index",
    "query",
    "schema",
    "model",
    "view",
    "pipeline",
    "stream",
    "batch",
    "thread",
    "process",
    "service",
    "client",
    "host",
    "node",
    "endpoint",
    "interface",
    "protocol",
    "packet",
    "frame",
    "socket",
    "port",
    "driver",
    "kernel",
    "shell",
    "console",
    "terminal",
    "script",
    "module",
    "plugin",
    "model",
    "layer",
    "neuron",
    "synapse",
    "weight",
    "bias",
    "epoch",
    "batch",
    "feature",
    "label",
    "class",
    "instance",
    "sample",
    "dataset",
    "tensor",
    "vector",
    "matrix",
    "gradient",
    "optimizer",
    "loss",
    "metric",
    "accuracy",
    "precision",
    "recall",
    "encoder",
    "decoder",
    "transformer",
    "attention",
    "embedding",
    "token",
    "sequence",
    "pipeline",
    "checkpoint",
    "baseline",
    "benchmark",
    "parameter",
    "hyperparameter",
    "architecture",
    "framework",
    "library",
    "runtime",
    "inference",
    "array",
    "list",
    "stack",
    "queue",
    "tree",
    "graph",
    "hash",
    "heap",
    "map",
    "table",
    "index",
    "key",
    "value",
    "pair",
    "tuple",
    "struct",
    "object",
    "class",
    "method",
    "function",
    "module",
    "package",
    "library",
    "framework",
    "pattern",
    "singleton",
    "factory",
    "builder",
    "adapter",
    "proxy",
    "facade",
    "bridge",
    "composite",
    "decorator",
    "observer",
    "strategy",
    "command",
    "state",
    "iterator",
    "radar",
    "sonar",
    "laser",
    "sensor",
    "probe",
    "scanner",
    "meter",
    "gauge",
    "scope",
    "lens",
    "prism",
    "filter",
    "crystal",
    "magnet",
    "compass",
    "beacon",
    "signal",
    "pulse",
    "wave",
    "beam",
    "ray",
    "field",
    "grid",
    "mesh",
    "lattice",
    "chamber",
    "reactor",
    "generator",
    "transformer",
    "capacitor",
    "resistor",
    "inductor",
    "oscillator",
    "amplifier",
    "detector",
    "collector",
    "emitter",
    "nova",
    "nebula",
    "star",
    "cosmos",
    "aurora",
    "quasar",
    "pulsar",
    "photon",
    "galaxy",
    "planet",
    "moon",
    "asteroid",
    "comet",
    "meteor",
    "satellite",
    "orbit",
    "cluster",
    "system",
    "void",
    "horizon",
    "ray",
    "beam",
    "field",
    "wave",
    "particle",
    "matter",
    "energy",
    "force",
    "mass",
    "charge",
    "spin",
    "momentum",
    "velocity",
    "carbon",
    "xenon",
    "neon",
    "titan",
    "argon",
    "silicon",
    "helium",
    "nitrogen",
    "oxygen",
    "hydrogen",
    "lithium",
    "sodium",
    "potassium",
    "calcium",
    "iron",
    "copper",
    "silver",
    "gold",
    "platinum",
    "titanium",
    "chromium",
    "tungsten",
    "crystal",
    "metal",
    "alloy",
    "polymer",
    "ceramic",
    "composite",
    "semiconductor",
    "mind",
    "logic",
    "spark",
    "core",
    "apex",
    "vision",
    "wisdom",
    "insight",
    "theory",
    "concept",
    "idea",
    "thought",
    "notion",
    "paradigm",
    "principle",
    "doctrine",
    "theorem",
    "law",
    "rule",
    "guide",
    "method",
    "process",
    "system",
    "framework",
    "structure",
    "pattern",
    "form",
    "shape",
    "design",
    "plan",
    "model",
    "system",
    "service",
    "product",
    "project",
    "program",
    "platform",
    "solution",
    "framework",
    "standard",
    "protocol",
    "process",
    "method",
    "model",
    "metric",
    "target",
    "goal",
    "objective",
    "strategy",
    "tactic",
    "plan",
    "policy",
    "rule",
    "guide",
    "baseline",
    "benchmark",
    "milestone",
    "phase",
    "stage",
    "cycle",
    "sprint",
    "circuit",
    "board",
    "chip",
    "unit",
    "core",
    "module",
    "component",
    "element",
    "device",
    "machine",
    "engine",
    "driver",
    "controller",
    "processor",
    "memory",
    "storage",
    "disk",
    "drive",
    "port",
    "cable",
    "wire",
    "node",
    "terminal",
    "interface",
    "display",
    "screen",
    "sensor",
    "transmitter",
    "receiver",
    "antenna",
    "metric",
    "measure",
    "scale",
    "index",
    "ratio",
    "rate",
    "factor",
    "level",
    "degree",
    "grade",
    "rank",
    "score",
    "point",
    "mark",
    "value",
    "quantity",
    "amount",
    "volume",
    "mass",
    "weight",
    "size",
    "length",
    "width",
    "height",
    "depth",
    "area",
    "space",
    "time",
    "duration",
    "period",
    "interval",
    "frequency",
]


def generate_run_id() -> str:
    """
    Generates a unique, human-readable run ID if the run ID is not provided.

    A total of 356x425x36^5=~9 trillion unique run IDs are generated within each millisecond.

    The ID combines:
    - A randomly selected adjective from a curated list (e.g., "swift", "smart", "robust")
    - A randomly selected noun from a curated list (e.g., "dolphin", "tensor", "nova")
    - The current timestamp in milliseconds
    - A 5-char random alphanumeric suffix (for additional uniqueness)

    The generated ID follows the format: "{adjective}-{noun}-{timestamp}-{suffix}"

    Returns:
        str: A unique run ID in the format "adjective-noun-timestamp-suffix"
            (e.g., "swift-dolphin-20250319124841544-y56es")
    """
    adjective = random.choice(RUN_ID_ADJECTIVES)
    noun = random.choice(RUN_ID_NOUNS)

    ts = datetime.now(timezone.utc).strftime("%Y%m%d%H%M%S%f")[:-3]
    chars = string.ascii_lowercase + string.digits
    suffix = "".join(random.choices(chars, k=5))

    return f"{adjective}-{noun}-{ts}-{suffix}"
