# Electrical Grid Simulator (EGS)
The *Electrical Grid Simulator* (abbreviated as **EGS**) is a graphical user interface application for simulating electrical networks based on the [pandapower](https://www.pandapower.org/) library. The main objective is to allow the creation of mathematical models for steady-state electrical grids from a user-friendly interface. It adds an extensions system for including new calculation or simulation algorithms. Extensions are implemented as standard Python packages, so they can be distributed through the [PyPI repository](https://pypi.org/).

EGS is developed at the *National Technological University, Santa Fe Regional Faculty* ([UTN-FRSF](https://www.frsf.utn.edu.ar/)), at the *Center for Research and Development in Electrical Engineering and Energy Systems* ([CIESE](https://www.frsf.utn.edu.ar/investigacion-y-vinculacion/investigacion-y-vinculacion/centros-y-grupos/ciese)), Argentina.

> __Warning__ <br>
> <span style="color:red">
<b>This application is in an early stage of development. So you can expect incomplete sections and some (or many) bugs. New changes may cause incompatibilities with older versions (old files that no longer work with newer versions of the program).</b>
</span>

## Goals
- Providing a minimalistic, modern and good-looking interface.
- Multiplatform: GNU/Linux, MS Windows and Apple MacOS (not tested on MacOS).
- Providing an extensions system to expand its capabilities.

## How it is built
EGS is built in Python and entirely from open source and free software. The main core components are:

* The [pandapower](https://www.pandapower.org/) modeling and calculation library for electrical power systems.
* The [Qt](https://www.qt.io/) toolkit with [PySide6](https://wiki.qt.io/Qt_for_Python) bindings for the UI.
* A `Qt6` port (fork) of the [NodeGraphQt](https://github.com/jchanvfx/NodeGraphQt) library for building the graph (schematic network graphic).
* The [PyQtDarkTheme](https://github.com/5yutan5/PyQtDarkTheme) package for applying modern themes (light and dark themes).
* The [QtAwesome](https://github.com/spyder-ide/qtawesome) package for modern flat monochromatic icons.
* The [matplotlib](https://matplotlib.org/) package for plotting calculation results.
* Other scientific Python packages, mainly [NumPy](https://numpy.org/) and [pandas](https://pandas.pydata.org/).

EGS is implemented as a Python package uploaded to the [PyPI repository](https://pypi.org/). ```pandapower``` and other packages listed above are set as dependencies.

> [!NOTE]  
> Starting with version **0.0.8.0**, the EGS package includes a fork of `NodeGraphQt` ported to `Qt6` (using the `PySide6` library). This implementation is renamed to `NodeGraphQt6` in order to avoid conflicts. These changes allow the application to run on recent versions of Python.

## Simulations and calculations
With EGS you can build and set up the model of an electrical grid in a graphical way. The application also allows you to perform *balanced power flow* calculations (other calculations supported by ```pandapower``` may be added in the future), including a *Balanced Altern Current Power Flow (ACPF)* and a *Direct Current Power Flow (DCPF)*. For other types of simulations and calculations, you can proceed according to two alternatives:

1. Export the **Data model** and the last power flow results to a JSON, MS Excel or binary file (using the `pickle` module) ready to be imported from a Python script through ```pandapower```. Then, any calculation or processing can be done from the script. The export is done from the graphical interface, while the subsequent import is done as indicated [in the pandapower documentation](https://pandapower.readthedocs.io/en/latest/file_io.html#save-and-load-networks), using one of the fuctions: `pandapower.from_json()`, `pandapower.from_excel()` or `pandapower.from_pickle()`.

2. Incorporate the required calculation functionality from an extension developed in Python. This way, the calculation is executed from within EGS. Extensions are implemented as regular Python packages. An Optimal Power Flow (OPF) extension is available in the PyPI repository (package name: **electricalsim-opf-quadratic**).

Models generated by EGS can be saved in a **.egs** file. You can then reopen the file whenever you need it and retrieve even the results of the last power flow run.




# Installation
EGS is installed using ```pip```, the official Python package manager.

On GNU/Linux and MacOS execute the following order in a terminal:
```bash
pip install electricalsim
```

On MS Windows you may prefer:
```bash
python -m pip install electricalsim
```

## Upgrading EGS
In order to upgrade EGS via ```pip```, execute the following in a terminal:

```bash
pip install electricalsim -U
```
On MS Windows you may prefer:
```bash
python -m pip install electricalsim -U
```

## Running EGS
Once installed, you can run it with the command:

```bash
egs
```

If you prefer to run the program in a more practical way, just execute this command only once:

```bash
egs-create-shortcut
```

This will add a shortcut launcher to your desktop and to your application menu. Note that this launcher will not work if you are installing the application into a Python virtual environment.


## Uninstalling
If you want to remove the application, execute:

```bash
pip uninstall electricalsim
```

On MS Windows:
```bash
python -m pip uninstall electricalsim
```

Note that shortcuts added with the ```egs-create-shortcut``` command are not removed. So you must delete them manually.

## Installing extensions

Extensions available in the PyPI repository can be installed using ```pip```. For example, the Optimal Power Flow extension is installed with:

```bash
pip install electricalsim-opf-quadratic
```

On MS Windows:
```bash
python -m pip install electricalsim-opf-quadratic
```

# License

This project uses the [MIT license](https://github.com/aloytag/electrical-grid-simulator/blob/main/LICENSE).