"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeEventPattern = void 0;
/**
 * Merge the `src` event pattern into the `dest` event pattern by adding all
 * values from `src` into the fields in `dest`.
 *
 * See `rule.addEventPattern` for details.
 */
function mergeEventPattern(dest, src) {
    dest = dest || {};
    mergeObject(dest, src);
    return dest;
    function mergeObject(destObj, srcObj) {
        if (typeof (srcObj) !== 'object') {
            throw new Error(`Invalid event pattern '${JSON.stringify(srcObj)}', expecting an object or an array`);
        }
        for (const field of Object.keys(srcObj)) {
            const srcValue = srcObj[field];
            const destValue = destObj[field];
            if (srcValue === undefined) {
                continue;
            }
            if (typeof (srcValue) !== 'object') {
                throw new Error(`Invalid event pattern field { ${field}: ${JSON.stringify(srcValue)} }. All fields must be arrays`);
            }
            // dest doesn't have this field
            if (destObj[field] === undefined) {
                destObj[field] = srcValue;
                continue;
            }
            if (Array.isArray(srcValue) !== Array.isArray(destValue)) {
                throw new Error(`Invalid event pattern field ${field}. ` +
                    `Type mismatch between existing pattern ${JSON.stringify(destValue)} and added pattern ${JSON.stringify(srcValue)}`);
            }
            // if this is an array, concat the values
            if (Array.isArray(srcValue)) {
                destObj[field] = destValue.concat(srcValue);
                continue;
            }
            // otherwise, it's an object, so recurse
            mergeObject(destObj[field], srcValue);
        }
    }
}
exports.mergeEventPattern = mergeEventPattern;
//# sourceMappingURL=data:application/json;base64,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