# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

import types

__config__ = pulumi.Config('azuread')


class _ExportableConfig(types.ModuleType):
    @_builtins.property
    def ado_pipeline_service_connection_id(self) -> Optional[str]:
        """
        The Azure DevOps Pipeline Service Connection ID.
        """
        return __config__.get('adoPipelineServiceConnectionId')

    @_builtins.property
    def client_certificate(self) -> Optional[str]:
        """
        Base64 encoded PKCS#12 certificate bundle to use when authenticating as a Service Principal using a Client Certificate
        """
        return __config__.get('clientCertificate')

    @_builtins.property
    def client_certificate_password(self) -> Optional[str]:
        """
        The password to decrypt the Client Certificate. For use when authenticating as a Service Principal using a Client Certificate
        """
        return __config__.get('clientCertificatePassword')

    @_builtins.property
    def client_certificate_path(self) -> Optional[str]:
        """
        The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service Principal using a Client Certificate
        """
        return __config__.get('clientCertificatePath')

    @_builtins.property
    def client_id(self) -> Optional[str]:
        """
        The Client ID which should be used for service principal authentication
        """
        return __config__.get('clientId')

    @_builtins.property
    def client_id_file_path(self) -> Optional[str]:
        """
        The path to a file containing the Client ID which should be used for service principal authentication
        """
        return __config__.get('clientIdFilePath')

    @_builtins.property
    def client_secret(self) -> Optional[str]:
        """
        The application password to use when authenticating as a Service Principal using a Client Secret
        """
        return __config__.get('clientSecret')

    @_builtins.property
    def client_secret_file_path(self) -> Optional[str]:
        """
        The path to a file containing the application password to use when authenticating as a Service Principal using a Client Secret
        """
        return __config__.get('clientSecretFilePath')

    @_builtins.property
    def disable_terraform_partner_id(self) -> Optional[bool]:
        return __config__.get_bool('disableTerraformPartnerId')

    @_builtins.property
    def environment(self) -> str:
        """
        The cloud environment which should be used. Possible values are: `global` (also `public`), `usgovernmentl4` (also `usgovernment`), `usgovernmentl5` (also `dod`), and `china`. Defaults to `global`. Not used and should not be specified when `metadata_host` is specified.
        """
        return __config__.get('environment') or (_utilities.get_env('ARM_ENVIRONMENT') or 'public')

    @_builtins.property
    def metadata_host(self) -> Optional[str]:
        """
        The Hostname which should be used for the Azure Metadata Service.
        """
        return __config__.get('metadataHost')

    @_builtins.property
    def msi_endpoint(self) -> Optional[str]:
        """
        The path to a custom endpoint for Managed Identity - in most circumstances this should be detected automatically
        """
        return __config__.get('msiEndpoint') or _utilities.get_env('ARM_MSI_ENDPOINT')

    @_builtins.property
    def oidc_request_token(self) -> Optional[str]:
        """
        The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID Connect.
        """
        return __config__.get('oidcRequestToken')

    @_builtins.property
    def oidc_request_url(self) -> Optional[str]:
        """
        The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal using OpenID Connect.
        """
        return __config__.get('oidcRequestUrl')

    @_builtins.property
    def oidc_token(self) -> Optional[str]:
        """
        The ID token for use when authenticating as a Service Principal using OpenID Connect.
        """
        return __config__.get('oidcToken')

    @_builtins.property
    def oidc_token_file_path(self) -> Optional[str]:
        """
        The path to a file containing an ID token for use when authenticating as a Service Principal using OpenID Connect.
        """
        return __config__.get('oidcTokenFilePath')

    @_builtins.property
    def partner_id(self) -> Optional[str]:
        """
        A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution
        """
        return __config__.get('partnerId')

    @_builtins.property
    def tenant_id(self) -> Optional[str]:
        """
        The Tenant ID which should be used. Works with all authentication methods except Managed Identity
        """
        return __config__.get('tenantId')

    @_builtins.property
    def use_aks_workload_identity(self) -> Optional[bool]:
        """
        Allow Azure AKS Workload Identity to be used for Authentication.
        """
        return __config__.get_bool('useAksWorkloadIdentity')

    @_builtins.property
    def use_cli(self) -> Optional[bool]:
        """
        Allow Azure CLI to be used for Authentication
        """
        return __config__.get_bool('useCli')

    @_builtins.property
    def use_msi(self) -> bool:
        """
        Allow Managed Identity to be used for Authentication
        """
        return __config__.get_bool('useMsi') or (_utilities.get_env_bool('ARM_USE_MSI') or False)

    @_builtins.property
    def use_oidc(self) -> Optional[bool]:
        """
        Allow OpenID Connect to be used for authentication
        """
        return __config__.get_bool('useOidc')

