# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SynchronizationJobArgs', 'SynchronizationJob']

@pulumi.input_type
class SynchronizationJobArgs:
    def __init__(__self__, *,
                 service_principal_id: pulumi.Input[_builtins.str],
                 template_id: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SynchronizationJob resource.
        :param pulumi.Input[_builtins.str] service_principal_id: The ID of the service principal for which this synchronization job should be created. Changing this field forces a new resource to be created.
        :param pulumi.Input[_builtins.str] template_id: Identifier of the synchronization template this job is based on.
        :param pulumi.Input[_builtins.bool] enabled: Whether the provisioning job is enabled. Default state is `true`.
        """
        pulumi.set(__self__, "service_principal_id", service_principal_id)
        pulumi.set(__self__, "template_id", template_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the service principal for which this synchronization job should be created. Changing this field forces a new resource to be created.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the synchronization template this job is based on.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "template_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the provisioning job is enabled. Default state is `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class _SynchronizationJobState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input['SynchronizationJobScheduleArgs']]]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SynchronizationJob resources.
        :param pulumi.Input[_builtins.bool] enabled: Whether the provisioning job is enabled. Default state is `true`.
        :param pulumi.Input[Sequence[pulumi.Input['SynchronizationJobScheduleArgs']]] schedules: A `schedule` list as documented below.
        :param pulumi.Input[_builtins.str] service_principal_id: The ID of the service principal for which this synchronization job should be created. Changing this field forces a new resource to be created.
        :param pulumi.Input[_builtins.str] template_id: Identifier of the synchronization template this job is based on.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the provisioning job is enabled. Default state is `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SynchronizationJobScheduleArgs']]]]:
        """
        A `schedule` list as documented below.
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SynchronizationJobScheduleArgs']]]]):
        pulumi.set(self, "schedules", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the service principal for which this synchronization job should be created. Changing this field forces a new resource to be created.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the synchronization template this job is based on.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_id", value)


@pulumi.type_token("azuread:index/synchronizationJob:SynchronizationJob")
class SynchronizationJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a synchronization job associated with a service principal (enterprise application) within Azure Active Directory.

        ## API Permissions

        The following API permissions are required in order to use this resource.

        When authenticated with a service principal, this resource requires one of the following application roles: `Application.ReadWrite.All` or `Directory.ReadWrite.All`

        ## Example Usage

        *Basic example*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.get_application_template(display_name="Azure Databricks SCIM Provisioning Connector")
        example_application_from_template = azuread.ApplicationFromTemplate("example",
            display_name="example",
            template_id=example.template_id)
        example_get_service_principal = azuread.get_service_principal_output(object_id=example_application_from_template.service_principal_object_id)
        example_synchronization_secret = azuread.SynchronizationSecret("example",
            service_principal_id=example_get_service_principal.id,
            credentials=[
                {
                    "key": "BaseAddress",
                    "value": "https://adb-example.azuredatabricks.net/api/2.0/preview/scim",
                },
                {
                    "key": "SecretToken",
                    "value": "some-token",
                },
            ])
        example_synchronization_job = azuread.SynchronizationJob("example",
            service_principal_id=example_get_service_principal.id,
            template_id="dataBricks",
            enabled=True)
        ```

        ## Import

        Synchronization jobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import azuread:index/synchronizationJob:SynchronizationJob example 00000000-0000-0000-0000-000000000000/job/dataBricks.f5532fc709734b1a90e8a1fa9fd03a82.8442fd39-2183-419c-8732-74b6ce866bd5
        ```

        -> This ID format is unique to Terraform and is composed of the Service Principal Object ID and the ID of the Synchronization Job Id in the format `{servicePrincipalId}/job/{jobId}`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the provisioning job is enabled. Default state is `true`.
        :param pulumi.Input[_builtins.str] service_principal_id: The ID of the service principal for which this synchronization job should be created. Changing this field forces a new resource to be created.
        :param pulumi.Input[_builtins.str] template_id: Identifier of the synchronization template this job is based on.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SynchronizationJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a synchronization job associated with a service principal (enterprise application) within Azure Active Directory.

        ## API Permissions

        The following API permissions are required in order to use this resource.

        When authenticated with a service principal, this resource requires one of the following application roles: `Application.ReadWrite.All` or `Directory.ReadWrite.All`

        ## Example Usage

        *Basic example*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.get_application_template(display_name="Azure Databricks SCIM Provisioning Connector")
        example_application_from_template = azuread.ApplicationFromTemplate("example",
            display_name="example",
            template_id=example.template_id)
        example_get_service_principal = azuread.get_service_principal_output(object_id=example_application_from_template.service_principal_object_id)
        example_synchronization_secret = azuread.SynchronizationSecret("example",
            service_principal_id=example_get_service_principal.id,
            credentials=[
                {
                    "key": "BaseAddress",
                    "value": "https://adb-example.azuredatabricks.net/api/2.0/preview/scim",
                },
                {
                    "key": "SecretToken",
                    "value": "some-token",
                },
            ])
        example_synchronization_job = azuread.SynchronizationJob("example",
            service_principal_id=example_get_service_principal.id,
            template_id="dataBricks",
            enabled=True)
        ```

        ## Import

        Synchronization jobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import azuread:index/synchronizationJob:SynchronizationJob example 00000000-0000-0000-0000-000000000000/job/dataBricks.f5532fc709734b1a90e8a1fa9fd03a82.8442fd39-2183-419c-8732-74b6ce866bd5
        ```

        -> This ID format is unique to Terraform and is composed of the Service Principal Object ID and the ID of the Synchronization Job Id in the format `{servicePrincipalId}/job/{jobId}`.

        :param str resource_name: The name of the resource.
        :param SynchronizationJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SynchronizationJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SynchronizationJobArgs.__new__(SynchronizationJobArgs)

            __props__.__dict__["enabled"] = enabled
            if service_principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_principal_id'")
            __props__.__dict__["service_principal_id"] = service_principal_id
            if template_id is None and not opts.urn:
                raise TypeError("Missing required property 'template_id'")
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["schedules"] = None
        super(SynchronizationJob, __self__).__init__(
            'azuread:index/synchronizationJob:SynchronizationJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SynchronizationJobScheduleArgs', 'SynchronizationJobScheduleArgsDict']]]]] = None,
            service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            template_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SynchronizationJob':
        """
        Get an existing SynchronizationJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the provisioning job is enabled. Default state is `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SynchronizationJobScheduleArgs', 'SynchronizationJobScheduleArgsDict']]]] schedules: A `schedule` list as documented below.
        :param pulumi.Input[_builtins.str] service_principal_id: The ID of the service principal for which this synchronization job should be created. Changing this field forces a new resource to be created.
        :param pulumi.Input[_builtins.str] template_id: Identifier of the synchronization template this job is based on.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SynchronizationJobState.__new__(_SynchronizationJobState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["schedules"] = schedules
        __props__.__dict__["service_principal_id"] = service_principal_id
        __props__.__dict__["template_id"] = template_id
        return SynchronizationJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the provisioning job is enabled. Default state is `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> pulumi.Output[Sequence['outputs.SynchronizationJobSchedule']]:
        """
        A `schedule` list as documented below.
        """
        return pulumi.get(self, "schedules")

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the service principal for which this synchronization job should be created. Changing this field forces a new resource to be created.
        """
        return pulumi.get(self, "service_principal_id")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the synchronization template this job is based on.
        """
        return pulumi.get(self, "template_id")

