# ruff: noqa
GRAPHENE_NICKEL_INTERFACE = {
    "metadata": {
        "build": [
            {
                "configuration": {
                    "stack_components": [
                        {
                            "xy_supercell_matrix": [[1, 0], [0, 1]],
                            "strain_matrix": [[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                            "stack_components": [
                                {
                                    "miller_indices": [1, 1, 1],
                                    "crystal": {
                                        "metadata": {"build": []},
                                        "name": "Ni, Nickel, FCC (Fm-3m) 3D (Bulk), mp-23",
                                        "isDefault": False,
                                        "basis": {
                                            "elements": [{"id": 0, "value": "Ni"}],
                                            "coordinates": [{"id": 0, "value": [0, 0, 0]}],
                                            "units": "crystal",
                                            "labels": [],
                                            "constraints": [],
                                        },
                                        "lattice": {
                                            "a": 2.478974,
                                            "b": 2.478974,
                                            "c": 2.478974,
                                            "alpha": 60,
                                            "beta": 60,
                                            "gamma": 60,
                                            "units": {"length": "angstrom", "angle": "degree"},
                                            "type": "FCC",
                                        },
                                        "external": {
                                            "id": "mp-23",
                                            "source": "Materials Project",
                                            "origin": True,
                                            "doi": "10.17188/1199153",
                                            "url": "https://next-gen.materialsproject.org/materials/mp-23",
                                        },
                                        "isNonPeriodic": False,
                                    },
                                    "use_conventional_cell": True,
                                    "termination_top": {
                                        "chemical_elements": "Ni",
                                        "space_group_symmetry_label": "R-3m_4",
                                    },
                                    "number_of_repetitions": 3,
                                },
                                {
                                    "direction": "z",
                                    "size": 0,
                                    "crystal": {
                                        "metadata": {
                                            "build": [
                                                {
                                                    "configuration": {
                                                        "miller_indices": [1, 1, 1],
                                                        "crystal": {
                                                            "metadata": {"build": []},
                                                            "name": "Ni, Nickel, FCC (Fm-3m) 3D (Bulk), mp-23",
                                                            "isDefault": False,
                                                            "basis": {
                                                                "elements": [{"id": 0, "value": "Ni"}],
                                                                "coordinates": [{"id": 0, "value": [0, 0, 0]}],
                                                                "units": "crystal",
                                                                "labels": [],
                                                                "constraints": [],
                                                            },
                                                            "lattice": {
                                                                "a": 2.478974,
                                                                "b": 2.478974,
                                                                "c": 2.478974,
                                                                "alpha": 60,
                                                                "beta": 60,
                                                                "gamma": 60,
                                                                "units": {"length": "angstrom", "angle": "degree"},
                                                                "type": "FCC",
                                                            },
                                                            "external": {
                                                                "id": "mp-23",
                                                                "source": "Materials Project",
                                                                "origin": True,
                                                                "doi": "10.17188/1199153",
                                                                "url": "https://next-gen.materialsproject.org/materials/mp-23",
                                                            },
                                                            "isNonPeriodic": False,
                                                        },
                                                        "use_conventional_cell": True,
                                                        "termination_top": {
                                                            "chemical_elements": "Ni",
                                                            "space_group_symmetry_label": "R-3m_4",
                                                        },
                                                        "number_of_repetitions": 3,
                                                    },
                                                    "build_parameters": {},
                                                }
                                            ],
                                            "boundaryConditions": {"type": "pbc", "offset": 0},
                                        },
                                        "name": "Ni(111), termination Ni_R-3m_4",
                                        "isDefault": False,
                                        "formula": "Ni",
                                        "basis": {
                                            "elements": [
                                                {"id": 0, "value": "Ni"},
                                                {"id": 1, "value": "Ni"},
                                                {"id": 2, "value": "Ni"},
                                            ],
                                            "coordinates": [
                                                {"id": 0, "value": [0, 0, 0.000001]},
                                                {"id": 1, "value": [0, 0, 0.333334333]},
                                                {"id": 2, "value": [0, 0, 0.666667667]},
                                            ],
                                            "units": "crystal",
                                            "labels": [],
                                            "constraints": [],
                                        },
                                        "lattice": {
                                            "a": 2.478974,
                                            "b": 2.478974,
                                            "c": 7.436922,
                                            "alpha": 120,
                                            "beta": 120,
                                            "gamma": 60,
                                            "units": {"length": "angstrom", "angle": "degree"},
                                            "type": "TRI",
                                        },
                                        "isNonPeriodic": False,
                                    },
                                    "type": "VacuumConfiguration",
                                },
                            ],
                            "direction": "z",
                            "type": "SlabStrainedSupercellConfiguration",
                            "gaps": [],
                        },
                        {
                            "xy_supercell_matrix": [[1, 0], [0, 1]],
                            "strain_matrix": [
                                [1.004735152845773, 0, 0],
                                [1.1601682219195737, 1.0047351528457729, 0],
                                [0, 0, 1],
                            ],
                            "stack_components": [
                                {
                                    "miller_indices": [0, 0, 1],
                                    "crystal": {
                                        "metadata": {"build": []},
                                        "name": "Graphene",
                                        "isDefault": False,
                                        "basis": {
                                            "elements": [{"id": 0, "value": "C"}, {"id": 1, "value": "C"}],
                                            "coordinates": [
                                                {"id": 0, "value": [0, 0, 0]},
                                                {"id": 1, "value": [0.333333, 0.666667, 0]},
                                            ],
                                            "units": "crystal",
                                            "labels": [],
                                            "constraints": [],
                                        },
                                        "lattice": {
                                            "a": 2.467291,
                                            "b": 2.467291,
                                            "c": 20,
                                            "alpha": 90,
                                            "beta": 90,
                                            "gamma": 120,
                                            "units": {"length": "angstrom", "angle": "degree"},
                                            "type": "HEX",
                                        },
                                        "isNonPeriodic": False,
                                    },
                                    "use_conventional_cell": True,
                                    "termination_top": {
                                        "chemical_elements": "C",
                                        "space_group_symmetry_label": "P6/mmm_2",
                                    },
                                    "number_of_repetitions": 1,
                                },
                                {
                                    "direction": "z",
                                    "size": 0,
                                    "crystal": {
                                        "metadata": {
                                            "build": [
                                                {
                                                    "configuration": {
                                                        "miller_indices": [0, 0, 1],
                                                        "crystal": {
                                                            "metadata": {"build": []},
                                                            "name": "Graphene",
                                                            "isDefault": False,
                                                            "basis": {
                                                                "elements": [
                                                                    {"id": 0, "value": "C"},
                                                                    {"id": 1, "value": "C"},
                                                                ],
                                                                "coordinates": [
                                                                    {"id": 0, "value": [0, 0, 0]},
                                                                    {"id": 1, "value": [0.333333, 0.666667, 0]},
                                                                ],
                                                                "units": "crystal",
                                                                "labels": [],
                                                                "constraints": [],
                                                            },
                                                            "lattice": {
                                                                "a": 2.467291,
                                                                "b": 2.467291,
                                                                "c": 20,
                                                                "alpha": 90,
                                                                "beta": 90,
                                                                "gamma": 120,
                                                                "units": {"length": "angstrom", "angle": "degree"},
                                                                "type": "HEX",
                                                            },
                                                            "isNonPeriodic": False,
                                                        },
                                                        "use_conventional_cell": True,
                                                        "termination_top": {
                                                            "chemical_elements": "C",
                                                            "space_group_symmetry_label": "P6/mmm_2",
                                                        },
                                                        "number_of_repetitions": 1,
                                                    },
                                                    "build_parameters": {},
                                                }
                                            ],
                                            "boundaryConditions": {"type": "pbc", "offset": 0},
                                        },
                                        "name": "C(001), termination C_P6/mmm_2",
                                        "isDefault": False,
                                        "formula": "C",
                                        "basis": {
                                            "elements": [{"id": 0, "value": "C"}, {"id": 1, "value": "C"}],
                                            "coordinates": [
                                                {"id": 0, "value": [0, 0, 0.000001]},
                                                {"id": 1, "value": [0.333333, 0.666667, 0.000001]},
                                            ],
                                            "units": "crystal",
                                            "labels": [],
                                            "constraints": [],
                                        },
                                        "lattice": {
                                            "a": 2.467291,
                                            "b": 2.467291,
                                            "c": 20,
                                            "alpha": 90,
                                            "beta": 90,
                                            "gamma": 120,
                                            "units": {"length": "angstrom", "angle": "degree"},
                                            "type": "TRI",
                                        },
                                        "isNonPeriodic": False,
                                    },
                                    "type": "VacuumConfiguration",
                                },
                            ],
                            "direction": "z",
                            "type": "SlabStrainedSupercellConfiguration",
                            "gaps": [],
                        },
                        {
                            "direction": "z",
                            "size": 10,
                            "crystal": {
                                "metadata": {
                                    "build": [
                                        {
                                            "configuration": {
                                                "miller_indices": [1, 1, 1],
                                                "crystal": {
                                                    "metadata": {"build": []},
                                                    "name": "Ni, Nickel, FCC (Fm-3m) 3D (Bulk), mp-23",
                                                    "isDefault": False,
                                                    "basis": {
                                                        "elements": [{"id": 0, "value": "Ni"}],
                                                        "coordinates": [{"id": 0, "value": [0, 0, 0]}],
                                                        "units": "crystal",
                                                        "labels": [],
                                                        "constraints": [],
                                                    },
                                                    "lattice": {
                                                        "a": 2.478974,
                                                        "b": 2.478974,
                                                        "c": 2.478974,
                                                        "alpha": 60,
                                                        "beta": 60,
                                                        "gamma": 60,
                                                        "units": {"length": "angstrom", "angle": "degree"},
                                                        "type": "FCC",
                                                    },
                                                    "external": {
                                                        "id": "mp-23",
                                                        "source": "Materials Project",
                                                        "origin": True,
                                                        "doi": "10.17188/1199153",
                                                        "url": "https://next-gen.materialsproject.org/materials/mp-23",
                                                    },
                                                    "isNonPeriodic": False,
                                                },
                                                "use_conventional_cell": True,
                                                "termination_top": {
                                                    "chemical_elements": "Ni",
                                                    "space_group_symmetry_label": "R-3m_4",
                                                },
                                                "number_of_repetitions": 3,
                                            },
                                            "build_parameters": {},
                                        },
                                        {
                                            "configuration": {
                                                "xy_supercell_matrix": [[1, 0], [0, 1]],
                                                "strain_matrix": [[1, 0, 0], [0, 1, 0], [0, 0, 1]],
                                                "stack_components": [
                                                    {
                                                        "miller_indices": [1, 1, 1],
                                                        "crystal": {
                                                            "metadata": {"build": []},
                                                            "name": "Ni, Nickel, FCC (Fm-3m) 3D (Bulk), mp-23",
                                                            "isDefault": False,
                                                            "basis": {
                                                                "elements": [{"id": 0, "value": "Ni"}],
                                                                "coordinates": [{"id": 0, "value": [0, 0, 0]}],
                                                                "units": "crystal",
                                                                "labels": [],
                                                                "constraints": [],
                                                            },
                                                            "lattice": {
                                                                "a": 2.478974,
                                                                "b": 2.478974,
                                                                "c": 2.478974,
                                                                "alpha": 60,
                                                                "beta": 60,
                                                                "gamma": 60,
                                                                "units": {"length": "angstrom", "angle": "degree"},
                                                                "type": "FCC",
                                                            },
                                                            "external": {
                                                                "id": "mp-23",
                                                                "source": "Materials Project",
                                                                "origin": True,
                                                                "doi": "10.17188/1199153",
                                                                "url": "https://next-gen.materialsproject.org/materials/mp-23",
                                                            },
                                                            "isNonPeriodic": False,
                                                        },
                                                        "use_conventional_cell": True,
                                                        "termination_top": {
                                                            "chemical_elements": "Ni",
                                                            "space_group_symmetry_label": "R-3m_4",
                                                        },
                                                        "number_of_repetitions": 3,
                                                    },
                                                    {
                                                        "direction": "z",
                                                        "size": 0,
                                                        "crystal": {
                                                            "metadata": {
                                                                "build": [
                                                                    {
                                                                        "configuration": {
                                                                            "miller_indices": [1, 1, 1],
                                                                            "crystal": {
                                                                                "metadata": {"build": []},
                                                                                "name": "Ni, Nickel, FCC (Fm-3m) 3D (Bulk), mp-23",
                                                                                "isDefault": False,
                                                                                "basis": {
                                                                                    "elements": [
                                                                                        {"id": 0, "value": "Ni"}
                                                                                    ],
                                                                                    "coordinates": [
                                                                                        {"id": 0, "value": [0, 0, 0]}
                                                                                    ],
                                                                                    "units": "crystal",
                                                                                    "labels": [],
                                                                                    "constraints": [],
                                                                                },
                                                                                "lattice": {
                                                                                    "a": 2.478974,
                                                                                    "b": 2.478974,
                                                                                    "c": 2.478974,
                                                                                    "alpha": 60,
                                                                                    "beta": 60,
                                                                                    "gamma": 60,
                                                                                    "units": {
                                                                                        "length": "angstrom",
                                                                                        "angle": "degree",
                                                                                    },
                                                                                    "type": "FCC",
                                                                                },
                                                                                "derivedProperties": None,
                                                                                "external": {
                                                                                    "id": "mp-23",
                                                                                    "source": "Materials Project",
                                                                                    "origin": True,
                                                                                    "data": None,
                                                                                    "doi": "10.17188/1199153",
                                                                                    "url": "https://next-gen.materialsproject.org/materials/mp-23",
                                                                                },
                                                                            },
                                                                            "use_conventional_cell": True,
                                                                            "termination_top": {
                                                                                "chemical_elements": "Ni",
                                                                                "space_group_symmetry_label": "R-3m_4",
                                                                            },
                                                                            "termination_bottom": None,
                                                                            "number_of_repetitions": 3,
                                                                        },
                                                                        "build_parameters": {},
                                                                    }
                                                                ],
                                                                "boundaryConditions": {"type": "pbc", "offset": 0},
                                                            },
                                                            "name": "Ni(111), termination Ni_R-3m_4",
                                                            "formula": "Ni",
                                                            "basis": {
                                                                "elements": [
                                                                    {"id": 0, "value": "Ni"},
                                                                    {"id": 1, "value": "Ni"},
                                                                    {"id": 2, "value": "Ni"},
                                                                ],
                                                                "coordinates": [
                                                                    {"id": 0, "value": [0, 0, 0.000001]},
                                                                    {"id": 1, "value": [0, 0, 0.333334333]},
                                                                    {"id": 2, "value": [0, 0, 0.666667667]},
                                                                ],
                                                                "units": "crystal",
                                                                "labels": [],
                                                                "constraints": [],
                                                            },
                                                            "lattice": {
                                                                "a": 2.478974,
                                                                "b": 2.478974,
                                                                "c": 7.436922,
                                                                "alpha": 120,
                                                                "beta": 120,
                                                                "gamma": 60,
                                                                "units": {"length": "angstrom", "angle": "degree"},
                                                                "type": "TRI",
                                                            },
                                                        },
                                                        "type": "VacuumConfiguration",
                                                    },
                                                ],
                                                "direction": "z",
                                                "type": "SlabStrainedSupercellConfiguration",
                                                "gaps": [],
                                            },
                                            "build_parameters": {
                                                "use_orthogonal_c": True,
                                                "xy_supercell_matrix": [[1, 0], [0, 1]],
                                            },
                                        },
                                    ],
                                    "boundaryConditions": {"type": "pbc", "offset": 0},
                                },
                                "name": "Ni(111), termination Ni_R-3m_4, Slab",
                                "formula": "Ni",
                                "basis": {
                                    "elements": [
                                        {"id": 0, "value": "Ni"},
                                        {"id": 1, "value": "Ni"},
                                        {"id": 2, "value": "Ni"},
                                    ],
                                    "coordinates": [
                                        {"id": 0, "value": [-0.000001, -0.000001, 0.000001]},
                                        {"id": 1, "value": [0.666665667, 0.666665667, 0.333334333]},
                                        {"id": 2, "value": [0.333332333, 0.333332333, 0.666667667]},
                                    ],
                                    "units": "crystal",
                                    "labels": [
                                        {"id": 0, "value": "0"},
                                        {"id": 1, "value": "0"},
                                        {"id": 2, "value": "0"},
                                    ],
                                    "constraints": [],
                                },
                                "lattice": {
                                    "a": 2.478974,
                                    "b": 2.478974,
                                    "c": 6.072221386,
                                    "alpha": 90,
                                    "beta": 90,
                                    "gamma": 59.999999999999986,
                                    "units": {"length": "angstrom", "angle": "degree"},
                                    "type": "TRI",
                                },
                            },
                            "type": "VacuumConfiguration",
                        },
                    ],
                    "direction": "z",
                    "xy_shift": [0, 0],
                    "type": "InterfaceConfiguration",
                    "gaps": [{"id": 0, "value": 3}, {"id": 1, "value": 3}],
                },
                "build_parameters": {},
            },
        ],
        "boundaryConditions": {"type": "pbc", "offset": 0},
    },
    "name": "C(001)-Ni(111), Interface, Strain 0.335pct",
    "basis": {
        "elements": [
            {"id": 0, "value": "Ni"},
            {"id": 1, "value": "Ni"},
            {"id": 2, "value": "Ni"},
            {"id": 3, "value": "C"},
            {"id": 4, "value": "C"},
        ],
        "coordinates": [
            {"id": 0, "value": [0.999999, 0.999999, 3.03e-7]},
            {"id": 1, "value": [0.666665667, 0.666665667, 0.100960811]},
            {"id": 2, "value": [0.333332333, 0.333332333, 0.201921319]},
            {"id": 3, "value": [0, 0, 0.351561882]},
            {"id": 4, "value": [0.666666, 0.666667, 0.351561882]},
        ],
        "units": "crystal",
        "labels": [
            {"id": 0, "value": 0},
            {"id": 1, "value": 0},
            {"id": 2, "value": 0},
            {"id": 3, "value": 1},
            {"id": 4, "value": 1},
        ],
        "constraints": [],
    },
    "lattice": {
        "a": 2.478974,
        "b": 2.478974,
        "c": 20.048173665,
        "alpha": 90,
        "beta": 90,
        "gamma": 60,
        "units": {"length": "angstrom", "angle": "degree"},
        "type": "TRI",
    },
}

DIAMOND_GaAs_INTERFACE = {
    "name": "AsGa(001)-C(001), Interface, Strain 7.114pct",
    "basis": {
        "elements": [
            {"id": 0, "value": "Ga"},
            {"id": 1, "value": "Ga"},
            {"id": 2, "value": "Ga"},
            {"id": 3, "value": "Ga"},
            {"id": 4, "value": "As"},
            {"id": 5, "value": "As"},
            {"id": 6, "value": "As"},
            {"id": 7, "value": "As"},
            {"id": 8, "value": "C"},
            {"id": 9, "value": "C"},
            {"id": 10, "value": "C"},
            {"id": 11, "value": "C"},
            {"id": 12, "value": "C"},
            {"id": 13, "value": "C"},
            {"id": 14, "value": "C"},
            {"id": 15, "value": "C"},
            {"id": 16, "value": "C"},
            {"id": 17, "value": "C"},
            {"id": 18, "value": "C"},
            {"id": 19, "value": "C"},
            {"id": 20, "value": "C"},
            {"id": 21, "value": "C"},
            {"id": 22, "value": "C"},
            {"id": 23, "value": "C"},
            {"id": 24, "value": "C"},
            {"id": 25, "value": "C"},
            {"id": 26, "value": "C"},
            {"id": 27, "value": "C"},
        ],
        "coordinates": [
            {"id": 0, "value": [0, 0, 0.208703663]},
            {"id": 1, "value": [0.5, 0, 0.352579044]},
            {"id": 2, "value": [0, 0.5, 0.352579044]},
            {"id": 3, "value": [0.5, 0.5, 0.208703663]},
            {"id": 4, "value": [0.75, 0.75, 0.280641354]},
            {"id": 5, "value": [0.25, 0.75, 0.424516735]},
            {"id": 6, "value": [0.75, 0.25, 0.424516735]},
            {"id": 7, "value": [0.25, 0.25, 0.280641354]},
            {"id": 8, "value": [0.1, 0.7, 0.133640341]},
            {"id": 9, "value": [0.2, 0.9, 0.08909362]},
            {"id": 10, "value": [0, 0, 0.044546899]},
            {"id": 11, "value": [0.1, 0.2, 1.78e-7]},
            {"id": 12, "value": [0.4, 0.8, 0.044546899]},
            {"id": 13, "value": [0.9, 0.8, 1.78e-7]},
            {"id": 14, "value": [0.3, 0.1, 0.133640341]},
            {"id": 15, "value": [0.8, 0.1, 0.08909362]},
            {"id": 16, "value": [0.9, 0.3, 0.133640341]},
            {"id": 17, "value": [0, 0.5, 0.08909362]},
            {"id": 18, "value": [0.8, 0.6, 0.044546899]},
            {"id": 19, "value": [0.2, 0.4, 0.044546899]},
            {"id": 20, "value": [0.7, 0.4, 1.78e-7]},
            {"id": 21, "value": [0.6, 0.7, 0.08909362]},
            {"id": 22, "value": [0.7, 0.9, 0.133640341]},
            {"id": 23, "value": [0.6, 0.2, 0.044546899]},
            {"id": 24, "value": [0.5, 0, 1.78e-7]},
            {"id": 25, "value": [0.4, 0.3, 0.08909362]},
            {"id": 26, "value": [0.5, 0.5, 0.133640341]},
            {"id": 27, "value": [0.3, 0.6, 1.78e-7]},
        ],
        "units": "crystal",
        "labels": [
            {"id": 0, "value": 1},
            {"id": 1, "value": 1},
            {"id": 2, "value": 1},
            {"id": 3, "value": 1},
            {"id": 4, "value": 1},
            {"id": 5, "value": 1},
            {"id": 6, "value": 1},
            {"id": 7, "value": 1},
            {"id": 8, "value": 0},
            {"id": 9, "value": 0},
            {"id": 10, "value": 0},
            {"id": 11, "value": 0},
            {"id": 12, "value": 0},
            {"id": 13, "value": 0},
            {"id": 14, "value": 0},
            {"id": 15, "value": 0},
            {"id": 16, "value": 0},
            {"id": 17, "value": 0},
            {"id": 18, "value": 0},
            {"id": 19, "value": 0},
            {"id": 20, "value": 0},
            {"id": 21, "value": 0},
            {"id": 22, "value": 0},
            {"id": 23, "value": 0},
            {"id": 24, "value": 0},
            {"id": 25, "value": 0},
            {"id": 26, "value": 0},
            {"id": 27, "value": 0},
        ],
        "constraints": [],
    },
    "lattice": {
        "a": 5.630032184,
        "b": 5.630032184,
        "c": 19.983204895,
        "alpha": 90,
        "beta": 90,
        "gamma": 90,
        "units": {"length": "angstrom", "angle": "degree"},
        "type": "TRI",
    },
}

DIAMOND_GaAs_INTERFACE_GH = {
    "name": "AsGa(001)-C(001), Interface, Strain 69.038pct",
    "basis": {
        "elements": [
            {"id": 0, "value": "Ga"},
            {"id": 1, "value": "Ga"},
            {"id": 2, "value": "Ga"},
            {"id": 3, "value": "Ga"},
            {"id": 4, "value": "As"},
            {"id": 5, "value": "As"},
            {"id": 6, "value": "As"},
            {"id": 7, "value": "As"},
            {"id": 8, "value": "C"},
            {"id": 9, "value": "C"},
            {"id": 10, "value": "C"},
            {"id": 11, "value": "C"},
            {"id": 12, "value": "C"},
            {"id": 13, "value": "C"},
            {"id": 14, "value": "C"},
            {"id": 15, "value": "C"},
            {"id": 16, "value": "C"},
            {"id": 17, "value": "C"},
            {"id": 18, "value": "C"},
            {"id": 19, "value": "C"},
            {"id": 20, "value": "C"},
            {"id": 21, "value": "C"},
            {"id": 22, "value": "C"},
            {"id": 23, "value": "C"},
            {"id": 24, "value": "C"},
            {"id": 25, "value": "C"},
            {"id": 26, "value": "C"},
            {"id": 27, "value": "C"},
        ],
        "coordinates": [
            {"id": 0, "value": [0.0, 0.0, 0.208703663]},
            {"id": 1, "value": [0.5, 0.0, 0.352579044]},
            {"id": 2, "value": [0.0, 0.5, 0.352579044]},
            {"id": 3, "value": [0.5, 0.5, 0.208703663]},
            {"id": 4, "value": [0.75, 0.25, 0.280641354]},
            {"id": 5, "value": [0.25, 0.25, 0.424516735]},
            {"id": 6, "value": [0.75, 0.75, 0.424516735]},
            {"id": 7, "value": [0.25, 0.75, 0.280641354]},
            {"id": 8, "value": [0.7, 0.9, 0.133640341]},
            {"id": 9, "value": [0.8, 0.1, 0.08909362]},
            {"id": 10, "value": [0.6, 0.2, 0.044546899]},
            {"id": 11, "value": [0.7, 0.4, 1.78e-07]},
            {"id": 12, "value": [0.0, 0.0, 0.044546899]},
            {"id": 13, "value": [0.5, 0.0, 1.78e-07]},
            {"id": 14, "value": [0.9, 0.3, 0.133640341]},
            {"id": 15, "value": [0.4, 0.3, 0.08909362]},
            {"id": 16, "value": [0.1, 0.7, 0.133640341]},
            {"id": 17, "value": [0.2, 0.9, 0.08909362]},
            {"id": 18, "value": [0.1, 0.2, 1.78e-07]},
            {"id": 19, "value": [0.4, 0.8, 0.044546899]},
            {"id": 20, "value": [0.9, 0.8, 1.78e-07]},
            {"id": 21, "value": [0.3, 0.1, 0.133640341]},
            {"id": 22, "value": [0.0, 0.5, 0.08909362]},
            {"id": 23, "value": [0.8, 0.6, 0.044546899]},
            {"id": 24, "value": [0.2, 0.4, 0.044546899]},
            {"id": 25, "value": [0.6, 0.7, 0.08909362]},
            {"id": 26, "value": [0.5, 0.5, 0.133640341]},
            {"id": 27, "value": [0.3, 0.6, 1.78e-07]},
        ],
        "units": "crystal",
        "labels": [
            {"id": 0, "value": 1},
            {"id": 1, "value": 1},
            {"id": 2, "value": 1},
            {"id": 3, "value": 1},
            {"id": 4, "value": 1},
            {"id": 5, "value": 1},
            {"id": 6, "value": 1},
            {"id": 7, "value": 1},
            {"id": 8, "value": 0},
            {"id": 9, "value": 0},
            {"id": 10, "value": 0},
            {"id": 11, "value": 0},
            {"id": 12, "value": 0},
            {"id": 13, "value": 0},
            {"id": 14, "value": 0},
            {"id": 15, "value": 0},
            {"id": 16, "value": 0},
            {"id": 17, "value": 0},
            {"id": 18, "value": 0},
            {"id": 19, "value": 0},
            {"id": 20, "value": 0},
            {"id": 21, "value": 0},
            {"id": 22, "value": 0},
            {"id": 23, "value": 0},
            {"id": 24, "value": 0},
            {"id": 25, "value": 0},
            {"id": 26, "value": 0},
            {"id": 27, "value": 0},
        ],
        "constraints": [],
    },
    "lattice": {
        "a": 5.630032184,
        "b": 5.630032184,
        "c": 19.983204895,
        "alpha": 90.0,
        "beta": 90.0,
        "gamma": 90.0,
        "units": {"length": "angstrom", "angle": "degree"},
        "type": "TRI",
    },
}
