### 🏗️ Архитектура классов

#### Иерархия основных классов
```python
# Основной клиент
YandexTrackerClient (base.py)
├── _session: aiohttp.ClientSession      # HTTP сессия
├── _oauth_token: str                    # OAuth токен
├── _org_id: str                         # ID организации
├── _base_url: str                       # Базовый URL API
├── logger: logging.Logger               # Логгер
├── issues                               # Модуль для работы с задачами
├── entities                             # Модуль для работы с сущностями
├── users                                # Модуль для работы с пользователями
└── queues                               # Модуль для работы с очередями

# Абстрактный базовый класс
BaseAPI (base.py)
├── client: YandexTrackerClient         # Ссылка на основной клиент
├── logger: logging.Logger              # Логгер из клиента
└── _request()                          # Базовый метод для HTTP запросов

# API модули (наследуются от BaseAPI)
IssuesAPI (issues/api.py)               # Основной модуль для задач
├── get()           # Получение задачи по ID
├── create()        # Создание новой задачи
├── update()        # Обновление задачи
├── move()          # Перенос задачи в другую очередь
├── count()         # Подсчет задач
├── search()        # Поиск задач
├── priorities()    # Получение приоритетов
├── changelog()     # История изменений
├── clear_scroll()  # Очистка scroll контекста
├── links           # Подмодуль управления связями
├── transitions     # Подмодуль управления переходами
├── checklists      # Подмодуль управления чеклистами
├── fields          # Подмодуль управления полями
└── comments        # Подмодуль управления комментариями

LinksAPI (issues/links.py)              # Управление связями задач
├── get()           # Получение связей задачи
├── create()        # Создание связи
└── delete()        # Удаление связи

TransitionsAPI (issues/transitions.py)  # Управление переходами
├── get()           # Получение доступных переходов
└── update()        # Выполнение перехода

ChecklistAPI (issues/checklists.py)     # Управление чеклистами
├── get()           # Получение чеклистов
├── create()        # Создание элемента чеклиста
├── delete()        # Удаление всех элементов чеклиста
└── item            # Подмодуль для работы с отдельными пунктами
    └── ChecklistItemAPI (issues/checklist_item.py)
        ├── update() # Обновление отдельного элемента чеклиста
        └── delete() # Удаление отдельного элемента чеклиста

CommentsAPI (issues/comments.py)         # Управление комментариями задач
├── get()           # Получение списка комментариев задачи
├── update()        # Обновление существующего комментария
├── delete()        # Удаление комментария
└── create()        # Создание комментария к задаче

FieldsAPI (fields/api.py)               # Управление полями и категориями
├── get()           # Получение списка полей / конкретного поля
├── create()        # Создание кастомного поля
├── update()        # Обновление кастомного поля
├── create_category() # Создание категории полей
└── local           # Подмодуль локальных полей
    └── LocalFieldsAPI (fields/local.py)
        ├── get()    # Получение локальных полей очереди / конкретного поля
        ├── create() # Создание локального поля в очереди
        └── update() # Обновление локального поля в очереди

EntitiesAPI (entities/api.py)          # Управление сущностями (проекты, портфели, цели)
├── get()           # Получение информации о сущности
├── create()        # Создание новой сущности
├── update()        # Обновление сущности
├── delete()        # Удаление сущности (с параметром withBoard)
├── search()        # Поиск сущностей с фильтрацией и пагинацией
├── changelog()     # Получение истории изменений сущности
├── checklists      # Подмодуль управления чеклистами сущностей
│   └── EntityChecklistsAPI (entities/checklists.py)
│       ├── create()     # Создание пункта чеклиста сущности
│       ├── update()     # Массовое обновление пунктов чеклиста
│       └── item         # Подмодуль для работы с отдельными пунктами
│           └── ChecklistItemAPI (entities/checklist_item.py)
│               ├── update() # Обновление отдельного пункта чеклиста
│               ├── move()   # Перемещение пункта чеклиста
│               └── delete() # Удаление отдельного пункта чеклиста
├── bulk            # Подмодуль для массовых операций
│   └── BulkAPI (entities/bulk.py)
│       └── update() # Массовое обновление сущностей
└── links           # Подмодуль управления связями сущностей
    └── LinksAPI (entities/links.py)
        ├── create() # Создание связи между сущностями
        ├── get()    # Получение связей сущности
        └── delete() # Удаление связи между сущностями

UsersAPI (users/api.py)              # Управление пользователями
└── get()           # Получение списка пользователей или конкретного пользователя

QueuesAPI (queues/api.py)            # Управление очередями
├── get()           # Получение информации об очереди или списке очередей
├── create()        # Создание новой очереди
├── delete()        # Удаление очереди
├── restore()       # Восстановление удаленной очереди
├── versions        # Подмодуль управления версиями очередей
│   └── VersionsAPI (queues/versions.py)
│       ├── create() # Создание версии в очереди
│       └── get()    # Получение списка версий очереди
├── fields          # Подмодуль полей очередей
│   └── FieldsAPI (queues/fields.py)
│       └── get()    # Получение списка полей очереди
├── tags            # Подмодуль тегов очередей
│   └── TagsAPI (queues/tags.py)
│       ├── get()    # Получение списка тегов очереди
│       └── delete() # Удаление тега из очереди
├── bulk            # Подмодуль массового управления доступом
│   └── BulkAPI (queues/bulk.py)
│       └── update() # Массовое изменение доступа к очереди
├── user            # Подмодуль доступа пользователя
│   └── UserAPI (queues/user.py)
│       └── get()    # Получение прав доступа пользователя к очереди
└── group           # Подмодуль доступа группы
    └── GroupAPI (queues/group.py)
        └── get()    # Получение прав доступа группы к очереди
```

#### Принципы архитектуры
- **Модульность**: каждый API модуль отвечает за свою область функциональности
- **Lazy loading**: модули создаются только при первом обращении через @property
- **Единообразие**: все модули наследуются от BaseAPI и используют общий _request()
- **Иерархичность**: подмодули (links, transitions, checklists, fields) вложены в основной IssuesAPI