## Структура проекта

```
ya_tracker_test/
├── .env                    # Переменные окружения (не в git)
├── .git/                   # Git репозиторий
├── .gitignore             # Игнорируемые файлы
├── .python-version        # Версия Python (3.13)
├── .venv/                 # Виртуальное окружение
├── __pycache__/           # Кешированные модули Python
├── YaTrackerApi/          # ОСНОВНОЙ ПАКЕТ API КЛИЕНТА
│   ├── __init__.py        # Экспорт YandexTrackerClient
│   ├── base.py            # Базовые классы (YandexTrackerClient + BaseAPI)
│   ├── issues/            # Модуль для работы с задачами
│   │   ├── __init__.py    # Экспорт IssuesAPI
│   │   ├── api.py         # Основной API для задач (CRUD + Search + Workflow)
│   │   ├── links.py       # API для связей между задачами (GET + POST + DELETE)
│   │   ├── transitions.py # API для переходов жизненного цикла (GET + POST)
│   │   ├── checklists.py  # API для чеклистов задач (GET + CREATE + DELETE + подмодуль item)
│   │   ├── checklist_item.py # API для отдельных пунктов чеклистов задач (UPDATE + DELETE)
│   │   └── comments.py    # API для комментариев задач (CREATE)
│   ├── fields/            # Модуль для работы с полями
│   │   ├── __init__.py    # Экспорт FieldsAPI
│   │   ├── api.py         # API для полей задач (GET + POST + PATCH + категории)
│   │   └── local.py       # API для локальных полей в очередях (GET + POST + PATCH)
│   ├── entities/          # Модуль для работы с сущностями
│   │   ├── __init__.py    # Экспорт EntitiesAPI
│   │   ├── api.py         # API для сущностей: проекты, портфели, цели (CRUD + Search + Changelog)
│   │   ├── checklists.py  # API для чеклистов сущностей (CREATE + BULK UPDATE)
│   │   ├── checklist_item.py # API для отдельных пунктов чеклистов (UPDATE + MOVE + DELETE)
│   │   ├── bulk.py        # API для массовых операций (UPDATE)
│   │   └── links.py       # API для связей между сущностями (CREATE + GET + DELETE)
│   ├── users/             # Модуль для работы с пользователями
│   │   ├── __init__.py    # Экспорт UsersAPI
│   │   └── api.py         # API для пользователей (GET + GET_USER)
│   └── queues/            # Модуль для работы с очередями
│       ├── __init__.py    # Экспорт QueuesAPI
│       ├── api.py         # API для очередей (CRUD)
│       ├── versions.py    # API для версий очередей (CREATE + GET)
│       ├── fields.py      # API для полей очередей (GET)
│       ├── tags.py        # API для тегов очередей (GET + DELETE)
│       ├── bulk.py        # API для массового управления доступом (UPDATE)
│       ├── user.py        # API для получения доступа пользователя (GET)
│       └── group.py       # API для получения доступа группы (GET)
├── context/               # Контекстная документация для AI
│   ├── general.md         # Индекс контекстных файлов
│   ├── claseses.md        # Архитектура классов
│   ├── tech.md            # Технологические принципы
│   ├── data.md            # Структуры данных и типизация
│   ├── history.md         # История версий проекта
│   └── files.md           # Структура файлов (этот файл)
├── env.py                 # Загрузка переменных окружения
├── main.py                # Файл для тестирования (НЕ ТРОГАТЬ!)
├── pyproject.toml         # Конфигурация проекта (uv)
├── uv.lock                # Заблокированные зависимости
├── README.md              # Пользовательская документация
└── CLAUDE.MD              # Инструкции для Claude
```

### Описание ключевых файлов

#### Основные файлы проекта
- **YaTrackerApi/__init__.py**: Единственная точка входа, экспортирует YandexTrackerClient
- **YaTrackerApi/base.py**: Основной клиент и абстрактный класс BaseAPI
- **env.py**: Загрузка и валидация переменных окружения (.env файл)
- **main.py**: Файл для ручного тестирования (не модифицировать!)

#### API модули
- **YaTrackerApi/issues/**: Модуль для работы с задачами
  - **api.py**: Основной API задач (13 методов)
  - **links.py**: Управление связями между задачами (3 метода)
  - **transitions.py**: Управление переходами статусов (2 метода)
  - **checklists.py**: Управление чеклистами задач (3 метода + подмодуль item)
  - **checklist_item.py**: Управление отдельными пунктами чеклистов задач (2 метода)
  - **comments.py**: Управление комментариями задач (4 метода: get, update, delete, create)
- **YaTrackerApi/fields/**: Модуль для работы с полями
  - **api.py**: Управление полями задач (4 метода + подмодуль local)
  - **local.py**: Управление локальными полями в очередях (3 метода)
- **YaTrackerApi/entities/**: Модуль для работы с сущностями
  - **api.py**: Управление сущностями - проекты, портфели, цели (6 методов: CRUD + Search + Changelog)
  - **checklists.py**: Управление чеклистами сущностей (2 метода: create, update + подмодуль item)
  - **checklist_item.py**: Управление отдельными пунктами чеклистов сущностей (3 метода: update, move, delete)
  - **bulk.py**: Массовые операции с сущностями (1 метод: update)
  - **links.py**: Управление связями между сущностями (3 метода: create, get, delete)
- **YaTrackerApi/users/**: Модуль для работы с пользователями
  - **api.py**: Управление пользователями (1 метод: get - универсальный)
- **YaTrackerApi/queues/**: Модуль для работы с очередями
  - **api.py**: Управление очередями (4 метода: create, get, delete, restore)
  - **versions.py**: Управление версиями очередей (2 метода: create, get)
  - **fields.py**: Получение полей очередей (1 метод: get)
  - **tags.py**: Управление тегами очередей (2 метода: get, delete)
  - **bulk.py**: Массовое управление доступом к очередям (1 метод: update)
  - **user.py**: Получение доступа пользователя к очереди (1 метод: get)
  - **group.py**: Получение доступа группы к очереди (1 метод: get)

#### Конфигурационные файлы
- **pyproject.toml**: Конфигурация проекта для uv (зависимости, метаданные)
- **.python-version**: Фиксированная версия Python (3.13)
- **.env**: Секретные переменные (API ключи, не в git)
- **.gitignore**: Игнорируемые git файлы

#### Документация
- **context/**: Структурированная документация для AI агентов
- **README.md**: Пользовательская документация с примерами
- **CLAUDE.MD**: Специальные инструкции для Claude