"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instances = exports.InstancesProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const swas_generated_1 = require("./swas.generated");
Object.defineProperty(exports, "InstancesProperty", { enumerable: true, get: function () { return swas_generated_1.RosInstances; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::SWAS::Instances`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosInstances`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-swas-instances
 */
class Instances extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosInstances = new swas_generated_1.RosInstances(this, id, {
            autoRenewPeriod: props.autoRenewPeriod,
            planId: props.planId,
            autoRenew: props.autoRenew,
            amount: props.amount,
            imageId: props.imageId,
            period: props.period,
            dataDiskSize: props.dataDiskSize,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstances;
        this.attrInnerIpAddresses = rosInstances.attrInnerIpAddresses;
        this.attrInstanceIds = rosInstances.attrInstanceIds;
        this.attrPublicIpAddresses = rosInstances.attrPublicIpAddresses;
    }
}
exports.Instances = Instances;
//# sourceMappingURL=data:application/json;base64,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