# generated by datamodel-codegen:
#   filename:  schema.json
#   timestamp: 2025-06-12T11:04:46+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, List, Optional, Set

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, constr


class Scope(Enum):
    specific = "specific"
    broad = "broad"


class Category(Enum):
    confirmed = "confirmed"
    probable = "probable"
    suspected = "suspected"


class Reference(BaseModel):
    citation: Optional[str] = None
    url: AnyUrl


class Status(Enum):
    draft = "draft"
    published = "published"
    deprecated = "deprecated"


class Type(Enum):
    criterion = "criterion"
    syndrome = "syndrome"
    symptom = "symptom"
    diagnosis = "diagnosis"
    diagnostic_test = "diagnostic_test"
    professional_judgment = "professional_judgment"
    epidemiological_history = "epidemiological_history"
    demographic_criteria = "demographic_criteria"


class LogicalOperator(Enum):
    AND = "AND"
    OR = "OR"
    AND_NOT = "AND_NOT"
    AT_LEAST = "AT_LEAST"


class Operator(Enum):
    field_ = ">"
    field__ = ">="
    field__1 = "<"
    field___1 = "<="
    field___2 = "=="
    field___3 = "!="
    regex = "regex"


class Code(BaseModel):
    system: str = Field(
        ..., description="The diagnosis system used.", examples=["ICD-10", "SNOMED-CT"]
    )
    code: str = Field(..., examples=["J11", "A.99", "233604007"])
    display: Optional[str] = Field(
        None,
        description="A label that represents this code.",
        examples=["Pneumonia", "Dengue"],
    )


class OpenSyndromeCaseDefinitionSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    title: str = Field(..., description="Title of the case definition.")
    description: Optional[str] = Field(
        None, description="Detailed description of a case definition."
    )
    scope: Scope = Field(
        ...,
        description="A broad definition aims to capture most or all true cases, while a specific definition provides a more accurate description but risks missing some true cases.",
    )
    category: Optional[Category] = Field(
        "suspected",
        description="Case definition categories according to Bassil, K. (2008). Case definition. In Encyclopedia of epidemiology (Vol. 2, pp. 133-134). SAGE Publications, Inc., https://doi.org/10.4135/9781412953948",
    )
    version: constr(pattern=r"^\d+\.\d+\.\d+$") = Field(
        ...,
        description="Case definition version to be defined by the author but following the Semantic Versioning Specification (https://semver.org/).",
    )
    open_syndrome_version: constr(pattern=r"^\d+\.\d+\.\d+$") = Field(
        ..., description="Open Syndrome Definition schema version.", examples=["1.0.0"]
    )
    published_in: AnyUrl = Field(
        ...,
        description="URL where the narrative format definition was originally published or can be found.",
    )
    published_at: datetime = Field(
        ...,
        description="Date and time of publication at Open Syndrome Initiative website (UTC).",
        examples=["2020-05-30T12:00:00Z"],
    )
    published_by: Optional[List[str]] = Field(
        None,
        description="List of the case definition publishers in the Open Syndrome Initiative.",
        examples=[
            ["Ana Maria Braga"],
            [
                "Oswaldo Gonçalves Cruz",
                "Bento Gonçalves Cruz",
                "Amália Taborda de Bulhões Cruz",
            ],
        ],
    )
    location: str = Field(
        ...,
        description="Free text for location input; recommended format is 'City, State/Region, Country' following geographical hierarchy with comma separation",
        examples=["Salvador, Bahia, Brasil", "Berlin, Germany", "Nigeria"],
    )
    language: str = Field(
        ...,
        description="Written language",
        examples=["English", "Brazilian Portuguese"],
    )
    organization: str = Field(
        ...,
        description="The organization responsible for this case definition maintenance.",
        examples=[
            "Ministry of Health",
            "The Epidemic Intelligence from Open Sources Initiative",
        ],
    )
    authors: Optional[List[str]] = Field(
        None,
        description="People or organizations that authored this case definition.",
        examples=[
            ["Ana Maria Braga"],
            [
                "Oswaldo Gonçalves Cruz",
                "Bento Gonçalves Cruz",
                "Amália Taborda de Bulhões Cruz",
            ],
        ],
    )
    inclusion_criteria: List[Criterion]
    exclusion_criteria: Optional[List[Criterion]] = None
    notes: Optional[List[str]] = Field(
        None, description="Any notes that may be relevant to this case definition."
    )
    references: List[Reference] = Field(
        ...,
        description="References which have supported this definition followed by a URL.",
    )
    status: Optional[Status] = Field(
        "draft",
        description="Current status of this definition in the Open Syndrome Initiative platform.",
    )
    keywords: Optional[List[str]] = Field(
        None,
        description="Keywords related to a definition.",
        examples=["outbreaks", "covid19", "WHO"],
    )
    human_readable_definition: Optional[str] = Field(
        None,
        description="A human-readable definition of the case definition, which can be used for display purposes in user interfaces.",
    )
    target_public_health_threats: Optional[List[str]] = Field(
        None,
        description="List of public health threats that this case definition targets.",
    )


class Criterion(BaseModel):
    type: Type = Field(
        ...,
        description="Type of criterion.\n\n- criteria: Group of criteria or conditions.\n- syndrome: Syndrome (defined by another definition, but used here as a criterion).\n- symptom: just a symptom.\n- diagnosis: The diagnosed disease, which may or may not be followed by a code, e.g. ICD.\n- diagnostic_test: Tests or medical examinations to confirm a diagnosis, e.g. gluplasma glucose.\n- professional_judgment: Professional assessment.\n- epidemiological_history: Travel history or contact with someone with an epidemiological link.\n- demographic_criteria: Factors such as age or sex.",
    )
    logical_operator: Optional[LogicalOperator] = Field(
        None,
        description="Keywords that represent a logical operation on criteria.\n\nAND: All conditions in this group must be satisfied (true).\nOR: At least one condition in this group must be satisfied.\nAND_NOT: All conditions in this group must not be satisfied (must be false).\nAT_LEAST: Used with the number specified in `logical_operator_arguments`. At least that many conditions must be true.",
    )
    logical_operator_arguments: Optional[List[int]] = Field(
        None,
        description="Used with `logical_operator = AT_LEAST`. At least that many conditions must be true.",
        max_length=1,
        min_length=1,
    )
    name: str = Field(..., description="Criterion label.")
    attribute: Optional[str] = Field(
        None,
        description="The referred attribute.",
        examples=["body_temperature", "age", "onset"],
    )
    value: Optional[Any] = Field(
        None,
        description="The reference value for the referred attribute. It has no type because it could be anything.",
        examples=[True, 37.5, "abnormal but non-specific bowel gas pattern"],
    )
    description: Optional[str] = Field(
        None, description="A detailed description of the criterion."
    )
    operator: Optional[Operator] = Field(
        None,
        description="Comparison operators.\n\n>: Value must be greater than the specified threshold.\n>=: Value must be greater than or equal to the specified threshold.\n<: Value must be less than the specified threshold.\n<=: Value must be less than or equal to the specified threshold.\n==: Value must exactly match the specified value.\n!=: Value must not match the specified value.\nregex: Value must match the specified regular expression pattern.",
    )
    regex_pattern: Optional[str] = Field(
        None,
        description="Regular expression for evaluation and pattern matching.",
        examples=["deng[u]?e"],
    )
    regex_flags: Optional[constr(pattern=r"^[gimsuy]*$")] = Field(
        None,
        description="Regular expression flags for extra configuration.",
        examples=["i"],
    )
    code: Optional[Code] = Field(None, description="System agnostic diagnosis code.")
    values: Optional[Set[Criterion]] = None


OpenSyndromeCaseDefinitionSchema.model_rebuild()
